/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.coupling;

import com.google.common.collect.ImmutableList;
import com.railwayteam.railways.content.coupling.coupler.TrackCouplerTileEntity;
import com.simibubi.create.content.logistics.block.display.DisplayLinkContext;
import com.simibubi.create.content.logistics.block.display.source.BoilerDisplaySource;
import com.simibubi.create.content.logistics.block.display.source.DisplaySource;
import com.simibubi.create.content.logistics.block.display.target.DisplayTargetStats;
import com.simibubi.create.content.logistics.trains.management.display.FlapDisplayLayout;
import com.simibubi.create.content.logistics.trains.management.display.FlapDisplaySection;
import com.simibubi.create.content.logistics.trains.management.display.FlapDisplayTileEntity;
import com.simibubi.create.foundation.utility.Components;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.block.entity.BlockEntity;

public class TrackCouplerDisplaySource
extends DisplaySource {
    public List<MutableComponent> provideText(DisplayLinkContext context, DisplayTargetStats stats) {
        if (stats.maxRows() < 2) {
            return BoilerDisplaySource.notEnoughSpaceSingle;
        }
        BlockEntity blockEntity = context.getSourceTE();
        if (!(blockEntity instanceof TrackCouplerTileEntity)) {
            return EMPTY;
        }
        TrackCouplerTileEntity te = (TrackCouplerTileEntity)blockEntity;
        TrackCouplerTileEntity.OperationInfo info = te.getOperationInfo();
        switch (info.mode()) {
            case NONE: {
                return ImmutableList.of((Object)Components.translatable((String)"railways.display_source.coupler.no_action").m_130940_(ChatFormatting.BOLD));
            }
            case COUPLING: {
                return ImmutableList.of((Object)Components.translatable((String)"railways.display_source.coupler.coupling").m_7220_(info.frontCarriage().train.name), (Object)Components.translatable((String)"railways.display_source.coupler.coupling.to").m_7220_(info.backCarriage().train.name));
            }
            case DECOUPLING: {
                return ImmutableList.of((Object)Components.translatable((String)"railways.display_source.coupler.decoupling").m_7220_(info.frontCarriage().train.name));
            }
        }
        return null;
    }

    protected String getTranslationKey() {
        return "track_coupler_info";
    }

    public void loadFlapDisplayLayout(DisplayLinkContext context, FlapDisplayTileEntity flapDisplay, FlapDisplayLayout layout) {
        if (!layout.isLayout("Default")) {
            layout.configure("Default", (List)ImmutableList.of((Object)this.createSectionForValue(context, flapDisplay.getMaxCharCount())));
        }
    }

    protected FlapDisplaySection createSectionForValue(DisplayLinkContext context, int size) {
        return new FlapDisplaySection((float)size * 7.0f, "alphabet", false, false);
    }

    public int getPassiveRefreshTicks() {
        return 40;
    }
}

