/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.coupling.coupler;

import com.mojang.blaze3d.vertex.PoseStack;
import com.railwayteam.railways.content.coupling.CustomTrackOverlayRendering;
import com.railwayteam.railways.content.coupling.coupler.TrackCoupler;
import com.railwayteam.railways.content.coupling.coupler.TrackCouplerTileEntity;
import com.railwayteam.railways.registry.CRBlockPartials;
import com.simibubi.create.content.logistics.trains.GraphLocation;
import com.simibubi.create.content.logistics.trains.ITrackBlock;
import com.simibubi.create.content.logistics.trains.TrackEdge;
import com.simibubi.create.content.logistics.trains.TrackNodeLocation;
import com.simibubi.create.content.logistics.trains.management.edgePoint.TrackTargetingBehaviour;
import com.simibubi.create.content.logistics.trains.management.edgePoint.signal.TrackEdgePoint;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.renderer.SmartTileEntityRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class TrackCouplerRenderer
extends SmartTileEntityRenderer<TrackCouplerTileEntity> {
    public TrackCouplerRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(TrackCouplerTileEntity te, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        super.renderSafe((SmartTileEntity)te, partialTicks, ms, buffer, light, overlay);
        this.renderEdgePoint(te, ms, buffer, light, overlay, te.edgePoint);
        this.renderEdgePoint(te, ms, buffer, light, overlay, te.secondEdgePoint);
    }

    private void renderEdgePoint(TrackCouplerTileEntity te, PoseStack ms, MultiBufferSource buffer, int light, int overlay, TrackTargetingBehaviour<TrackCoupler> target) {
        BlockPos pos = te.m_58899_();
        boolean offsetToSide = false;
        try {
            GraphLocation graphLocation = target.determineGraphLocation();
            TrackEdge edge = (TrackEdge)graphLocation.graph.getConnectionsFrom(graphLocation.graph.locateNode((TrackNodeLocation)graphLocation.edge.getFirst())).get(graphLocation.graph.locateNode((TrackNodeLocation)graphLocation.edge.getSecond()));
            for (TrackEdgePoint edgePoint : edge.getEdgeData().getPoints()) {
                try {
                    double d = edgePoint.getLocationOn(edge);
                    double d2 = target.getEdgePoint() != null ? ((TrackCoupler)target.getEdgePoint()).getLocationOn(edge) : graphLocation.position;
                    if (!(Math.abs(d - d2) < 0.75) || edgePoint == target.getEdgePoint()) continue;
                    offsetToSide = true;
                    break;
                }
                catch (Exception exception) {
                }
            }
        }
        catch (Exception graphLocation) {
            // empty catch block
        }
        BlockPos targetPosition = target.getGlobalPosition();
        Level level = te.m_58904_();
        BlockState trackState = level.m_8055_(targetPosition);
        Block block = trackState.m_60734_();
        if (!(block instanceof ITrackBlock)) {
            return;
        }
        ms.m_85836_();
        ms.m_85837_((double)(-pos.m_123341_()), (double)(-pos.m_123342_()), (double)(-pos.m_123343_()));
        CustomTrackOverlayRendering.renderOverlay((LevelAccessor)level, targetPosition, target.getTargetDirection(), target.getTargetBezier(), ms, buffer, light, overlay, te.areEdgePointsOk() ? CustomTrackOverlayRendering.getCouplerOverlayModel(te.getAllowedOperationMode().canCouple, te.getAllowedOperationMode().canDecouple) : CRBlockPartials.COUPLER_NONE, 1.0f, offsetToSide);
        ms.m_85849_();
    }
}

