/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.coupling.coupler;

import com.railwayteam.railways.content.coupling.TrainUtils;
import com.railwayteam.railways.content.coupling.coupler.SecondaryTrackTargetingBehaviour;
import com.railwayteam.railways.content.coupling.coupler.TrackCoupler;
import com.railwayteam.railways.content.coupling.coupler.TrackCouplerBlock;
import com.railwayteam.railways.content.custom_bogeys.monobogey.IPotentiallyUpsideDownBogeyBlock;
import com.railwayteam.railways.mixin.AccessorCarriageBogey;
import com.railwayteam.railways.mixin.AccessorTrackTargetingBehavior;
import com.railwayteam.railways.registry.CREdgePointTypes;
import com.railwayteam.railways.registry.CRPackets;
import com.railwayteam.railways.util.packet.TrackCouplerClientInfoPacket;
import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.components.structureMovement.ITransformableTE;
import com.simibubi.create.content.contraptions.components.structureMovement.StructureTransform;
import com.simibubi.create.content.contraptions.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.logistics.trains.IBogeyBlock;
import com.simibubi.create.content.logistics.trains.ITrackBlock;
import com.simibubi.create.content.logistics.trains.TrackNodeLocation;
import com.simibubi.create.content.logistics.trains.entity.Carriage;
import com.simibubi.create.content.logistics.trains.entity.CarriageBogey;
import com.simibubi.create.content.logistics.trains.entity.Train;
import com.simibubi.create.content.logistics.trains.entity.TravellingPoint;
import com.simibubi.create.content.logistics.trains.management.edgePoint.TrackTargetingBehaviour;
import com.simibubi.create.content.logistics.trains.management.edgePoint.signal.SignalBlock;
import com.simibubi.create.content.logistics.trains.track.TrackBlock;
import com.simibubi.create.content.logistics.trains.track.TrackShape;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.CenteredSideValueBoxTransform;
import com.simibubi.create.foundation.tileEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.ScrollValueBehaviour;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.LangBuilder;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class TrackCouplerTileEntity
extends SmartTileEntity
implements ITransformableTE,
IHaveGoggleInformation {
    private BlockState cachedTrackState = null;
    private BlockState cachedSecondaryTrackState = null;
    private boolean edgePointsOk = false;
    private boolean lastReportedPower = false;
    private int lastAnalogOutput = 0;
    protected int edgeSpacing = 5;
    private int lastEdgeSpacing = 5;
    private MutableComponent error = null;
    private ClientInfo clientInfo;
    public TrackTargetingBehaviour<TrackCoupler> edgePoint;
    public TrackTargetingBehaviour<TrackCoupler> secondEdgePoint;
    protected ScrollValueBehaviour edgeSpacingScroll;

    public TrackCouplerTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        tag.m_128379_("EdgePointsOk", this.edgePointsOk);
        tag.m_128379_("Power", this.lastReportedPower);
        tag.m_128405_("AnalogOutput", this.lastAnalogOutput);
        tag.m_128405_("EdgeSpacing", this.edgeSpacing);
        tag.m_128405_("LastEdgeSpacing", this.lastEdgeSpacing);
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.edgePointsOk = tag.m_128471_("EdgePointsOk");
        this.lastReportedPower = tag.m_128471_("Power");
        this.lastAnalogOutput = tag.m_128451_("AnalogOutput");
        this.edgeSpacing = tag.m_128451_("EdgeSpacing");
        this.lastEdgeSpacing = tag.m_128451_("LastEdgeSpacing");
        this.edgeSpacingScroll.setValue(this.edgeSpacing);
        this.invalidateRenderBoundingBox();
    }

    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        this.edgePoint = new TrackTargetingBehaviour((SmartTileEntity)this, CREdgePointTypes.COUPLER);
        behaviours.add((TileEntityBehaviour)this.edgePoint);
        this.secondEdgePoint = new SecondaryTrackTargetingBehaviour<TrackCoupler>(this, CREdgePointTypes.COUPLER);
        behaviours.add((TileEntityBehaviour)this.secondEdgePoint);
        this.edgeSpacingScroll = new ScrollValueBehaviour((Component)Components.translatable((String)"railways.coupler.edge_spacing"), (SmartTileEntity)this, (ValueBoxTransform)new TrackCouplerValueBoxTransform(true));
        this.edgeSpacingScroll.between(3, 10);
        this.edgeSpacingScroll.withUnit(i -> Components.translatable((String)"railways.coupler.edge_spacing.meters"));
        this.edgeSpacingScroll.withFormatter(i -> i + "m");
        this.edgeSpacingScroll.withCallback(i -> {
            this.edgeSpacing = i;
        });
        this.edgeSpacingScroll.requiresWrench();
        behaviours.add((TileEntityBehaviour)this.edgeSpacingScroll);
    }

    public void tick() {
        super.tick();
        if (this.f_58857_.m_5776_()) {
            return;
        }
        BlockState blockState = this.m_58900_();
        blockState.m_61145_((Property)SignalBlock.POWERED).ifPresent(powered -> {
            if (this.lastReportedPower == powered) {
                return;
            }
            this.lastReportedPower = powered;
            if (powered.booleanValue()) {
                this.onPowered();
            } else {
                this.onUnpowered();
            }
            this.notifyUpdate();
        });
        if (this.getTargetAnalogOutput() != this.lastAnalogOutput) {
            this.lastAnalogOutput = this.getTargetAnalogOutput();
            this.f_58857_.m_46717_(this.m_58899_(), this.m_58900_().m_60734_());
        }
    }

    protected void onPowered() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        OperationInfo info = this.getOperationInfo();
        switch (info.mode) {
            case DECOUPLING: {
                Train train = info.frontCarriage.train;
                int numberOffEnd = train.carriages.size() - train.carriages.indexOf(info.backCarriage);
                TrainUtils.splitTrain(train, numberOffEnd);
                break;
            }
            case COUPLING: {
                Train frontTrain = info.frontCarriage.train;
                Train backTrain = info.backCarriage.train;
                if (frontTrain == backTrain) break;
                TrainUtils.combineTrains(frontTrain, backTrain, this.m_58899_().m_7494_(), this.f_58857_, this.getEdgeSpacing());
                break;
            }
        }
    }

    protected void onUnpowered() {
    }

    public boolean getReportedPower() {
        return this.lastReportedPower;
    }

    public int getEdgeSpacing() {
        return this.edgeSpacing;
    }

    private Optional<BlockPos> getDesiredSecondaryEdgePos() {
        BlockState trackState = this.edgePoint.getTrackBlockState();
        if (!trackState.m_61138_((Property)TrackBlock.SHAPE)) {
            return Optional.empty();
        }
        double distance = -this.getEdgeSpacing() * this.edgePoint.getTargetDirection().m_122540_();
        Vec3 offset = ((Vec3)((TrackShape)trackState.m_61143_((Property)TrackBlock.SHAPE)).getAxes().get(0)).m_82490_(distance);
        return Optional.of(((AccessorTrackTargetingBehavior)this.edgePoint).getTargetTrack().m_7637_(offset.f_82479_, offset.f_82480_, offset.f_82481_));
    }

    @Nullable
    private BlockState getSecondaryTrackState() {
        return this.getDesiredSecondaryEdgePos().map(pos -> this.edgePoint.getWorld().m_8055_(pos.m_121955_((Vec3i)this.m_58899_()))).orElse(null);
    }

    private void setError(Component component) {
        this.error = Components.empty().m_7220_(component);
    }

    private void clearErrors() {
        this.error = null;
    }

    public void lazyTick() {
        super.lazyTick();
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        BlockState trackState = this.edgePoint.getTrackBlockState();
        BlockState secondaryTrackState = this.getSecondaryTrackState();
        if (trackState != this.cachedTrackState || secondaryTrackState != this.cachedSecondaryTrackState || this.edgeSpacing != this.lastEdgeSpacing) {
            BlockPos newPos;
            this.invalidateRenderBoundingBox();
            this.cachedTrackState = trackState;
            this.cachedSecondaryTrackState = secondaryTrackState;
            this.lastEdgeSpacing = this.edgeSpacing;
            BlockPos blockPos = newPos = this.isOkExceptGraph() ? this.getDesiredSecondaryEdgePos().orElse(BlockPos.f_121853_) : BlockPos.f_121853_;
            if (!newPos.equals((Object)((AccessorTrackTargetingBehavior)this.secondEdgePoint).getTargetTrack())) {
                ((AccessorTrackTargetingBehavior)this.secondEdgePoint).setTargetTrack(newPos);
                ((AccessorTrackTargetingBehavior)this.secondEdgePoint).setEdgePoint(null);
                this.secondEdgePoint.createEdgePoint();
                if (this.isOkExceptGraph()) {
                    ((AccessorTrackTargetingBehavior)this.secondEdgePoint).setTargetDirection(((AccessorTrackTargetingBehavior)this.edgePoint).getTargetDirection().m_122541_());
                }
                this.sendData();
            }
        }
        this.updateOK();
        this.clientInfo = new ClientInfo(this);
        this.clearErrors();
        CRPackets.channel.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.m_58899_())), (Object)new TrackCouplerClientInfoPacket(this));
    }

    private boolean isOkExceptGraph() {
        return this.cachedTrackState.m_60734_() instanceof ITrackBlock && this.cachedSecondaryTrackState.m_60734_() instanceof ITrackBlock && this.cachedTrackState.m_61138_((Property)TrackBlock.SHAPE) && this.cachedSecondaryTrackState.m_61138_((Property)TrackBlock.SHAPE) && this.cachedTrackState.m_61143_((Property)TrackBlock.SHAPE) == this.cachedSecondaryTrackState.m_61143_((Property)TrackBlock.SHAPE);
    }

    protected void updateOK() {
        if (!this.isOkExceptGraph()) {
            this.edgePointsOk = false;
            return;
        }
        if (((AccessorTrackTargetingBehavior)this.secondEdgePoint).getTargetTrack().equals((Object)BlockPos.f_121853_) || ((AccessorTrackTargetingBehavior)this.edgePoint).getTargetTrack().equals((Object)BlockPos.f_121853_)) {
            this.edgePointsOk = false;
            return;
        }
        if (this.edgePoint.determineGraphLocation() == null || this.secondEdgePoint.determineGraphLocation() == null) {
            this.edgePointsOk = false;
            return;
        }
        if (this.edgePoint.determineGraphLocation().graph != this.secondEdgePoint.determineGraphLocation().graph) {
            this.edgePointsOk = false;
            return;
        }
        Couple edgePointLocations = this.edgePoint.determineGraphLocation().edge;
        Couple secondEdgePointLocations = this.secondEdgePoint.determineGraphLocation().edge;
        if (edgePointLocations == null || secondEdgePointLocations == null) {
            this.edgePointsOk = false;
            return;
        }
        this.edgePointsOk = ((TrackNodeLocation)edgePointLocations.getFirst()).equals(secondEdgePointLocations.getFirst()) || ((TrackNodeLocation)edgePointLocations.getFirst()).equals(secondEdgePointLocations.getSecond()) || ((TrackNodeLocation)edgePointLocations.getSecond()).equals(secondEdgePointLocations.getFirst()) || ((TrackNodeLocation)edgePointLocations.getSecond()).equals(secondEdgePointLocations.getSecond());
    }

    public boolean areEdgePointsOk() {
        return this.f_58857_ != null && this.f_58857_.f_46443_ && this.clientInfo != null ? this.clientInfo.edgePointsOk : this.edgePointsOk;
    }

    @Nullable
    public TrackCoupler getCoupler() {
        return (TrackCoupler)this.edgePoint.getEdgePoint();
    }

    @Nullable
    public TrackCoupler getSecondaryCoupler() {
        return (TrackCoupler)this.secondEdgePoint.getEdgePoint();
    }

    @Nullable
    protected Carriage getCarriageOnPoint(@NotNull Train train, @NotNull TrackCoupler coupler, @NotNull TrackTargetingBehaviour<TrackCoupler> edgePoint, boolean leading) {
        for (Carriage carriage : train.carriages) {
            if (!this.isCarriageWheelOnPoint(carriage, coupler, edgePoint, leading)) continue;
            return carriage;
        }
        return null;
    }

    protected boolean isCarriageWheelOnPoint(Carriage carriage, TrackCoupler coupler, TrackTargetingBehaviour<TrackCoupler> edgePoint, boolean leading) {
        IPotentiallyUpsideDownBogeyBlock pudb;
        TravellingPoint relevantPoint = leading ? carriage.leadingBogey().leading() : carriage.trailingBogey().trailing();
        TravellingPoint relevantPoint2 = leading ? carriage.leadingBogey().trailing() : carriage.trailingBogey().leading();
        CarriageBogey relevantBogey = leading ? carriage.leadingBogey() : carriage.trailingBogey();
        IBogeyBlock iBogeyBlock = ((AccessorCarriageBogey)relevantBogey).getType();
        boolean upsideDown = iBogeyBlock instanceof IPotentiallyUpsideDownBogeyBlock && (pudb = (IPotentiallyUpsideDownBogeyBlock)iBogeyBlock).isUpsideDown();
        double couplerPosition = coupler.getLocationOn(relevantPoint.edge);
        Vec3 wheelPosition = relevantPoint.getPosition().m_82549_(relevantPoint2.getPosition()).m_82490_(0.5).m_82520_(0.0, upsideDown ? 2.0 : 0.0, 0.0);
        Vec3 couplerSpatialPosition = Vec3.m_82539_((Vec3i)edgePoint.getGlobalPosition().m_7494_());
        return (coupler.isPrimary(relevantPoint.node1) || coupler.isPrimary(relevantPoint.node2) || coupler.isPrimary(relevantPoint2.node1) || coupler.isPrimary(relevantPoint2.node2)) && wheelPosition.m_82557_(couplerSpatialPosition) < 0.6400000000000001;
    }

    public AllowedOperationMode getAllowedOperationMode() {
        return (AllowedOperationMode)((Object)this.m_58900_().m_61143_(TrackCouplerBlock.MODE));
    }

    public OperationInfo getOperationInfo() {
        this.clearErrors();
        OperationInfo info = this.getOperationInfo(false);
        if (info.mode == OperationMode.NONE) {
            MutableComponent backupError = this.error;
            this.clearErrors();
            info = this.getOperationInfo(true);
            if (info.mode == OperationMode.NONE) {
                this.error = backupError;
            }
        }
        if (!info.mode.permitted(this.getAllowedOperationMode())) {
            this.clearErrors();
            this.setError((Component)Components.translatable((String)"railways.tooltip.coupler.error.mode_not_permitted"));
            return OperationInfo.NONE;
        }
        return info;
    }

    protected OperationInfo getOperationInfo(boolean reversed) {
        TrackTargetingBehaviour<TrackCoupler> edgePoint2;
        TrackCoupler coupler1 = reversed ? this.getSecondaryCoupler() : this.getCoupler();
        TrackCoupler coupler2 = reversed ? this.getCoupler() : this.getSecondaryCoupler();
        TrackTargetingBehaviour<TrackCoupler> edgePoint1 = reversed ? this.secondEdgePoint : this.edgePoint;
        TrackTargetingBehaviour<TrackCoupler> trackTargetingBehaviour = edgePoint2 = reversed ? this.edgePoint : this.secondEdgePoint;
        if (coupler1 != null && coupler2 != null && coupler1.isActivated() && coupler2.isActivated()) {
            Train primaryTrain = (Train)Create.RAILWAYS.trains.get(coupler1.getCurrentTrain());
            Train secondaryTrain = (Train)Create.RAILWAYS.trains.get(coupler2.getCurrentTrain());
            if (primaryTrain != null && primaryTrain == secondaryTrain) {
                Carriage frontCarriage = this.getCarriageOnPoint(primaryTrain, coupler2, edgePoint2, false);
                if (frontCarriage == null) {
                    this.setError((Component)Components.translatable((String)"railways.tooltip.coupler.error.carriage_alignment"));
                }
                if (frontCarriage != null && primaryTrain.carriages.indexOf(frontCarriage) < primaryTrain.carriages.size() - 1) {
                    Carriage backCarriage = (Carriage)primaryTrain.carriages.get(primaryTrain.carriages.indexOf(frontCarriage) + 1);
                    if (this.isCarriageWheelOnPoint(backCarriage, coupler1, edgePoint1, true)) {
                        return new OperationInfo(OperationMode.DECOUPLING, frontCarriage, backCarriage);
                    }
                    this.setError((Component)Components.translatable((String)"railways.tooltip.coupler.error.carriage_alignment"));
                } else {
                    this.setError((Component)Components.translatable((String)"railways.tooltip.coupler.error.carriage_alignment"));
                }
            } else if (primaryTrain != null && secondaryTrain != null) {
                Carriage primaryCarriage = this.getCarriageOnPoint(primaryTrain, coupler1, edgePoint1, true);
                Carriage secondaryCarriage = this.getCarriageOnPoint(secondaryTrain, coupler2, edgePoint2, false);
                if (primaryCarriage != null && secondaryCarriage != null && primaryTrain.carriages.indexOf(primaryCarriage) == 0 && secondaryTrain.carriages.indexOf(secondaryCarriage) == secondaryTrain.carriages.size() - 1) {
                    return new OperationInfo(OperationMode.COUPLING, secondaryCarriage, primaryCarriage);
                }
                this.setError((Component)Components.translatable((String)"railways.tooltip.coupler.error.carriage_alignment"));
            } else {
                this.setError((Component)Components.translatable((String)"railways.tooltip.coupler.error.missing_train"));
            }
        } else {
            this.setError((Component)Components.translatable((String)"railways.tooltip.coupler.error.missing_train"));
        }
        return OperationInfo.NONE;
    }

    public OperationMode getOperationMode() {
        return this.getOperationInfo().mode;
    }

    public ClientInfo getClientInfo() {
        return this.clientInfo;
    }

    public void setClientInfo(ClientInfo info) {
        this.clientInfo = info;
    }

    public int getTargetAnalogOutput() {
        OperationMode mode;
        int out = 0;
        if (this.getCoupler() != null && this.getCoupler().isActivated()) {
            ++out;
        }
        if (this.getSecondaryCoupler() != null && this.getSecondaryCoupler().isActivated()) {
            out += 2;
        }
        if ((mode = this.getOperationMode()) == OperationMode.DECOUPLING) {
            out += 4;
        } else if (mode == OperationMode.COUPLING) {
            out += 8;
        }
        return out;
    }

    protected AABB createRenderBoundingBox() {
        return new AABB(this.f_58858_, this.edgePoint.getGlobalPosition()).m_82367_(new AABB(this.f_58858_, this.secondEdgePoint.getGlobalPosition())).m_82400_(2.0);
    }

    public void transform(StructureTransform transform) {
        this.edgePoint.transform(transform);
        this.secondEdgePoint.transform(transform);
    }

    private static LangBuilder b() {
        return Lang.builder((String)"railways");
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        TrackCouplerTileEntity.b().translate("tooltip.coupler.header", new Object[0]).forGoggles(tooltip);
        TrackCouplerTileEntity.b().translate("tooltip.coupler.mode", new Object[0]).style(ChatFormatting.YELLOW).forGoggles(tooltip);
        TrackCouplerTileEntity.b().translate("coupler.mode." + this.getAllowedOperationMode().m_7912_(), new Object[0]).style(ChatFormatting.YELLOW).forGoggles(tooltip);
        String train1 = this.clientInfo == null ? "None" : this.clientInfo.trainName1;
        String train2 = this.clientInfo == null ? "None" : this.clientInfo.trainName2;
        OperationMode operationMode = this.clientInfo == null ? OperationMode.NONE : this.clientInfo.mode;
        TrackCouplerTileEntity.b().translate("tooltip.coupler.train1", new Object[]{train1}).style(ChatFormatting.GOLD).forGoggles(tooltip);
        TrackCouplerTileEntity.b().translate("tooltip.coupler.train2", new Object[]{train2}).style(ChatFormatting.GOLD).forGoggles(tooltip);
        TrackCouplerTileEntity.b().translate("tooltip.coupler.action." + operationMode.name().toLowerCase(Locale.ROOT), new Object[0]).style(ChatFormatting.GREEN).forGoggles(tooltip);
        if (this.clientInfo.error != null) {
            TrackCouplerTileEntity.b().add(this.clientInfo.error).style(ChatFormatting.DARK_RED).forGoggles(tooltip);
        }
        return true;
    }

    private static class TrackCouplerValueBoxTransform
    extends CenteredSideValueBoxTransform {
        public TrackCouplerValueBoxTransform(boolean vertical) {
            super((state, d) -> d.m_122434_().m_122478_() == vertical);
        }

        protected Vec3 getSouthLocation() {
            return VecHelper.voxelSpace((double)8.0, (double)8.0, (double)16.0);
        }
    }

    public record OperationInfo(OperationMode mode, Carriage frontCarriage, Carriage backCarriage) {
        public static final OperationInfo NONE = new OperationInfo(OperationMode.NONE, null, null);
    }

    public static enum OperationMode {
        NONE,
        COUPLING,
        DECOUPLING;


        public boolean permitted(AllowedOperationMode allowedMode) {
            return this == NONE || allowedMode == AllowedOperationMode.BOTH || allowedMode == AllowedOperationMode.COUPLING && this == COUPLING || allowedMode == AllowedOperationMode.DECOUPLING && this == DECOUPLING;
        }
    }

    public static class ClientInfo {
        public OperationMode mode;
        public String trainName1;
        public String trainName2;
        public boolean edgePointsOk;
        public MutableComponent error;

        protected ClientInfo(TrackCouplerTileEntity te) {
            UUID trainId;
            Train train;
            this.mode = te.getOperationMode();
            this.trainName1 = "None";
            this.trainName2 = "None";
            if (te.getCoupler() != null && te.getCoupler().isActivated() && (train = (Train)Create.RAILWAYS.trains.get(trainId = te.getCoupler().getCurrentTrain())) != null) {
                this.trainName1 = train.name.getString();
            }
            if (te.getSecondaryCoupler() != null && te.getSecondaryCoupler().isActivated() && (train = (Train)Create.RAILWAYS.trains.get(trainId = te.getSecondaryCoupler().getCurrentTrain())) != null) {
                this.trainName2 = train.name.getString();
            }
            this.edgePointsOk = te.edgePointsOk;
            this.error = te.error;
        }

        public ClientInfo(CompoundTag tag) {
            this.mode = (OperationMode)NBTHelper.readEnum((CompoundTag)tag, (String)"mode", OperationMode.class);
            this.trainName1 = tag.m_128461_("trainName1");
            this.trainName2 = tag.m_128461_("trainName2");
            this.edgePointsOk = tag.m_128471_("edgePointsOk");
            this.error = tag.m_128441_("error") ? Component.Serializer.m_130701_((String)tag.m_128461_("error")) : null;
        }

        public CompoundTag write() {
            CompoundTag tag = new CompoundTag();
            NBTHelper.writeEnum((CompoundTag)tag, (String)"mode", (Enum)this.mode);
            tag.m_128359_("trainName1", this.trainName1);
            tag.m_128359_("trainName2", this.trainName2);
            tag.m_128379_("edgePointsOk", this.edgePointsOk);
            if (this.error != null) {
                tag.m_128359_("error", Component.Serializer.m_130703_((Component)this.error));
            }
            return tag;
        }
    }

    public static enum AllowedOperationMode implements StringRepresentable
    {
        BOTH(true, true),
        COUPLING(true, false),
        DECOUPLING(false, true);

        public final boolean canCouple;
        public final boolean canDecouple;

        private AllowedOperationMode(boolean canCouple, boolean canDecouple) {
            this.canCouple = canCouple;
            this.canDecouple = canDecouple;
        }

        @NotNull
        public String m_7912_() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public Component getTranslatedName() {
            return Components.translatable((String)("railways.coupler.mode." + this.m_7912_()));
        }
    }
}

