/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.custom_bogeys.monobogey;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.core.PartialModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import com.railwayteam.railways.content.custom_bogeys.monobogey.IPotentiallyUpsideDownBogeyBlock;
import com.railwayteam.railways.content.custom_bogeys.monobogey.MonoBogeyTileEntity;
import com.railwayteam.railways.mixin.AccessorCarriageBogey;
import com.railwayteam.railways.mixin_interfaces.IBogeyFrameCanBeMonorail;
import com.railwayteam.railways.registry.CRBlockEntities;
import com.railwayteam.railways.registry.CRBlockPartials;
import com.railwayteam.railways.registry.CRBlocks;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.logistics.trains.entity.BogeyInstance;
import com.simibubi.create.content.logistics.trains.entity.CarriageBogey;
import com.simibubi.create.content.schematics.ISpecialBlockItemRequirement;
import com.simibubi.create.content.schematics.ItemRequirement;
import com.simibubi.create.foundation.block.ITE;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.EnumSet;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class MonoBogeyBlock
extends Block
implements IPotentiallyUpsideDownBogeyBlock,
ITE<MonoBogeyTileEntity>,
ProperWaterloggedBlock,
ISpecialBlockItemRequirement {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61364_;
    protected final boolean upsideDown;
    static final EnumSet<Direction> STICKY_X = EnumSet.of(Direction.EAST, Direction.WEST);
    static final EnumSet<Direction> STICKY_Z = EnumSet.of(Direction.SOUTH, Direction.NORTH);

    public MonoBogeyBlock(BlockBehaviour.Properties pProperties, boolean upsideDown) {
        super(pProperties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.upsideDown = upsideDown;
    }

    @Override
    public boolean isUpsideDown() {
        return this.upsideDown;
    }

    @Override
    public BlockState getVersion(BlockState base, boolean upsideDown) {
        if (!base.m_61138_(AXIS)) {
            return base;
        }
        if (upsideDown) {
            return (BlockState)((BlockState)CRBlocks.MONO_BOGEY_UPSIDE_DOWN.getDefaultState().m_61124_(AXIS, (Comparable)((Direction.Axis)base.m_61143_(AXIS)))).m_61124_((Property)WATERLOGGED, (Comparable)base.m_61145_((Property)WATERLOGGED).orElse(false));
        }
        return (BlockState)((BlockState)CRBlocks.MONO_BOGEY.getDefaultState().m_61124_(AXIS, (Comparable)((Direction.Axis)base.m_61143_(AXIS)))).m_61124_((Property)WATERLOGGED, (Comparable)base.m_61145_((Property)WATERLOGGED).orElse(false));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AXIS, WATERLOGGED});
        super.m_7926_(builder);
    }

    public EnumSet<Direction> getStickySurfaces(BlockGetter world, BlockPos pos, BlockState state) {
        return state.m_61143_((Property)BlockStateProperties.f_61364_) == Direction.Axis.X ? STICKY_X : STICKY_Z;
    }

    public BlockState m_7417_(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        this.updateWater(pLevel, pState, pCurrentPos);
        return pState;
    }

    public FluidState m_5888_(BlockState pState) {
        return this.fluidState(pState);
    }

    public double getWheelPointSpacing() {
        return 2.0;
    }

    public double getWheelRadius() {
        return 0.375;
    }

    public Vec3 getConnectorAnchorOffset() {
        return new Vec3(0.0, this.upsideDown ? 0.8125 : 0.15625, 0.78125);
    }

    public boolean allowsSingleBogeyCarriage() {
        return true;
    }

    public BlockState getMatchingBogey(Direction upDirection, boolean axisAlongFirst) {
        if (upDirection != Direction.UP) {
            return null;
        }
        return (BlockState)this.m_49966_().m_61124_(AXIS, (Comparable)(axisAlongFirst ? Direction.Axis.X : Direction.Axis.Z));
    }

    public boolean isTrackAxisAlongFirstCoordinate(BlockState state) {
        return state.m_61143_(AXIS) == Direction.Axis.X;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(@Nullable BlockState state, float wheelAngle, PoseStack ms, float partialTicks, MultiBufferSource buffers, int light, int overlay) {
        if (state != null) {
            ms.m_85837_(0.5, 0.5, 0.5);
            if (state.m_61143_(AXIS) == Direction.Axis.X) {
                ms.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
            }
        }
        ms.m_85837_(0.0, -1.5078125 * (double)(this.upsideDown ? (state == null ? 1 : -1) : 1), 0.0);
        VertexConsumer vb = buffers.m_6299_(RenderType.m_110457_());
        BlockState air = Blocks.f_50016_.m_49966_();
        this.renderBogey(wheelAngle, ms, light, vb, air, state != null && this.upsideDown);
    }

    private void renderBogey(float wheelAngle, PoseStack ms, int light, VertexConsumer vb, BlockState air, boolean renderUpsideDown) {
        ((SuperByteBuffer)((SuperByteBuffer)CachedBufferer.partial((PartialModel)CRBlockPartials.MONOBOGEY_FRAME, (BlockState)air).rotateZ(renderUpsideDown ? 180.0 : 0.0)).scale(0.9980469f)).light(light).renderInto(ms, vb);
        for (boolean left : Iterate.trueAndFalse) {
            for (int front : Iterate.positiveAndNegative) {
                ms.m_85836_();
                ((SuperByteBuffer)CachedBufferer.partial((PartialModel)CRBlockPartials.MONOBOGEY_WHEEL, (BlockState)air).translate(left ? -0.75 : 0.75, renderUpsideDown ? -0.8125 : 0.1875, (double)((float)(front * 15) / 16.0f)).rotateY(left ? (double)wheelAngle : (double)(-wheelAngle))).translate(0.9375, 0.0, 0.0).light(light).renderInto(ms, vb);
                ms.m_85849_();
            }
        }
    }

    public BogeyInstance createInstance(MaterialManager materialManager, CarriageBogey bogey) {
        return ((IBogeyFrameCanBeMonorail)new BogeyInstance.Frame(bogey, materialManager)).setMonorail(this.upsideDown, IPotentiallyUpsideDownBogeyBlock.isUpsideDown(((AccessorCarriageBogey)bogey.carriage.leadingBogey()).getType()));
    }

    public BlockState m_6843_(BlockState pState, Rotation pRotation) {
        return switch (pRotation) {
            case Rotation.COUNTERCLOCKWISE_90, Rotation.CLOCKWISE_90 -> (BlockState)pState.m_61122_(AXIS);
            default -> pState;
        };
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return AllBlocks.RAILWAY_CASING.asStack();
    }

    public Class<MonoBogeyTileEntity> getTileEntityClass() {
        return MonoBogeyTileEntity.class;
    }

    public BlockEntityType<? extends MonoBogeyTileEntity> getTileEntityType() {
        return (BlockEntityType)CRBlockEntities.MONO_BOGEY.get();
    }

    public ItemRequirement getRequiredItems(BlockState state, BlockEntity te) {
        return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, AllBlocks.RAILWAY_CASING.asStack());
    }

    public BlockState getRotatedBlockState(BlockState state, Direction targetedFace) {
        return state;
    }
}

