/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.custom_tracks;

import com.railwayteam.railways.Railways;
import com.railwayteam.railways.base.data.recipe.RailwaysRecipeProvider;
import com.railwayteam.railways.content.custom_tracks.CustomTrackBlock;
import com.railwayteam.railways.content.custom_tracks.monorail.MonorailTrackBlock;
import com.railwayteam.railways.registry.CRBlocks;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.Create;
import com.simibubi.create.content.logistics.trains.track.TrackBlock;
import com.tterrag.registrate.util.entry.BlockEntry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.common.util.Lazy;

public enum TrackMaterial {
    ANDESITE("Andesite", (Supplier<BlockEntry<? extends TrackBlock>>)Lazy.of(() -> AllBlocks.TRACK), Create.asResource((String)"block/palettes/stone_types/polished/andesite_cut_polished"), Ingredient.f_43901_, Ingredient.f_43901_, true),
    ACACIA("Acacia", (Supplier<BlockEntry<? extends TrackBlock>>)Lazy.of(() -> CRBlocks.ACACIA_TRACK), new ResourceLocation("block/acacia_planks"), new ItemLike[]{Blocks.f_50402_}),
    BIRCH("Birch", (Supplier<BlockEntry<? extends TrackBlock>>)Lazy.of(() -> CRBlocks.BIRCH_TRACK), new ResourceLocation("block/birch_planks"), new ItemLike[]{Blocks.f_50400_}),
    CRIMSON("Crimson", (Supplier<BlockEntry<? extends TrackBlock>>)Lazy.of(() -> CRBlocks.CRIMSON_TRACK), new ResourceLocation("block/crimson_planks"), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50657_}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42587_})),
    DARK_OAK("Dark Oak", (Supplier<BlockEntry<? extends TrackBlock>>)Lazy.of(() -> CRBlocks.DARK_OAK_TRACK), new ResourceLocation("block/dark_oak_planks"), new ItemLike[]{Blocks.f_50403_}),
    JUNGLE("Jungle", (Supplier<BlockEntry<? extends TrackBlock>>)Lazy.of(() -> CRBlocks.JUNGLE_TRACK), new ResourceLocation("block/jungle_planks"), new ItemLike[]{Blocks.f_50401_}),
    OAK("Oak", (Supplier<BlockEntry<? extends TrackBlock>>)Lazy.of(() -> CRBlocks.OAK_TRACK), new ResourceLocation("block/oak_planks"), new ItemLike[]{Blocks.f_50398_}),
    SPRUCE("Spruce", (Supplier<BlockEntry<? extends TrackBlock>>)Lazy.of(() -> CRBlocks.SPRUCE_TRACK), new ResourceLocation("block/spruce_planks"), new ItemLike[]{Blocks.f_50399_}),
    WARPED("Warped", (Supplier<BlockEntry<? extends TrackBlock>>)Lazy.of(() -> CRBlocks.WARPED_TRACK), new ResourceLocation("block/warped_planks"), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50658_}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42587_})),
    BLACKSTONE("Blackstone", (Supplier<BlockEntry<? extends TrackBlock>>)Lazy.of(() -> CRBlocks.BLACKSTONE_TRACK), new ResourceLocation("block/blackstone"), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50733_}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42587_})),
    MANGROVE("Mangrove", (Supplier<BlockEntry<? extends TrackBlock>>)Lazy.of(() -> CRBlocks.MANGROVE_TRACK), new ResourceLocation("block/mangrove_planks"), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_220851_})),
    MONORAIL("Monorail", (Supplier<BlockEntry<? extends TrackBlock>>)Lazy.of(() -> CRBlocks.MONORAIL_TRACK), Railways.asResource("block/monorail/monorail"), Ingredient.f_43901_, Ingredient.f_43901_, false, TrackType.MONORAIL);

    public final String langName;
    public final Supplier<BlockEntry<? extends TrackBlock>> trackBlock;
    public final boolean createBuiltin;
    public final Ingredient sleeperIngredient;
    public final Ingredient railsIngredient;
    public final ResourceLocation particle;
    public final TrackType trackType;

    private TrackMaterial(String langName, Supplier<BlockEntry<? extends TrackBlock>> trackBlock, ResourceLocation particle, ItemLike ... items) {
        this(langName, trackBlock, particle, Ingredient.m_43929_((ItemLike[])items));
    }

    private TrackMaterial(String langName, Supplier<BlockEntry<? extends TrackBlock>> trackBlock, ResourceLocation particle, Ingredient sleeperIngredient) {
        this(langName, trackBlock, particle, sleeperIngredient, Ingredient.m_43938_(Stream.of(new Ingredient.TagValue(RailwaysRecipeProvider.Ingredients.ironNugget()), new Ingredient.TagValue(RailwaysRecipeProvider.Ingredients.zincNugget()))), false);
    }

    private TrackMaterial(String langName, Supplier<BlockEntry<? extends TrackBlock>> trackBlock, ResourceLocation particle, Ingredient sleeperIngredient, Ingredient railsIngredient) {
        this(langName, trackBlock, particle, sleeperIngredient, railsIngredient, false);
    }

    private TrackMaterial(String langName, Supplier<BlockEntry<? extends TrackBlock>> trackBlock, ResourceLocation particle, Ingredient sleeperIngredient, Ingredient railsIngredient, boolean createBuiltin) {
        this(langName, trackBlock, particle, sleeperIngredient, railsIngredient, createBuiltin, TrackType.STANDARD);
    }

    private TrackMaterial(String langName, Supplier<BlockEntry<? extends TrackBlock>> trackBlock, ResourceLocation particle, Ingredient sleeperIngredient, Ingredient railsIngredient, boolean createBuiltin, TrackType trackType) {
        this.langName = langName;
        this.trackBlock = trackBlock;
        this.createBuiltin = createBuiltin;
        this.sleeperIngredient = sleeperIngredient;
        this.railsIngredient = railsIngredient;
        this.particle = particle;
        this.trackType = trackType;
    }

    public BlockEntry<? extends TrackBlock> getTrackBlock() {
        return this.trackBlock.get();
    }

    public CustomTrackBlock create(BlockBehaviour.Properties properties) {
        return switch (this.trackType) {
            default -> throw new IncompatibleClassChangeError();
            case TrackType.MONORAIL -> new MonorailTrackBlock(properties, this);
            case TrackType.STANDARD -> new CustomTrackBlock(properties, this);
        };
    }

    public boolean isCustom() {
        return !this.createBuiltin;
    }

    public static TrackMaterial[] allCustom() {
        return (TrackMaterial[])Arrays.stream(TrackMaterial.values()).filter(TrackMaterial::isCustom).toArray(TrackMaterial[]::new);
    }

    public static List<BlockEntry<?>> allCustomBlocks() {
        ArrayList list = new ArrayList();
        for (TrackMaterial material : TrackMaterial.allCustom()) {
            list.add(material.getTrackBlock());
        }
        return list;
    }

    public static List<BlockEntry<?>> allBlocks() {
        ArrayList list = new ArrayList();
        for (TrackMaterial material : TrackMaterial.values()) {
            list.add(material.getTrackBlock());
        }
        return list;
    }

    public String resName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public static TrackMaterial deserialize(String serializedName) {
        return TrackMaterial.valueOf(serializedName.toUpperCase());
    }

    public static enum TrackType {
        STANDARD,
        MONORAIL;

    }
}

