/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.minecarts;

import com.mojang.math.Vector3d;
import com.railwayteam.railways.content.minecarts.MinecartBlock;
import com.railwayteam.railways.registry.CRItems;
import com.railwayteam.railways.util.packet.PacketSender;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.JukeboxBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class MinecartJukebox
extends MinecartBlock {
    private static final int COOLDOWN = 100;
    private int cooldownCount = 0;
    private ItemStack disc = ItemStack.f_41583_;
    @OnlyIn(value=Dist.CLIENT)
    private JukeboxCartSoundInstance sound;

    public MinecartJukebox(EntityType<?> type, Level level) {
        super(type, level, Blocks.f_50131_);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.cooldownCount > 0) {
            --this.cooldownCount;
        }
    }

    public void m_6025_(int x, int y, int z, boolean active) {
        if (!this.f_19853_.f_46443_ && this.cooldownCount <= 0) {
            this.cooldownCount = 100;
            PacketSender.updateJukeboxClientside(this, this.disc);
        }
    }

    public ItemStack m_142340_() {
        return CRItems.ITEM_JUKEBOXCART.asStack();
    }

    @Override
    protected Item m_213728_() {
        return (Item)CRItems.ITEM_JUKEBOXCART.get();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public InteractionResult m_6096_(@NotNull Player player, @NotNull InteractionHand hand) {
        InteractionResult ret = super.m_6096_(player, hand);
        if (ret.m_19077_()) {
            return ret;
        }
        if (this.f_19853_.f_46443_) return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        if (this.disc.m_41619_()) {
            ItemStack handStack = player.m_21120_(hand);
            if (!(handStack.m_41720_() instanceof RecordItem)) return InteractionResult.PASS;
            this.__insertRecord(handStack);
            if (!player.m_7500_()) {
                player.m_21008_(hand, ItemStack.f_41583_);
            }
            player.m_36220_(Stats.f_12965_);
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        } else {
            this.__ejectRecord();
        }
        return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
    }

    public void insertRecord(ItemStack record) {
        this.__insertRecord(record);
        if (this.f_19853_.f_46443_) {
            if (!this.disc.m_41619_()) {
                if (this.sound == null || this.sound.m_7801_()) {
                    this.startPlaying();
                } else {
                    this.sound.requestStop();
                }
            } else if (this.sound != null) {
                this.sound.requestStop();
            }
        }
    }

    private void __insertRecord(ItemStack record) {
        this.disc = record.m_41777_();
        this.content = (BlockState)this.content.m_61124_((Property)JukeboxBlock.f_54254_, (Comparable)Boolean.valueOf(!this.disc.m_41619_()));
        if (!this.f_19853_.f_46443_) {
            PacketSender.updateJukeboxClientside(this, this.disc);
        }
    }

    private void __ejectRecord() {
        if (this.f_19853_.f_46443_) {
            return;
        }
        Vector3d pos = new Vector3d(this.m_20182_().f_82479_ + 0.5, this.m_20182_().f_82480_ + 1.0, this.m_20182_().f_82481_ + 0.5);
        ItemEntity out = new ItemEntity(this.f_19853_, pos.f_86214_, pos.f_86215_, pos.f_86216_, this.disc);
        out.m_32060_();
        this.f_19853_.m_7967_((Entity)out);
        this.__insertRecord(ItemStack.f_41583_);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void startPlaying() {
        if (!this.disc.m_41619_()) {
            this.sound = new JukeboxCartSoundInstance(((RecordItem)this.disc.m_41720_()).m_43051_());
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)this.sound);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class JukeboxCartSoundInstance
    extends AbstractTickableSoundInstance {
        public JukeboxCartSoundInstance(SoundEvent event) {
            super(event, SoundSource.RECORDS, SoundInstance.m_235150_());
        }

        public void m_7788_() {
            if (MinecartJukebox.this.m_213877_()) {
                this.requestStop();
            }
            this.f_119575_ = MinecartJukebox.this.m_20183_().m_123341_();
            this.f_119576_ = MinecartJukebox.this.m_20183_().m_123342_();
            this.f_119577_ = MinecartJukebox.this.m_20183_().m_123343_();
        }

        public void requestStop() {
            this.m_119609_();
        }
    }
}

