/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.semaphore;

import com.railwayteam.railways.Config;
import com.railwayteam.railways.content.semaphore.SemaphoreBlockEntity;
import com.railwayteam.railways.registry.CRBlockEntities;
import com.railwayteam.railways.registry.CRBlocks;
import com.railwayteam.railways.registry.CRShapes;
import com.railwayteam.railways.registry.CRTags;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.wrench.IWrenchable;
import com.simibubi.create.foundation.block.ITE;
import com.simibubi.create.foundation.utility.placement.IPlacementHelper;
import com.simibubi.create.foundation.utility.placement.PlacementHelpers;
import com.simibubi.create.foundation.utility.placement.PlacementOffset;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SemaphoreBlock
extends HorizontalDirectionalBlock
implements ITE<SemaphoreBlockEntity>,
IWrenchable {
    public static final int placementHelperId = PlacementHelpers.register((IPlacementHelper)new PlacementHelper());
    public static final int girderPlacementHelperId = PlacementHelpers.register((IPlacementHelper)new GirderPlacementHelper());
    public static final BooleanProperty FLIPPED = BooleanProperty.m_61465_((String)"flipped");
    public static final BooleanProperty FULL = BooleanProperty.m_61465_((String)"full");
    public static final BooleanProperty UPSIDE_DOWN = BooleanProperty.m_61465_((String)"upside_down");

    public SemaphoreBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FLIPPED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FULL, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UPSIDE_DOWN, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder.m_61104_(new Property[]{f_54117_}).m_61104_(new Property[]{FLIPPED}).m_61104_(new Property[]{FULL}).m_61104_(new Property[]{UPSIDE_DOWN}));
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        ItemStack heldItem = player.m_21120_(hand);
        ItemStack itemInHand = player.m_21120_(hand);
        IPlacementHelper helper = PlacementHelpers.get((int)girderPlacementHelperId);
        if (helper.matchesItem(itemInHand)) {
            return helper.getOffset(player, world, state, pos, ray).placeInWorld(world, (BlockItem)itemInHand.m_41720_(), player, hand, ray);
        }
        return InteractionResult.PASS;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = super.m_5573_(context);
        if (state == null) {
            return null;
        }
        Direction facing = context.m_8125_().m_122424_();
        Vec3 look = context.m_43723_().m_20154_();
        Vec3 cross = look.m_82537_(new Vec3(facing.m_122432_()));
        boolean flipped = cross.f_82480_ < 0.0;
        boolean upside_down = context.m_43719_() == Direction.DOWN && (Boolean)Config.SIMPLIFIED_SEMAPHORE_PLACEMENT.get() == false;
        return (BlockState)((BlockState)((BlockState)state.m_61124_((Property)f_54117_, (Comparable)facing)).m_61124_((Property)FLIPPED, (Comparable)Boolean.valueOf(flipped))).m_61124_((Property)UPSIDE_DOWN, (Comparable)Boolean.valueOf(upside_down));
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        BlockState rotated;
        Level world = context.m_43725_();
        boolean upsideDownChanged = false;
        if (context.m_43719_().m_122434_() != Direction.Axis.Y) {
            if (context.m_43719_() == state.m_61143_((Property)f_54117_)) {
                rotated = (BlockState)state.m_61122_((Property)FLIPPED);
            } else if (context.m_43719_() == ((Direction)state.m_61143_((Property)f_54117_)).m_122424_() && !((Boolean)Config.SIMPLIFIED_SEMAPHORE_PLACEMENT.get()).booleanValue()) {
                rotated = (BlockState)state.m_61122_((Property)UPSIDE_DOWN);
                upsideDownChanged = true;
            } else {
                rotated = (BlockState)state.m_61124_((Property)f_54117_, (Comparable)context.m_43719_());
            }
        } else {
            rotated = this.getRotatedBlockState(state, context.m_43719_());
        }
        if (!rotated.m_60710_((LevelReader)world, context.m_8083_())) {
            return InteractionResult.PASS;
        }
        KineticTileEntity.switchToBlockState((Level)world, (BlockPos)context.m_8083_(), (BlockState)this.updateAfterWrenched(rotated, context));
        BlockEntity te = context.m_43725_().m_7702_(context.m_8083_());
        if (upsideDownChanged) {
            BlockState rotatedState;
            BlockState blockState;
            int i;
            BlockPos currentPos = context.m_8083_().m_7495_();
            for (i = 0; i < 16; ++i) {
                blockState = world.m_8055_(currentPos);
                if (CRBlocks.SEMAPHORE.is((Object)blockState.m_60734_())) {
                    rotatedState = (BlockState)blockState.m_61124_((Property)UPSIDE_DOWN, (Comparable)((Boolean)rotated.m_61143_((Property)UPSIDE_DOWN)));
                    KineticTileEntity.switchToBlockState((Level)world, (BlockPos)currentPos, (BlockState)Block.m_49931_((BlockState)rotatedState, (LevelAccessor)world, (BlockPos)currentPos));
                } else if (!CRTags.AllBlockTags.SEMAPHORE_POLES.matches(blockState)) break;
                currentPos = currentPos.m_7495_();
            }
            currentPos = context.m_8083_().m_7494_();
            for (i = 0; i < 16; ++i) {
                blockState = world.m_8055_(currentPos);
                if (CRBlocks.SEMAPHORE.is((Object)blockState.m_60734_())) {
                    rotatedState = (BlockState)blockState.m_61124_((Property)UPSIDE_DOWN, (Comparable)((Boolean)rotated.m_61143_((Property)UPSIDE_DOWN)));
                    KineticTileEntity.switchToBlockState((Level)world, (BlockPos)currentPos, (BlockState)Block.m_49931_((BlockState)rotatedState, (LevelAccessor)world, (BlockPos)currentPos));
                } else if (!CRTags.AllBlockTags.SEMAPHORE_POLES.matches(blockState)) break;
                currentPos = currentPos.m_7494_();
            }
        }
        if (world.m_8055_(context.m_8083_()) != state) {
            this.playRotateSound(world, context.m_8083_());
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        BlockState rotatedState;
        BlockState blockState;
        int i;
        super.m_6807_(state, world, pos, oldState, isMoving);
        BlockPos currentPos = pos.m_7495_();
        for (i = 0; i < 16; ++i) {
            blockState = world.m_8055_(currentPos);
            if (CRBlocks.SEMAPHORE.is((Object)blockState.m_60734_())) {
                rotatedState = (BlockState)blockState.m_61124_((Property)UPSIDE_DOWN, (Comparable)((Boolean)state.m_61143_((Property)UPSIDE_DOWN)));
                KineticTileEntity.switchToBlockState((Level)world, (BlockPos)currentPos, (BlockState)Block.m_49931_((BlockState)rotatedState, (LevelAccessor)world, (BlockPos)currentPos));
            } else if (!CRTags.AllBlockTags.SEMAPHORE_POLES.matches(blockState)) break;
            currentPos = currentPos.m_7495_();
        }
        currentPos = pos.m_7494_();
        for (i = 0; i < 16; ++i) {
            blockState = world.m_8055_(currentPos);
            if (CRBlocks.SEMAPHORE.is((Object)blockState.m_60734_())) {
                rotatedState = (BlockState)blockState.m_61124_((Property)UPSIDE_DOWN, (Comparable)((Boolean)state.m_61143_((Property)UPSIDE_DOWN)));
                KineticTileEntity.switchToBlockState((Level)world, (BlockPos)currentPos, (BlockState)Block.m_49931_((BlockState)rotatedState, (LevelAccessor)world, (BlockPos)currentPos));
            } else if (!CRTags.AllBlockTags.SEMAPHORE_POLES.matches(blockState)) break;
            currentPos = currentPos.m_7494_();
        }
    }

    public Class<SemaphoreBlockEntity> getTileEntityClass() {
        return SemaphoreBlockEntity.class;
    }

    public BlockEntityType<? extends SemaphoreBlockEntity> getTileEntityType() {
        return (BlockEntityType)CRBlockEntities.SEMAPHORE.get();
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return CRShapes.SEMAPHORE.get((Direction)pState.m_61143_((Property)f_54117_));
    }

    public static class PlacementHelper
    implements IPlacementHelper {
        public Predicate<ItemStack> getItemPredicate() {
            return arg_0 -> CRBlocks.SEMAPHORE.isIn(arg_0);
        }

        public Predicate<BlockState> getStatePredicate() {
            return state -> CRBlocks.SEMAPHORE.is((Object)state.m_60734_()) || CRTags.AllBlockTags.SEMAPHORE_POLES.matches((BlockState)state);
        }

        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            Direction offsetDirection = ray.m_82450_().m_82546_((Vec3)Vec3.m_82512_((Vec3i)pos)).f_82480_ < 0.0 ? Direction.DOWN : Direction.UP;
            BlockPos newPos = pos.m_121945_(offsetDirection);
            BlockState newState = world.m_8055_(newPos);
            if (!newState.m_60767_().m_76336_()) {
                newPos = pos.m_121945_(offsetDirection.m_122424_());
                newState = world.m_8055_(newPos);
            }
            if (newState.m_60767_().m_76336_()) {
                Direction facing = ray.m_82434_();
                if (facing.m_122434_() == Direction.Axis.Y) {
                    return PlacementOffset.fail();
                }
                Vec3 look = player.m_20154_();
                Vec3 cross = look.m_82537_(new Vec3(facing.m_122432_()));
                boolean flipped = cross.f_82480_ < 0.0;
                boolean upsideDown = offsetDirection == Direction.DOWN && (Boolean)Config.SIMPLIFIED_SEMAPHORE_PLACEMENT.get() == false;
                return PlacementOffset.success((Vec3i)newPos, x -> (BlockState)((BlockState)((BlockState)x.m_61124_((Property)FLIPPED, (Comparable)Boolean.valueOf(flipped))).m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)facing)).m_61124_((Property)UPSIDE_DOWN, (Comparable)Boolean.valueOf(upsideDown)));
            }
            return PlacementOffset.fail();
        }

        public void displayGhost(PlacementOffset offset) {
            if (!offset.hasGhostState()) {
                return;
            }
            CreateClient.GHOST_BLOCKS.showGhostState((Object)this, (BlockState)offset.getTransform().apply((BlockState)offset.getGhostState().m_61124_((Property)FULL, (Comparable)Boolean.valueOf(true)))).at(offset.getBlockPos()).breathingAlpha();
        }
    }

    public static class GirderPlacementHelper
    implements IPlacementHelper {
        public Predicate<ItemStack> getItemPredicate() {
            return CRTags.AllBlockTags.SEMAPHORE_POLES::matches;
        }

        public Predicate<BlockState> getStatePredicate() {
            return state -> CRBlocks.SEMAPHORE.is((Object)state.m_60734_());
        }

        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            Direction offsetDirection = ray.m_82450_().m_82546_((Vec3)Vec3.m_82512_((Vec3i)pos)).f_82480_ < 0.0 ? Direction.DOWN : Direction.UP;
            BlockPos newPos = pos.m_121945_(offsetDirection);
            BlockState newState = world.m_8055_(newPos);
            if (!newState.m_60767_().m_76336_()) {
                newPos = pos.m_121945_(offsetDirection.m_122424_());
                newState = world.m_8055_(newPos);
            }
            if (newState.m_60767_().m_76336_()) {
                Direction facing = ray.m_82434_();
                if (facing.m_122434_() == Direction.Axis.Y) {
                    return PlacementOffset.fail();
                }
                return PlacementOffset.success((Vec3i)newPos);
            }
            return PlacementOffset.fail();
        }
    }
}

