/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.smokestack;

import com.railwayteam.railways.content.smokestack.ISpeedNotifiable;
import com.railwayteam.railways.content.smokestack.SmokeStackBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementBehaviour;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.properties.Property;

public class SmokeStackMovementBehaviour
implements MovementBehaviour {
    private final boolean renderAsNormalTileEntity;
    private final Map<Integer, LerpedFloat> chanceChasers = new HashMap<Integer, LerpedFloat>();
    private final Map<Integer, LerpedFloat> speedMultiplierChasers = new HashMap<Integer, LerpedFloat>();

    public SmokeStackMovementBehaviour() {
        this(false);
    }

    public SmokeStackMovementBehaviour(boolean renderAsNormalTileEntity) {
        this.renderAsNormalTileEntity = renderAsNormalTileEntity;
    }

    public boolean renderAsNormalTileEntity() {
        return this.renderAsNormalTileEntity;
    }

    public void tick(MovementContext context) {
        if (context.world == null || !context.world.f_46443_ || context.position == null || !((Boolean)context.state.m_61143_((Property)SmokeStackBlock.ENABLED)).booleanValue()) {
            return;
        }
        int key = context.hashCode();
        LerpedFloat chanceChaser = this.chanceChasers.get(key);
        LerpedFloat speedMultiplierChaser = this.speedMultiplierChasers.get(key);
        if (chanceChaser == null) {
            chanceChaser = LerpedFloat.linear();
            this.chanceChasers.put(key, chanceChaser);
        }
        if (speedMultiplierChaser == null) {
            speedMultiplierChaser = LerpedFloat.linear();
            this.speedMultiplierChasers.put(key, speedMultiplierChaser);
        }
        float chanceModifierTarget = (Math.abs(context.getAnimationSpeed()) + 100.0f) / 800.0f;
        chanceModifierTarget *= chanceModifierTarget;
        Object v = context.contraption.presentTileEntities.get(context.localPos);
        if (v instanceof ISpeedNotifiable) {
            ISpeedNotifiable notifiable = (ISpeedNotifiable)v;
            notifiable.notifySpeed(chanceModifierTarget);
        }
        chanceChaser.chase((double)chanceModifierTarget, chanceModifierTarget > chanceChaser.getChaseTarget() ? 0.1 : 0.01, LerpedFloat.Chaser.LINEAR);
        chanceChaser.tickChaser();
        float chanceModifier = chanceChaser.getValue();
        int maxModifier = 0;
        int minModifier = 0;
        if (chanceModifier > 2.0f) {
            maxModifier += (int)((double)chanceModifier + 0.5) - 1;
            minModifier = chanceModifier > 3.0f ? (int)((double)chanceModifier + 0.5) - 2 : 1;
        } else if (chanceModifier > 1.0f) {
            ++maxModifier;
        }
        RandomSource random = context.world.f_46441_;
        SmokeStackBlock.SmokeStackType type = ((SmokeStackBlock)context.state.m_60734_()).type;
        double speedModifierTarget = 5.0 * (0.5 + (double)maxModifier);
        speedMultiplierChaser.chase(speedModifierTarget, 0.4, LerpedFloat.Chaser.LINEAR);
        speedMultiplierChaser.tickChaser();
        if ((double)random.m_188501_() < type.particleSpawnChance * (double)chanceModifier) {
            for (int i = 0; i < random.m_188503_(type.maxParticles + maxModifier - (type.minParticles + minModifier)) + type.minParticles + minModifier; ++i) {
                SmokeStackBlock.makeParticles(context.world, context.position.m_82492_(0.5, 0.0, 0.5), random.m_188499_(), true, type.getParticleSpawnOffset(), type.getParticleSpawnDelta(), speedMultiplierChaser.getValue());
            }
        }
    }
}

