/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.mixin;

import com.railwayteam.railways.Railways;
import com.railwayteam.railways.content.custom_tracks.TrackMaterial;
import com.railwayteam.railways.mixin_interfaces.IHasTrackCasing;
import com.railwayteam.railways.mixin_interfaces.IHasTrackMaterial;
import com.railwayteam.railways.registry.CRTags;
import com.simibubi.create.content.logistics.trains.BezierConnection;
import com.simibubi.create.content.logistics.trains.track.TrackBlock;
import com.simibubi.create.foundation.utility.Couple;
import com.tterrag.registrate.util.entry.BlockEntry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={BezierConnection.class}, remap=false)
public abstract class MixinBezierConnection
implements IHasTrackMaterial,
IHasTrackCasing {
    @Shadow
    public Couple<BlockPos> tePositions;
    protected TrackMaterial trackMaterial;
    protected SlabBlock trackCasing;
    protected boolean isShiftedDown;

    @Shadow
    public abstract Vec3 getPosition(double var1);

    @Override
    @Nullable
    public SlabBlock getTrackCasing() {
        return this.trackCasing;
    }

    @Override
    public void setTrackCasing(@Nullable SlabBlock trackCasing) {
        if (trackCasing != null && CRTags.AllBlockTags.TRACK_CASING_BLACKLIST.matches((Block)trackCasing)) {
            return;
        }
        this.trackCasing = trackCasing;
    }

    @Override
    public boolean isAlternate() {
        return this.isShiftedDown;
    }

    @Override
    public void setAlternate(boolean alternate) {
        this.isShiftedDown = alternate;
    }

    @Override
    public TrackMaterial getMaterial() {
        if (this.trackMaterial == null) {
            BezierConnection this_ = (BezierConnection)this;
            Railways.LOGGER.error("trackMaterial was null!!! for BezierConnection: starts=" + this_.starts + ", primary=" + this_.primary + ", tePositions=" + this_.tePositions);
            this.trackMaterial = TrackMaterial.ANDESITE;
        }
        return this.trackMaterial;
    }

    @Override
    public void setMaterial(TrackMaterial trackMaterial) {
        this.trackMaterial = trackMaterial;
    }

    public BezierConnection withMaterial(TrackMaterial trackMaterial) {
        this.setMaterial(trackMaterial);
        return (BezierConnection)this;
    }

    @Inject(method={"secondary"}, at={@At(value="RETURN")}, cancellable=true, remap=false)
    private void secondary(CallbackInfoReturnable<BezierConnection> cir) {
        ((IHasTrackMaterial)cir.getReturnValue()).setMaterial(this.getMaterial());
        cir.setReturnValue((Object)((BezierConnection)cir.getReturnValue()));
    }

    @Inject(method={"write(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/nbt/CompoundTag;"}, at={@At(value="RETURN")}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD, remap=false)
    private void write(BlockPos localTo, CallbackInfoReturnable<CompoundTag> cir, Couple<BlockPos> tePositions, Couple<Vec3> starts, CompoundTag compound) {
        compound.m_128359_("Material", this.getMaterial().resName());
        if (this.getTrackCasing() != null) {
            if (ForgeRegistries.BLOCKS.getKey((Object)this.getTrackCasing()).toString().equals("minecraft:block")) {
                Railways.LOGGER.error("NBTwrite trackCasing was minecraft:block!!! for BezierConnection: starts=" + starts + ", primary=" + tePositions.getFirst() + ", secondary=" + tePositions.getSecond() + ", casing: " + this.getTrackCasing());
            } else {
                compound.m_128359_("Casing", ForgeRegistries.BLOCKS.getKey((Object)this.getTrackCasing()).toString());
            }
        }
        compound.m_128379_("ShiftDown", this.isAlternate());
        cir.setReturnValue((Object)compound);
    }

    @Inject(method={"write(Lnet/minecraft/network/FriendlyByteBuf;)V"}, at={@At(value="RETURN")}, remap=false)
    private void netWrite(FriendlyByteBuf buffer, CallbackInfo ci) {
        buffer.m_130068_((Enum)this.getMaterial());
        buffer.writeBoolean(this.getTrackCasing() != null);
        if (this.getTrackCasing() != null) {
            buffer.m_130085_(ForgeRegistries.BLOCKS.getKey((Object)this.getTrackCasing()));
            buffer.writeBoolean(this.isAlternate());
        }
    }

    @Inject(method={"<init>(Lnet/minecraft/nbt/CompoundTag;Lnet/minecraft/core/BlockPos;)V"}, at={@At(value="RETURN")}, remap=false)
    private void nbtConstructor(CompoundTag compound, BlockPos localTo, CallbackInfo ci) {
        this.setMaterial(TrackMaterial.ANDESITE);
        if (compound.m_128425_("Material", 8)) {
            this.setMaterial(TrackMaterial.deserialize(compound.m_128461_("Material")));
        }
        if (compound.m_128425_("Casing", 8)) {
            if (compound.m_128461_("Casing").equals("minecraft:block")) {
                Railways.LOGGER.error("NBTCtor trackCasing was minecraft:block!!! for BezierConnection: primary=" + this.tePositions.getFirst() + ", secondary=" + this.tePositions.getSecond());
            }
            this.setTrackCasing((SlabBlock)ForgeRegistries.BLOCKS.getValue(ResourceLocation.m_135822_((String)compound.m_128461_("Casing"), (char)':')));
        }
        if (compound.m_128425_("ShiftDown", 1)) {
            this.setAlternate(compound.m_128471_("ShiftDown"));
        } else {
            this.setAlternate(false);
        }
    }

    @Inject(method={"<init>(Lnet/minecraft/network/FriendlyByteBuf;)V"}, at={@At(value="RETURN")}, remap=false)
    private void byteBufConstructor(FriendlyByteBuf buffer, CallbackInfo ci) {
        this.setMaterial((TrackMaterial)buffer.m_130066_(TrackMaterial.class));
        if (buffer.readBoolean()) {
            this.setTrackCasing((SlabBlock)ForgeRegistries.BLOCKS.getValue(buffer.m_130281_()));
            this.setAlternate(buffer.readBoolean());
        } else {
            this.setTrackCasing(null);
        }
    }

    @Inject(method={"spawnItems"}, at={@At(value="TAIL")})
    private void spawnCasing(Level level, CallbackInfo ci) {
        if (this.getTrackCasing() != null) {
            Vec3 origin = Vec3.m_82528_((Vec3i)((Vec3i)this.tePositions.getFirst()));
            Vec3 spawnPos = this.getPosition(0.5);
            ItemEntity entity = new ItemEntity(level, spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_, new ItemStack((ItemLike)this.getTrackCasing()));
            entity.m_32060_();
            level.m_7967_((Entity)entity);
        }
    }

    @Inject(method={"addItemsToPlayer"}, at={@At(value="TAIL")})
    private void addCasingItem(Player player, CallbackInfo ci) {
        if (this.getTrackCasing() != null) {
            Inventory inv = player.m_150109_();
            inv.m_150079_(new ItemStack((ItemLike)this.getTrackCasing()));
        }
    }

    @Redirect(method={"spawnItems", "spawnDestroyParticles", "addItemsToPlayer"}, at=@At(value="FIELD", opcode=178, target="Lcom/simibubi/create/AllBlocks;TRACK:Lcom/tterrag/registrate/util/entry/BlockEntry;"), remap=false)
    private BlockEntry<TrackBlock> redirectTrackSpawn() {
        return this.getMaterial().getTrackBlock();
    }
}

