/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.mixin;

import com.railwayteam.railways.content.schedule.WaypointDestinationInstruction;
import com.railwayteam.railways.mixin_interfaces.ILimitedGlobalStation;
import com.railwayteam.railways.mixin_interfaces.IWaypointableNavigation;
import com.simibubi.create.content.logistics.trains.TrackNode;
import com.simibubi.create.content.logistics.trains.entity.Navigation;
import com.simibubi.create.content.logistics.trains.entity.Train;
import com.simibubi.create.content.logistics.trains.management.edgePoint.station.GlobalStation;
import com.simibubi.create.content.logistics.trains.management.schedule.ScheduleEntry;
import com.simibubi.create.foundation.utility.Pair;
import java.util.UUID;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;

@Mixin(value={Navigation.class}, remap=false)
public abstract class MixinNavigation
implements IWaypointableNavigation {
    @Shadow
    public Train train;

    @Override
    public boolean isWaypointMode() {
        try {
            return !this.train.manualTick && !this.train.runtime.paused && !this.train.runtime.completed && this.train.runtime.getSchedule() != null && this.train.runtime.currentEntry < this.train.runtime.getSchedule().entries.size() && ((ScheduleEntry)this.train.runtime.getSchedule().entries.get((int)this.train.runtime.currentEntry)).instruction instanceof WaypointDestinationInstruction;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Redirect(method={"tick"}, at=@At(value="FIELD", opcode=180, target="Lcom/simibubi/create/content/logistics/trains/entity/Navigation;distanceToDestination:D"))
    private double fixWaypointDistanceInTick(Navigation instance) {
        if (((IWaypointableNavigation)instance).isWaypointMode()) {
            return 1000.0;
        }
        return instance.distanceToDestination;
    }

    @Redirect(method={"lambda$tick$0"}, at=@At(value="INVOKE", target="Lcom/simibubi/create/content/logistics/trains/management/edgePoint/station/GlobalStation;canApproachFrom(Lcom/simibubi/create/content/logistics/trains/TrackNode;)Z"))
    private boolean keepScoutingAtWaypoints(GlobalStation instance, TrackNode side) {
        return instance.canApproachFrom(side) && !this.isWaypointMode();
    }

    @Redirect(method={"tick"}, at=@At(value="FIELD", opcode=180, target="Lcom/simibubi/create/content/logistics/trains/entity/Navigation;waitingForSignal:Lcom/simibubi/create/foundation/utility/Pair;"), slice=@Slice(from=@At(value="CONSTANT", args={"doubleValue=0.25d"}), to=@At(value="INVOKE", target="Lcom/simibubi/create/content/logistics/trains/entity/Train;leaveStation()V")))
    private Pair<UUID, Boolean> brakeProperlyAtWaypoints(Navigation instance) {
        return this.isWaypointMode() ? null : instance.waitingForSignal;
    }

    @Redirect(method={"currentSignalResolved"}, at=@At(value="FIELD", opcode=180, target="Lcom/simibubi/create/content/logistics/trains/entity/Navigation;distanceToDestination:D"), slice=@Slice(to=@At(value="INVOKE", target="Lcom/simibubi/create/content/logistics/trains/TrackGraph;getPoint(Lcom/simibubi/create/content/logistics/trains/management/edgePoint/EdgePointType;Ljava/util/UUID;)Lcom/simibubi/create/content/logistics/trains/management/edgePoint/signal/TrackEdgePoint;")))
    private double preventSignalClearWithWaypoint(Navigation instance) {
        if (((IWaypointableNavigation)instance).isWaypointMode()) {
            return 10.0;
        }
        return instance.distanceToDestination;
    }

    @Redirect(method={"search(DDZLcom/simibubi/create/content/logistics/trains/entity/Navigation$StationTest;)V"}, at=@At(value="INVOKE", target="Lcom/simibubi/create/content/logistics/trains/management/edgePoint/station/GlobalStation;getPresentTrain()Lcom/simibubi/create/content/logistics/trains/entity/Train;"))
    private Train replacePresentTrain(GlobalStation instance) {
        return ((ILimitedGlobalStation)instance).orDisablingTrain(instance.getPresentTrain(), this.train);
    }
}

