/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.mixin;

import com.railwayteam.railways.mixin_interfaces.ICustomExecutableInstruction;
import com.simibubi.create.content.logistics.trains.management.edgePoint.station.GlobalStation;
import com.simibubi.create.content.logistics.trains.management.schedule.Schedule;
import com.simibubi.create.content.logistics.trains.management.schedule.ScheduleEntry;
import com.simibubi.create.content.logistics.trains.management.schedule.ScheduleRuntime;
import com.simibubi.create.content.logistics.trains.management.schedule.destination.ScheduleInstruction;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ScheduleRuntime.class}, remap=false)
public abstract class MixinScheduleRuntime {
    @Shadow
    Schedule schedule;
    @Shadow
    public int currentEntry;
    @Shadow
    public ScheduleRuntime.State state;
    @Shadow
    public boolean isAutoSchedule;
    private GlobalStation storedGlobalStation;

    @Shadow
    public abstract void discardSchedule();

    @Inject(method={"startCurrentInstruction"}, at={@At(value="HEAD")}, cancellable=true)
    private void startCustomInstruction(CallbackInfoReturnable<GlobalStation> cir) {
        ScheduleEntry entry = (ScheduleEntry)this.schedule.entries.get(this.currentEntry);
        ScheduleInstruction instruction = entry.instruction;
        if (instruction instanceof ICustomExecutableInstruction) {
            ICustomExecutableInstruction customExecutableInstruction = (ICustomExecutableInstruction)instruction;
            cir.setReturnValue((Object)customExecutableInstruction.executeWithStation((ScheduleRuntime)this));
        }
    }

    @Inject(method={"tickConditions"}, at={@At(value="HEAD")}, cancellable=true)
    private void tickWhenNoConditions(Level level, CallbackInfo ci) {
        if (((ScheduleEntry)this.schedule.entries.get((int)this.currentEntry)).conditions.size() == 0) {
            this.state = ScheduleRuntime.State.PRE_TRANSIT;
            ++this.currentEntry;
            ci.cancel();
        }
    }

    @Inject(method={"tick"}, at={@At(value="FIELD", target="Lcom/simibubi/create/content/logistics/trains/management/schedule/ScheduleRuntime;completed:Z", opcode=181, shift=At.Shift.AFTER)})
    private void discardAutoSchedule(Level level, CallbackInfo ci) {
        if (this.isAutoSchedule) {
            this.discardSchedule();
        }
    }

    @Redirect(method={"startCurrentInstruction"}, at=@At(value="FIELD", target="Lcom/simibubi/create/content/logistics/trains/management/edgePoint/station/GlobalStation;name:Ljava/lang/String;"))
    private String storeGlobalStation(GlobalStation instance) {
        this.storedGlobalStation = instance;
        return instance.name;
    }

    @Redirect(method={"startCurrentInstruction"}, at=@At(value="INVOKE", target="Ljava/lang/String;matches(Ljava/lang/String;)Z"))
    private boolean skipDisabledStations(String instance, String regex) {
        boolean stationEnabled = true;
        if (this.storedGlobalStation != null) {
            this.storedGlobalStation = null;
        }
        return instance.matches(regex) && stationEnabled;
    }
}

