/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.mixin;

import com.railwayteam.railways.content.extended_sliding_doors.SlidingDoorMode;
import com.railwayteam.railways.mixin_interfaces.ISidedStation;
import com.simibubi.create.content.contraptions.components.structureMovement.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import com.simibubi.create.content.curiosities.deco.SlidingDoorBlock;
import com.simibubi.create.content.curiosities.deco.SlidingDoorMovementBehaviour;
import com.simibubi.create.content.logistics.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.content.logistics.trains.entity.Train;
import com.simibubi.create.content.logistics.trains.management.edgePoint.station.GlobalStation;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SlidingDoorMovementBehaviour.class}, remap=false)
public class MixinSlidingDoorMovementBehaviour {
    private SlidingDoorMode mode(MovementContext context) {
        return SlidingDoorMode.fromNbt(context.tileData);
    }

    @Inject(method={"shouldUpdate"}, at={@At(value="HEAD")}, cancellable=true)
    private void cancelManualUpdate(MovementContext context, boolean shouldOpen, CallbackInfoReturnable<Boolean> cir) {
        if (context.state != null && context.state.m_61138_((Property)SlidingDoorBlock.f_52730_) && context.state.m_61143_((Property)SlidingDoorBlock.f_52730_) == DoubleBlockHalf.UPPER) {
            cir.setReturnValue((Object)false);
            return;
        }
        if (this.mode(context) == SlidingDoorMode.MANUAL) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"shouldOpen"}, at={@At(value="RETURN", ordinal=1)}, cancellable=true)
    private void openOnlyCorrectSide(MovementContext context, CallbackInfoReturnable<Boolean> cir) {
        SlidingDoorMode mode = this.mode(context);
        if (mode.stationBased) {
            AbstractContraptionEntity abstractContraptionEntity = context.contraption.entity;
            if (abstractContraptionEntity instanceof CarriageContraptionEntity) {
                CarriageContraptionEntity cce = (CarriageContraptionEntity)abstractContraptionEntity;
                Train train = cce.getCarriage().train;
                GlobalStation station = train.getCurrentStation();
                if (station == null) {
                    cir.setReturnValue((Object)false);
                    return;
                }
                if (!(((ISidedStation)station).opensLeft() && mode == SlidingDoorMode.STATION_LEFT || ((ISidedStation)station).opensRight() && mode == SlidingDoorMode.STATION_RIGHT)) {
                    cir.setReturnValue((Object)false);
                    return;
                }
            } else {
                cir.setReturnValue((Object)false);
                return;
            }
        }
    }
}

