/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.mixin;

import com.railwayteam.railways.mixin_interfaces.ILimited;
import com.railwayteam.railways.mixin_interfaces.ISidedStation;
import com.simibubi.create.Create;
import com.simibubi.create.content.logistics.trains.GraphLocation;
import com.simibubi.create.content.logistics.trains.management.edgePoint.signal.TrackEdgePoint;
import com.simibubi.create.content.logistics.trains.management.edgePoint.station.GlobalStation;
import com.simibubi.create.content.logistics.trains.management.edgePoint.station.StationEditPacket;
import com.simibubi.create.content.logistics.trains.management.edgePoint.station.StationTileEntity;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={StationEditPacket.class}, remap=false)
public abstract class MixinStationEditPacket
implements ILimited,
ISidedStation {
    private Boolean limitEnabled;
    private Boolean openRight;
    private Boolean openLeft;

    @Override
    public void setLimitEnabled(boolean limitEnabled) {
        this.limitEnabled = limitEnabled;
    }

    @Override
    public boolean isLimitEnabled() {
        return this.limitEnabled;
    }

    @Override
    public boolean opensRight() {
        return this.openRight;
    }

    @Override
    public boolean opensLeft() {
        return this.openLeft;
    }

    @Override
    public void setOpensRight(boolean opensRight) {
        this.openRight = opensRight;
    }

    @Override
    public void setOpensLeft(boolean opensLeft) {
        this.openLeft = opensLeft;
    }

    @Inject(method={"writeSettings"}, at={@At(value="INVOKE", target="Lnet/minecraft/network/FriendlyByteBuf;writeBoolean(Z)Lio/netty/buffer/ByteBuf;", ordinal=3, remap=true)}, cancellable=true)
    private void writeLimitEnabled(FriendlyByteBuf buffer, CallbackInfo ci) {
        buffer.writeBoolean(this.limitEnabled != null);
        if (this.limitEnabled != null) {
            buffer.writeBoolean(this.limitEnabled.booleanValue());
            ci.cancel();
            return;
        }
        buffer.writeBoolean(this.openRight != null);
        if (this.openRight != null) {
            buffer.writeBoolean(this.openRight.booleanValue());
            ci.cancel();
            return;
        }
        buffer.writeBoolean(this.openLeft != null);
        if (this.openLeft != null) {
            buffer.writeBoolean(this.openLeft.booleanValue());
            ci.cancel();
            return;
        }
    }

    @Inject(method={"readSettings"}, at={@At(value="INVOKE", target="Lnet/minecraft/network/FriendlyByteBuf;readBoolean()Z", ordinal=3, remap=true)}, cancellable=true)
    private void readLimitEnabled(FriendlyByteBuf buffer, CallbackInfo ci) {
        if (buffer.readBoolean()) {
            this.limitEnabled = buffer.readBoolean();
            ci.cancel();
            return;
        }
        if (buffer.readBoolean()) {
            this.openRight = buffer.readBoolean();
            ci.cancel();
            return;
        }
        if (buffer.readBoolean()) {
            this.openLeft = buffer.readBoolean();
            ci.cancel();
            return;
        }
    }

    @Inject(method={"applySettings(Lnet/minecraft/server/level/ServerPlayer;Lcom/simibubi/create/content/logistics/trains/management/edgePoint/station/StationTileEntity;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;getBlock()Lnet/minecraft/world/level/block/Block;", remap=true)})
    private void applyLimit(ServerPlayer player, StationTileEntity te, CallbackInfo ci) {
        GraphLocation graphLocation;
        GlobalStation station;
        if (this.limitEnabled != null) {
            station = te.getStation();
            graphLocation = te.edgePoint.determineGraphLocation();
            if (station != null && graphLocation != null) {
                ((ILimited)station).setLimitEnabled(this.limitEnabled);
                Create.RAILWAYS.sync.pointAdded(graphLocation.graph, (TrackEdgePoint)station);
                Create.RAILWAYS.markTracksDirty();
            }
        }
        if (this.openRight != null) {
            station = te.getStation();
            graphLocation = te.edgePoint.determineGraphLocation();
            if (station != null && graphLocation != null) {
                ((ISidedStation)station).setOpensRight(this.openRight);
                Create.RAILWAYS.sync.pointAdded(graphLocation.graph, (TrackEdgePoint)station);
                Create.RAILWAYS.markTracksDirty();
            }
        }
        if (this.openLeft != null) {
            station = te.getStation();
            graphLocation = te.edgePoint.determineGraphLocation();
            if (station != null && graphLocation != null) {
                ((ISidedStation)station).setOpensLeft(this.openLeft);
                Create.RAILWAYS.sync.pointAdded(graphLocation.graph, (TrackEdgePoint)station);
                Create.RAILWAYS.markTracksDirty();
            }
        }
    }
}

