/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.mixin;

import com.railwayteam.railways.content.custom_tracks.CustomTrackBlock;
import com.railwayteam.railways.content.custom_tracks.TrackMaterial;
import com.railwayteam.railways.content.custom_tracks.monorail.MonorailTrackBlock;
import com.railwayteam.railways.mixin_interfaces.IHasTrackMaterial;
import com.railwayteam.railways.util.AllBlocksWrapper;
import com.simibubi.create.content.logistics.trains.BezierConnection;
import com.simibubi.create.content.logistics.trains.track.TrackBlock;
import com.simibubi.create.content.logistics.trains.track.TrackTileEntity;
import com.simibubi.create.content.schematics.ItemRequirement;
import java.util.ArrayList;
import java.util.EnumMap;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={TrackBlock.class}, remap=false)
public abstract class MixinTrackBlock
extends Block
implements IHasTrackMaterial {
    public MixinTrackBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    @Overwrite
    public ItemRequirement getRequiredItems(BlockState state, BlockEntity te) {
        int sameTypeTrackAmount = 1;
        EnumMap<TrackMaterial, Integer> otherTrackAmounts = new EnumMap<TrackMaterial, Integer>(TrackMaterial.class);
        int girderAmount = 0;
        if (te instanceof TrackTileEntity) {
            TrackTileEntity track = (TrackTileEntity)te;
            for (BezierConnection bezierConnection : track.getConnections().values()) {
                if (!bezierConnection.isPrimary()) continue;
                TrackMaterial material = ((IHasTrackMaterial)bezierConnection).getMaterial();
                if (material == this.getMaterial()) {
                    sameTypeTrackAmount += bezierConnection.getTrackItemCost();
                } else {
                    otherTrackAmounts.put(material, otherTrackAmounts.getOrDefault((Object)material, 0) + 1);
                }
                girderAmount += bezierConnection.getGirderItemCost();
            }
        }
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        while (sameTypeTrackAmount > 0) {
            stacks.add(new ItemStack((ItemLike)state.m_60734_(), Math.min(sameTypeTrackAmount, 64)));
            sameTypeTrackAmount -= 64;
        }
        for (TrackMaterial material : otherTrackAmounts.keySet()) {
            for (int amt = ((Integer)otherTrackAmounts.get((Object)material)).intValue(); amt > 0; amt -= 64) {
                stacks.add(new ItemStack((ItemLike)material.getTrackBlock().get(), Math.min(amt, 64)));
            }
        }
        while (girderAmount > 0) {
            stacks.add(AllBlocksWrapper.metalGirder().asStack(Math.min(girderAmount, 64)));
            girderAmount -= 64;
        }
        return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, stacks);
    }

    @Inject(method={"use"}, at={@At(value="HEAD")}, cancellable=true, remap=true)
    private void extendedUse(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit, CallbackInfoReturnable<InteractionResult> cir) {
        InteractionResult result;
        if (!(this instanceof MonorailTrackBlock) && (result = CustomTrackBlock.casingUse(state, world, pos, player, hand, hit)) != null) {
            cir.setReturnValue((Object)result);
        }
    }
}

