/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.mixin.client;

import com.jozufozu.flywheel.api.InstanceData;
import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.core.Materials;
import com.jozufozu.flywheel.core.materials.model.ModelData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.railwayteam.railways.mixin.client.AccessorBogeyInstance;
import com.railwayteam.railways.mixin_interfaces.IBogeyFrameCanBeMonorail;
import com.railwayteam.railways.registry.CRBlockPartials;
import com.simibubi.create.content.logistics.trains.entity.BogeyInstance;
import com.simibubi.create.content.logistics.trains.entity.CarriageBogey;
import com.simibubi.create.foundation.utility.Iterate;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BogeyInstance.Frame.class}, remap=false)
public class MixinBogeyInstance_Frame
implements IBogeyFrameCanBeMonorail<BogeyInstance.Frame> {
    @Mutable
    @Shadow
    @Final
    private ModelData frame;
    @Mutable
    @Shadow
    @Final
    private ModelData[] wheels;
    private boolean isMonorail = false;
    private boolean isMonorailUpsideDown = false;
    private boolean isLeadingBogeyUpsideDown = false;
    private MaterialManager materialManager;

    @Override
    public boolean isMonorail() {
        return this.isMonorail;
    }

    @Override
    public BogeyInstance.Frame setMonorail(boolean upsideDown, boolean leadingUpsideDown) {
        if (!this.isMonorail && this.materialManager != null) {
            this.frame.delete();
            this.frame = (ModelData)this.materialManager.defaultSolid().material(Materials.TRANSFORMED).getModel(CRBlockPartials.MONOBOGEY_FRAME).createInstance();
            for (ModelData wheel : this.wheels) {
                wheel.delete();
            }
            this.wheels = new ModelData[4];
            this.materialManager.defaultSolid().material(Materials.TRANSFORMED).getModel(CRBlockPartials.MONOBOGEY_WHEEL).createInstances((InstanceData[])this.wheels);
            this.materialManager = null;
            for (ModelData shaft : ((AccessorBogeyInstance)((Object)this)).getShafts()) {
                shaft.delete();
            }
        }
        this.isMonorailUpsideDown = upsideDown;
        this.isLeadingBogeyUpsideDown = leadingUpsideDown;
        this.isMonorail = true;
        return (BogeyInstance.Frame)this;
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void initMonorail(CarriageBogey bogey, MaterialManager materialManager, CallbackInfo ci) {
        this.materialManager = materialManager;
    }

    @Inject(method={"beginFrame"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/logistics/trains/entity/BogeyInstance;beginFrame(FLcom/mojang/blaze3d/vertex/PoseStack;)V", shift=At.Shift.AFTER)}, cancellable=true)
    private void beginMonorailFrame(float wheelAngle, PoseStack ms, CallbackInfo ci) {
        if (this.isMonorail()) {
            ci.cancel();
            if (ms == null) {
                this.frame.setEmptyTransform();
                for (boolean left : Iterate.trueAndFalse) {
                    for (int front : Iterate.positiveAndNegative) {
                        this.wheels[(left ? 1 : 0) + (front + 1)].setEmptyTransform();
                    }
                }
                return;
            }
            this.frame.setTransform(ms);
            float wheelY = 0.1875f;
            for (boolean left : Iterate.trueAndFalse) {
                for (int front : Iterate.positiveAndNegative) {
                    ((ModelData)this.wheels[(left ? 1 : 0) + (front + 1)].setTransform(ms).translate(left ? -0.75 : 0.75, (double)wheelY, (double)((float)(front * 15) / 16.0f)).rotateY(left ? (double)wheelAngle : (double)(-wheelAngle))).translate(0.9375, 0.0, 0.0);
                }
            }
        }
    }
}

