/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.mixin.client;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.railwayteam.railways.content.conductor.ConductorEntity;
import com.railwayteam.railways.content.conductor.toolbox.CustomRadialToolboxMenu;
import com.railwayteam.railways.content.conductor.toolbox.MountedToolboxHolder;
import com.railwayteam.railways.mixin_interfaces.IMountedToolboxHandler;
import com.simibubi.create.AllKeys;
import com.simibubi.create.content.curiosities.toolbox.RadialToolboxMenu;
import com.simibubi.create.content.curiosities.toolbox.ToolboxHandler;
import com.simibubi.create.content.curiosities.toolbox.ToolboxHandlerClient;
import com.simibubi.create.content.curiosities.toolbox.ToolboxTileEntity;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.ScreenOpener;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={ToolboxHandlerClient.class})
public class MixinToolboxHandlerClient {
    @Shadow(remap=false)
    static int COOLDOWN;

    @Overwrite(remap=false)
    public static void onKeyInput(int key, boolean pressed) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91072_ == null || mc.f_91072_.m_105295_() == GameType.SPECTATOR) {
            return;
        }
        if (key != AllKeys.TOOLBELT.getBoundCode()) {
            return;
        }
        if (COOLDOWN > 0) {
            return;
        }
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        Level level = player.f_19853_;
        List<Object> toolbox_like = IMountedToolboxHandler.getNearest((LevelAccessor)player.f_19853_, (Player)player, 8);
        List<ToolboxTileEntity> toolboxes = toolbox_like.stream().filter(obj -> obj.getClass() == ToolboxTileEntity.class).map(obj -> (ToolboxTileEntity)obj).collect(Collectors.toList());
        List<ConductorEntity> conductors = toolbox_like.stream().filter(obj -> obj.getClass() == ConductorEntity.class && ((ConductorEntity)((Object)((Object)obj))).isCarryingToolbox()).map(obj -> (ConductorEntity)((Object)((Object)obj))).toList();
        toolbox_like.sort(Comparator.comparing(obj -> {
            ConductorEntity ce;
            if (obj.getClass() == ToolboxTileEntity.class) {
                return ((ToolboxTileEntity)obj).getUniqueId();
            }
            if (obj.getClass() == ConductorEntity.class && (ce = (ConductorEntity)((Object)((Object)obj))).isCarryingToolbox()) {
                return ce.getToolboxHolder().getUniqueId();
            }
            return UUID.randomUUID();
        }));
        CompoundTag compound = player.getPersistentData().m_128469_("CreateToolboxData");
        String slotKey = String.valueOf(player.m_150109_().f_35977_);
        boolean equipped = compound.m_128441_(slotKey);
        if (equipped) {
            BlockEntity blockEntity;
            boolean canReachToolbox;
            if (compound.m_128469_(slotKey).m_128403_("EntityUUID")) {
                ConductorEntity ce;
                UUID uuid = compound.m_128469_(slotKey).m_128342_("EntityUUID");
                double max = IMountedToolboxHandler.getMaxRange((Player)player);
                List<ConductorEntity> entities = level.m_45976_(ConductorEntity.class, AABB.m_165882_((Vec3)player.m_20182_(), (double)19.0, (double)19.0, (double)19.0)).stream().filter(entity -> entity != null && entity.m_20148_().equals(uuid)).toList();
                if (!entities.isEmpty() && (ce = entities.get(0)).isCarryingToolbox()) {
                    boolean canReachToolbox2;
                    boolean bl = canReachToolbox2 = IMountedToolboxHandler.distance(player.m_20182_(), ce.m_20182_()) < max * max;
                    if (canReachToolbox2) {
                        MountedToolboxHolder holder = ce.getToolboxHolder();
                        CustomRadialToolboxMenu screen = new CustomRadialToolboxMenu(toolboxes, conductors, RadialToolboxMenu.State.SELECT_ITEM_UNEQUIP, holder == null ? null : holder.getParent());
                        screen.prevSlot(compound.m_128469_(slotKey).m_128451_("Slot"));
                        ScreenOpener.open((Screen)screen);
                        return;
                    }
                }
                ScreenOpener.open((Screen)new CustomRadialToolboxMenu((List<ToolboxTileEntity>)ImmutableList.of(), RadialToolboxMenu.State.DETACH, null));
                return;
            }
            BlockPos pos = NbtUtils.m_129239_((CompoundTag)compound.m_128469_(slotKey).m_128469_("Pos"));
            double max = ToolboxHandler.getMaxRange((Player)player);
            boolean bl = canReachToolbox = ToolboxHandler.distance((Vec3)player.m_20182_(), (BlockPos)pos) < max * max;
            if (canReachToolbox && (blockEntity = level.m_7702_(pos)) instanceof ToolboxTileEntity) {
                CustomRadialToolboxMenu screen = new CustomRadialToolboxMenu(toolboxes, conductors, RadialToolboxMenu.State.SELECT_ITEM_UNEQUIP, (ToolboxTileEntity)blockEntity);
                screen.prevSlot(compound.m_128469_(slotKey).m_128451_("Slot"));
                ScreenOpener.open((Screen)screen);
                return;
            }
            ScreenOpener.open((Screen)new CustomRadialToolboxMenu((List<ToolboxTileEntity>)ImmutableList.of(), RadialToolboxMenu.State.DETACH, null));
            return;
        }
        if (toolbox_like.isEmpty()) {
            return;
        }
        if (toolboxes.size() == 1 && conductors.size() == 0) {
            ScreenOpener.open((Screen)new CustomRadialToolboxMenu(toolboxes, conductors, RadialToolboxMenu.State.SELECT_ITEM, (ToolboxTileEntity)toolboxes.get(0)));
        } else if (toolboxes.size() == 0 && conductors.size() == 1) {
            ScreenOpener.open((Screen)new CustomRadialToolboxMenu(toolboxes, conductors, RadialToolboxMenu.State.SELECT_ITEM, conductors.get(0)));
        } else {
            ScreenOpener.open((Screen)new CustomRadialToolboxMenu(toolboxes, conductors, RadialToolboxMenu.State.SELECT_BOX, (ToolboxTileEntity)null));
        }
    }

    @Inject(at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;pushPose()V", remap=true)}, method={"renderOverlay"}, locals=LocalCapture.CAPTURE_FAILHARD, remap=false, cancellable=true, require=1)
    private static void inj$renderOverlay(ForgeGui gui, PoseStack poseStack, float partialTicks, int width, int height, CallbackInfo ci, Minecraft mc, int x, int y, Player player, CompoundTag persistentData, CompoundTag compound) {
        poseStack.m_85836_();
        for (int slot = 0; slot < 9; ++slot) {
            int offset;
            String key = String.valueOf(slot);
            if (!compound.m_128441_(key)) continue;
            if (compound.m_128469_(key).m_128403_("EntityUUID")) {
                ConductorEntity ce;
                double max = IMountedToolboxHandler.getMaxRange(player);
                boolean selected = player.m_150109_().f_35977_ == slot;
                int offset2 = selected ? 1 : 0;
                UUID uuid = compound.m_128469_(key).m_128342_("EntityUUID");
                List<ConductorEntity> entities = player.f_19853_.m_45976_(ConductorEntity.class, AABB.m_165882_((Vec3)player.m_20182_(), (double)19.0, (double)19.0, (double)19.0)).stream().filter(entity -> entity != null && entity.m_20148_().equals(uuid)).toList();
                boolean inRange = false;
                if (!entities.isEmpty() && (ce = entities.get(0)).isCarryingToolbox()) {
                    boolean bl = inRange = IMountedToolboxHandler.distance(player.m_20182_(), ce.m_20182_()) < max * max;
                }
                AllGuiTextures texture = inRange ? (selected ? AllGuiTextures.TOOLBELT_SELECTED_ON : AllGuiTextures.TOOLBELT_HOTBAR_ON) : (selected ? AllGuiTextures.TOOLBELT_SELECTED_OFF : AllGuiTextures.TOOLBELT_HOTBAR_OFF);
                texture.render(poseStack, x + 20 * slot - offset2, y + offset2);
                continue;
            }
            BlockPos pos = NbtUtils.m_129239_((CompoundTag)compound.m_128469_(key).m_128469_("Pos"));
            double max = ToolboxHandler.getMaxRange((Player)player);
            boolean selected = player.m_150109_().f_35977_ == slot;
            int n = offset = selected ? 1 : 0;
            AllGuiTextures texture = ToolboxHandler.distance((Vec3)player.m_20182_(), (BlockPos)pos) < max * max ? (selected ? AllGuiTextures.TOOLBELT_SELECTED_ON : AllGuiTextures.TOOLBELT_HOTBAR_ON) : (selected ? AllGuiTextures.TOOLBELT_SELECTED_OFF : AllGuiTextures.TOOLBELT_HOTBAR_OFF);
            texture.render(poseStack, x + 20 * slot - offset, y + offset);
        }
        poseStack.m_85849_();
        ci.cancel();
    }
}

