/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.mixin.client;

import com.jozufozu.flywheel.api.InstanceData;
import com.jozufozu.flywheel.api.Material;
import com.jozufozu.flywheel.core.Materials;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.core.materials.model.ModelData;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.railwayteam.railways.content.custom_tracks.TrackMaterial;
import com.railwayteam.railways.mixin.client.AccessorInstance;
import com.railwayteam.railways.mixin_interfaces.IGetBezierConnection;
import com.railwayteam.railways.mixin_interfaces.IHasTrackMaterial;
import com.railwayteam.railways.mixin_interfaces.IMonorailBezier;
import com.railwayteam.railways.registry.CRBlockPartials;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.logistics.trains.BezierConnection;
import com.simibubi.create.content.logistics.trains.track.TrackInstance;
import com.simibubi.create.foundation.utility.Iterate;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@OnlyIn(value=Dist.CLIENT)
@Mixin(targets={"com.simibubi.create.content.logistics.trains.track.TrackInstance$BezierTrackInstance"}, remap=false)
public abstract class MixinTrackInstance_BezierTrackInstance {
    @Final
    @Shadow(aliases={"this$0"})
    TrackInstance myOuter;
    @Mutable
    @Shadow
    @Final
    private ModelData[] ties;
    @Mutable
    @Shadow
    @Final
    private ModelData[] right;
    @Mutable
    @Shadow
    @Final
    private ModelData[] left;
    @Shadow
    @Final
    private TrackInstance this$0;
    @Mutable
    @Shadow
    @Final
    private BlockPos[] tiesLightPos;
    @Mutable
    @Shadow
    @Final
    private BlockPos[] leftLightPos;
    @Mutable
    @Shadow
    @Final
    private BlockPos[] rightLightPos;

    @Shadow
    abstract void updateLight();

    @Redirect(method={"<init>"}, at=@At(value="FIELD", opcode=178, target="Lcom/simibubi/create/AllBlockPartials;TRACK_TIE:Lcom/jozufozu/flywheel/core/PartialModel;"), remap=false)
    private PartialModel replaceTie() {
        TrackMaterial material;
        BezierConnection bc = ((IGetBezierConnection)this.myOuter).getBezierConnection();
        if (bc != null && (material = ((IHasTrackMaterial)bc).getMaterial()).isCustom()) {
            return CRBlockPartials.TRACK_PARTS.get((Object)((Object)material)).tie;
        }
        return AllBlockPartials.TRACK_TIE;
    }

    @Redirect(method={"<init>"}, at=@At(value="FIELD", opcode=178, target="Lcom/simibubi/create/AllBlockPartials;TRACK_SEGMENT_LEFT:Lcom/jozufozu/flywheel/core/PartialModel;"), remap=false)
    private PartialModel replaceSegLeft() {
        TrackMaterial material;
        BezierConnection bc = ((IGetBezierConnection)this.myOuter).getBezierConnection();
        if (bc != null && (material = ((IHasTrackMaterial)bc).getMaterial()).isCustom()) {
            return CRBlockPartials.TRACK_PARTS.get((Object)((Object)material)).segment_left;
        }
        return AllBlockPartials.TRACK_SEGMENT_LEFT;
    }

    @Redirect(method={"<init>"}, at=@At(value="FIELD", opcode=178, target="Lcom/simibubi/create/AllBlockPartials;TRACK_SEGMENT_RIGHT:Lcom/jozufozu/flywheel/core/PartialModel;"), remap=false)
    private PartialModel replaceSegRight() {
        TrackMaterial material;
        BezierConnection bc = ((IGetBezierConnection)this.myOuter).getBezierConnection();
        if (bc != null && (material = ((IHasTrackMaterial)bc).getMaterial()).isCustom()) {
            return CRBlockPartials.TRACK_PARTS.get((Object)((Object)material)).segment_right;
        }
        return AllBlockPartials.TRACK_SEGMENT_RIGHT;
    }

    @Redirect(method={"<init>"}, at=@At(value="INVOKE", target="Lcom/simibubi/create/content/logistics/trains/BezierConnection;getSegmentCount()I", remap=false))
    private int messWithCtor(BezierConnection instance) {
        return ((IHasTrackMaterial)instance).getMaterial().trackType == TrackMaterial.TrackType.MONORAIL ? 0 : instance.getSegmentCount();
    }

    @Redirect(method={"<init>"}, at=@At(value="INVOKE", target="Lcom/simibubi/create/content/logistics/trains/BezierConnection;getBakedSegments()[Lcom/simibubi/create/content/logistics/trains/BezierConnection$SegmentAngles;", remap=false))
    private BezierConnection.SegmentAngles[] messWithCtor2(BezierConnection instance) {
        return ((IHasTrackMaterial)instance).getMaterial().trackType == TrackMaterial.TrackType.MONORAIL ? new BezierConnection.SegmentAngles[]{} : instance.getBakedSegments();
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")}, remap=false)
    private void addActualMonorail(TrackInstance trackInstance, BezierConnection bc, CallbackInfo ci) {
        if (((IHasTrackMaterial)bc).getMaterial().trackType == TrackMaterial.TrackType.MONORAIL) {
            BlockPos tePosition = (BlockPos)bc.tePositions.getFirst();
            PoseStack pose = new PoseStack();
            ((TransformStack)TransformStack.cast((PoseStack)pose).translate((Vec3i)this.this$0.getInstancePosition())).nudge((int)((BlockPos)bc.tePositions.getFirst()).m_121878_());
            BlockState air = Blocks.f_50016_.m_49966_();
            IMonorailBezier.MonorailAngles[] monorails = ((IMonorailBezier)bc).getBakedMonorails();
            Material mat = ((AccessorInstance)this.this$0).getMaterialManager().cutout(RenderType.m_110457_()).material(Materials.TRANSFORMED);
            this.right = new ModelData[monorails.length - 1];
            this.ties = new ModelData[monorails.length - 1];
            this.left = new ModelData[monorails.length - 1];
            this.tiesLightPos = new BlockPos[monorails.length - 1];
            this.leftLightPos = new BlockPos[monorails.length - 1];
            this.rightLightPos = new BlockPos[monorails.length - 1];
            ModelData[] top = this.right;
            ModelData[] middle = this.ties;
            ModelData[] bottom = this.left;
            BlockPos[] topLight = this.rightLightPos;
            BlockPos[] middleLight = this.tiesLightPos;
            BlockPos[] bottomLight = this.leftLightPos;
            mat.getModel(CRBlockPartials.MONORAIL_SEGMENT_TOP).createInstances((InstanceData[])top);
            mat.getModel(CRBlockPartials.MONORAIL_SEGMENT_MIDDLE).createInstances((InstanceData[])middle);
            mat.getModel(CRBlockPartials.MONORAIL_SEGMENT_BOTTOM).createInstances((InstanceData[])bottom);
            for (int i = 1; i < monorails.length; ++i) {
                IMonorailBezier.MonorailAngles segment = monorails[i];
                int modelIndex = i - 1;
                PoseStack.Pose beamTransform = segment.beam;
                middle[modelIndex].setTransform(pose).mulPose(beamTransform.m_85861_()).mulNormal(beamTransform.m_85864_());
                middleLight[modelIndex] = segment.lightPosition.m_121955_((Vec3i)tePosition);
                for (boolean isTop : Iterate.trueAndFalse) {
                    PoseStack.Pose beamCapTransform = (PoseStack.Pose)segment.beamCaps.get(isTop);
                    (isTop ? top : bottom)[modelIndex].setTransform(pose).mulPose(beamCapTransform.m_85861_()).mulNormal(beamCapTransform.m_85864_());
                    (isTop ? topLight : bottomLight)[modelIndex] = segment.lightPosition.m_121955_((Vec3i)tePosition);
                }
            }
            this.updateLight();
        }
    }
}

