/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.mixin_interfaces;

import com.railwayteam.railways.content.conductor.ConductorEntity;
import com.simibubi.create.content.curiosities.toolbox.ToolboxHandler;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.utility.WorldAttached;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;

public interface IMountedToolboxHandler {
    public static final WorldAttached<WeakHashMap<UUID, ConductorEntity>> conductors = new WorldAttached(w -> new WeakHashMap());

    public static void onLoad(ConductorEntity ce) {
        ((WeakHashMap)conductors.get((LevelAccessor)ce.m_9236_())).put(ce.m_20148_(), ce);
    }

    public static void onUnload(ConductorEntity ce) {
        ((WeakHashMap)conductors.get((LevelAccessor)ce.m_9236_())).remove(ce.m_20148_());
    }

    public static List<Object> getNearest(LevelAccessor world, Player player, int maxAmount) {
        Vec3 location = player.m_20182_();
        double maxRange = IMountedToolboxHandler.getMaxRange(player);
        return Stream.concat(((WeakHashMap)conductors.get(world)).keySet().stream().map(((WeakHashMap)conductors.get(world))::get).filter(ce -> ce != null && ce.m_6084_() && !ce.m_213877_()).filter(p -> IMountedToolboxHandler.distance(location, p.m_20182_()) < maxRange * maxRange).sorted(Comparator.comparingDouble(p -> IMountedToolboxHandler.distance(location, p.m_20182_()))).limit(maxAmount).filter(ce -> {
            if (!ce.isCarryingToolbox()) {
                return false;
            }
            return ce.getToolboxHolder().isFullyInitialized();
        }), ToolboxHandler.getNearest((LevelAccessor)world, (Player)player, (int)maxAmount).stream()).limit(maxAmount).collect(Collectors.toList());
    }

    public static boolean withinRange(Player player, ConductorEntity ce) {
        if (player.f_19853_ != ce.m_9236_()) {
            return false;
        }
        double maxRange = IMountedToolboxHandler.getMaxRange(player);
        return IMountedToolboxHandler.distance(player.m_20182_(), ce.m_20182_()) < maxRange * maxRange;
    }

    public static double distance(Vec3 location, Vec3 p) {
        return location.m_82557_(p);
    }

    public static double getMaxRange(Player player) {
        return ((Integer)AllConfigs.SERVER.curiosities.toolboxRange.get()).doubleValue();
    }
}

