/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.registry;

import com.railwayteam.railways.Railways;
import com.railwayteam.railways.content.conductor.ConductorCapItem;
import com.railwayteam.railways.content.custom_tracks.TrackMaterial;
import com.railwayteam.railways.content.minecarts.MinecartItem;
import com.railwayteam.railways.registry.CREntities;
import com.railwayteam.railways.registry.CRTags;
import com.railwayteam.railways.util.TextUtils;
import com.simibubi.create.content.contraptions.itemAssembly.SequencedAssemblyItem;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import com.tterrag.registrate.util.entry.EntityEntry;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.registries.ForgeRegistries;

public class CRItems {
    private static final CreateRegistrate REGISTRATE = Railways.registrate();
    public static final CreativeModeTab itemGroup = new CreativeModeTab("railways"){

        @Nonnull
        public ItemStack m_6976_() {
            return ITEM_CONDUCTOR_CAP.get(DyeColor.BLUE).asStack();
        }
    };
    public static final TagKey<Item> CONDUCTOR_CAPS;
    public static final ItemEntry<? extends Item> ITEM_BENCHCART;
    public static final ItemEntry<? extends Item> ITEM_JUKEBOXCART;
    public static final EnumMap<DyeColor, ItemEntry<ConductorCapItem>> ITEM_CONDUCTOR_CAP;
    public static final EnumMap<DyeColor, ItemEntry<SequencedAssemblyItem>> ITEM_INCOMPLETE_CONDUCTOR_CAP;
    public static final EnumMap<TrackMaterial, ItemEntry<SequencedAssemblyItem>> ITEM_INCOMPLETE_TRACK;

    public static TagKey<Item> makeForgeItemTag(String path) {
        return CRItems.makeItemTag("forge", path);
    }

    public static TagKey<Item> makeItemTag(String mod, String path) {
        return ForgeRegistries.ITEMS.tags().createOptionalTagKey(new ResourceLocation(mod, path), Collections.emptySet());
    }

    private static ItemBuilder<? extends Item, ?> makeMinecart(String name, Supplier<EntityEntry<?>> entity) {
        return REGISTRATE.item(name, props -> new MinecartItem((Item.Properties)props, (EntityEntry<?>)((EntityEntry)entity.get()))).model((ctx, prov) -> ((ItemModelBuilder)prov.withExistingParent(name, prov.mcLoc("item/minecart"))).texture("layer0", prov.modLoc("item/" + name)));
    }

    public static Item woolByColor(DyeColor color) {
        return switch (color) {
            default -> throw new IncompatibleClassChangeError();
            case DyeColor.WHITE -> Items.f_41870_;
            case DyeColor.ORANGE -> Items.f_41871_;
            case DyeColor.MAGENTA -> Items.f_41872_;
            case DyeColor.LIGHT_BLUE -> Items.f_41873_;
            case DyeColor.YELLOW -> Items.f_41874_;
            case DyeColor.LIME -> Items.f_41875_;
            case DyeColor.PINK -> Items.f_41876_;
            case DyeColor.GRAY -> Items.f_41877_;
            case DyeColor.LIGHT_GRAY -> Items.f_41878_;
            case DyeColor.CYAN -> Items.f_41932_;
            case DyeColor.PURPLE -> Items.f_41933_;
            case DyeColor.BLUE -> Items.f_41934_;
            case DyeColor.BROWN -> Items.f_41935_;
            case DyeColor.GREEN -> Items.f_41936_;
            case DyeColor.RED -> Items.f_41937_;
            case DyeColor.BLACK -> Items.f_41938_;
        };
    }

    private static ItemEntry<SequencedAssemblyItem> sequencedIngredient(String name) {
        return REGISTRATE.item(name, SequencedAssemblyItem::new).register();
    }

    public static void register() {
    }

    static {
        REGISTRATE.creativeModeTab(() -> itemGroup, "Create Railways");
        CONDUCTOR_CAPS = CRTags.AllItemTags.CONDUCTOR_CAPS.tag;
        ITEM_BENCHCART = CRItems.makeMinecart("benchcart", () -> CREntities.CART_BLOCK).recipe((ctx, prov) -> ShapelessRecipeBuilder.m_126189_((ItemLike)((ItemLike)ctx.get())).m_126209_((ItemLike)Items.f_42449_).m_126209_((ItemLike)Items.f_41960_).m_126132_("hasitem", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{Items.f_42449_})).m_176498_((Consumer)prov)).lang("Minecart with Workbench").register();
        ITEM_JUKEBOXCART = CRItems.makeMinecart("jukeboxcart", () -> CREntities.CART_JUKEBOX).recipe((ctx, prov) -> ShapelessRecipeBuilder.m_126189_((ItemLike)((ItemLike)ctx.get())).m_126209_((ItemLike)Items.f_42449_).m_126209_((ItemLike)Items.f_41984_).m_126132_("hasitem", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{Items.f_42449_})).m_176498_((Consumer)prov)).lang("Minecart with Jukebox").register();
        ITEM_CONDUCTOR_CAP = new EnumMap(DyeColor.class);
        ITEM_INCOMPLETE_CONDUCTOR_CAP = new EnumMap(DyeColor.class);
        ITEM_INCOMPLETE_TRACK = new EnumMap(TrackMaterial.class);
        for (DyeColor dyeColor : DyeColor.values()) {
            String colorName = TextUtils.titleCaseConversion(dyeColor.m_41065_().replace("_", " "));
            String colorReg = dyeColor.m_41065_().toLowerCase(Locale.ROOT);
            ITEM_INCOMPLETE_CONDUCTOR_CAP.put(dyeColor, (ItemEntry<SequencedAssemblyItem>)REGISTRATE.item(colorReg + "_incomplete_conductor_cap", SequencedAssemblyItem::new).model((dataGenContext, itemModelProvider) -> ((ItemModelBuilder)itemModelProvider.withExistingParent(colorReg + "_incomplete_conductor_cap", itemModelProvider.modLoc("item/incomplete_conductor_cap"))).texture("cap", itemModelProvider.modLoc("entity/caps/" + colorReg + "_conductor_cap"))).lang("Incomplete " + colorName + " Conductor's Cap").register());
            ITEM_CONDUCTOR_CAP.put(dyeColor, (ItemEntry<ConductorCapItem>)REGISTRATE.item(colorReg + "_conductor_cap", p -> new ConductorCapItem((Item.Properties)p, color)).model((dataGenContext, itemModelProvider) -> ((ItemModelBuilder)itemModelProvider.withExistingParent(colorReg + "_conductor_cap", itemModelProvider.modLoc("item/conductor_cap"))).texture("cap", itemModelProvider.modLoc("entity/caps/" + colorReg + "_conductor_cap"))).lang(colorName + " Conductor's Cap").tag(new TagKey[]{CONDUCTOR_CAPS}).properties(p -> p.m_41487_(1)).recipe((ctx, prov) -> ShapelessRecipeBuilder.m_126189_((ItemLike)((ItemLike)ctx.get())).m_206419_(CONDUCTOR_CAPS).m_206419_(color.getTag()).m_126132_("hasitem", (CriterionTriggerInstance)RegistrateRecipeProvider.m_206406_(CONDUCTOR_CAPS)).m_126140_((Consumer)prov, new ResourceLocation("railways", "dying_existing_cap_" + colorReg))).register());
        }
        for (TrackMaterial trackMaterial : TrackMaterial.allCustom()) {
            ITEM_INCOMPLETE_TRACK.put(trackMaterial, (ItemEntry<SequencedAssemblyItem>)REGISTRATE.item("track_incomplete_" + trackMaterial.resName(), SequencedAssemblyItem::new).model((c, p) -> p.generated((NonNullSupplier)c, new ResourceLocation[]{Railways.asResource("item/track_incomplete/" + c.getName())})).lang("Incomplete " + trackMaterial.langName + " Track").register());
        }
    }
}

