/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.registry;

import com.railwayteam.railways.Railways;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllTags;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.data.recipe.Mods;
import com.simibubi.create.foundation.utility.Lang;
import com.tterrag.registrate.providers.ProviderType;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class CRTags {
    private static final CreateRegistrate REGISTRATE = Railways.registrate();

    public static void register() {
        AllBlockTags.TRACKS.addOptional(AllBlocks.TRACK.getId());
    }

    public static enum AllBlockTags {
        TRACKS,
        SEMAPHORE_POLES(NameSpace.MOD, NameSpace.MOD.optionalDefault, false),
        TRACK_CASING_BLACKLIST(NameSpace.MOD, NameSpace.MOD.optionalDefault, false);

        public final TagKey<Block> tag;

        private AllBlockTags() {
            this(NameSpace.MOD);
        }

        private AllBlockTags(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private AllBlockTags(NameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private AllBlockTags(NameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private AllBlockTags(NameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = new ResourceLocation(namespace.id, path == null ? Lang.asId((String)this.name()) : path);
            this.tag = optional ? AllTags.optionalTag((IForgeRegistry)ForgeRegistries.BLOCKS, (ResourceLocation)id) : BlockTags.create((ResourceLocation)id);
            if (alwaysDatagen) {
                REGISTRATE.addDataGenerator(ProviderType.BLOCK_TAGS, prov -> prov.m_206424_(this.tag));
            }
        }

        public boolean matches(Block block) {
            return block.m_204297_().m_203656_(this.tag);
        }

        public boolean matches(ItemStack stack) {
            BlockItem blockItem;
            Item item;
            return stack != null && (item = stack.m_41720_()) instanceof BlockItem && this.matches((blockItem = (BlockItem)item).m_40614_());
        }

        public boolean matches(BlockState state) {
            return state.m_204336_(this.tag);
        }

        public void add(Block ... values) {
            REGISTRATE.addDataGenerator(ProviderType.BLOCK_TAGS, prov -> prov.m_206424_(this.tag).m_126584_((Object[])values));
        }

        public void addOptional(Mods mod, String ... ids) {
            REGISTRATE.addDataGenerator(ProviderType.BLOCK_TAGS, prov -> {
                TagsProvider.TagAppender builder = prov.m_206424_(this.tag);
                for (String id : ids) {
                    builder.m_176839_(mod.asResource(id));
                }
            });
        }

        public void addOptional(String namespace, String ... ids) {
            REGISTRATE.addDataGenerator(ProviderType.BLOCK_TAGS, prov -> {
                TagsProvider.TagAppender builder = prov.m_206424_(this.tag);
                for (String id : ids) {
                    builder.m_176839_(new ResourceLocation(namespace, id));
                }
            });
        }

        public void addOptional(ResourceLocation location) {
            this.addOptional(location.m_135827_(), location.m_135815_());
        }

        public void includeIn(TagKey<Block> parent) {
            REGISTRATE.addDataGenerator(ProviderType.BLOCK_TAGS, prov -> prov.m_206424_(parent).m_206428_(this.tag));
        }

        public void includeIn(AllTags.AllBlockTags parent) {
            this.includeIn((TagKey<Block>)parent.tag);
        }

        public void includeAll(TagKey<Block> child) {
            REGISTRATE.addDataGenerator(ProviderType.BLOCK_TAGS, prov -> prov.m_206424_(this.tag).m_206428_(child));
        }
    }

    public static enum AllItemTags {
        CONDUCTOR_CAPS;

        public final TagKey<Item> tag;
        public final boolean alwaysDatagen;

        private AllItemTags() {
            this(NameSpace.MOD);
        }

        private AllItemTags(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private AllItemTags(NameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private AllItemTags(NameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private AllItemTags(NameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = new ResourceLocation(namespace.id, path == null ? Lang.asId((String)this.name()) : path);
            this.tag = optional ? AllTags.optionalTag((IForgeRegistry)ForgeRegistries.ITEMS, (ResourceLocation)id) : ItemTags.create((ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagen;
        }

        public boolean matches(Item item) {
            return item.m_204114_().m_203656_(this.tag);
        }

        public boolean matches(ItemStack stack) {
            return stack.m_204117_(this.tag);
        }

        public void add(Item ... values) {
            REGISTRATE.addDataGenerator(ProviderType.ITEM_TAGS, prov -> prov.m_206424_(this.tag).m_126584_((Object[])values));
        }

        public void addOptional(Mods mod, String ... ids) {
            REGISTRATE.addDataGenerator(ProviderType.ITEM_TAGS, prov -> {
                TagsProvider.TagAppender builder = prov.m_206424_(this.tag);
                for (String id : ids) {
                    builder.m_176839_(mod.asResource(id));
                }
            });
        }

        public void addOptional(String namespace, String ... ids) {
            REGISTRATE.addDataGenerator(ProviderType.ITEM_TAGS, prov -> {
                TagsProvider.TagAppender builder = prov.m_206424_(this.tag);
                for (String id : ids) {
                    builder.m_176839_(new ResourceLocation(namespace, id));
                }
            });
        }

        public void addOptional(ResourceLocation location) {
            this.addOptional(location.m_135827_(), location.m_135815_());
        }

        public void includeIn(TagKey<Item> parent) {
            REGISTRATE.addDataGenerator(ProviderType.ITEM_TAGS, prov -> prov.m_206424_(parent).m_206428_(this.tag));
        }

        public void includeIn(AllTags.AllItemTags parent) {
            this.includeIn((TagKey<Item>)parent.tag);
        }

        public void includeAll(TagKey<Item> child) {
            REGISTRATE.addDataGenerator(ProviderType.ITEM_TAGS, prov -> prov.m_206424_(this.tag).m_206428_(child));
        }
    }

    public static enum NameSpace {
        MOD("railways", false, true),
        FORGE("forge");

        public final String id;
        public final boolean optionalDefault;
        public final boolean alwaysDatagenDefault;

        private NameSpace(String id) {
            this(id, true, false);
        }

        private NameSpace(String id, boolean optionalDefault, boolean alwaysDatagenDefault) {
            this.id = id;
            this.optionalDefault = optionalDefault;
            this.alwaysDatagenDefault = alwaysDatagenDefault;
        }
    }
}

