/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.util.packet;

import com.railwayteam.railways.mixin.AccessorTrain;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.logistics.trains.entity.Train;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class AddTrainEndPacket
extends SimplePacketBase {
    final UUID trainId;
    final UUID backTrainId;
    final int middleSpacing;
    final boolean doubleEnded;

    public AddTrainEndPacket(Train train, Train backTrain, int middleSpacing, boolean doubleEnded) {
        this.trainId = train.id;
        this.backTrainId = backTrain.id;
        this.middleSpacing = middleSpacing;
        this.doubleEnded = doubleEnded;
    }

    public AddTrainEndPacket(FriendlyByteBuf buf) {
        this.trainId = buf.m_130259_();
        this.backTrainId = buf.m_130259_();
        this.middleSpacing = buf.readInt();
        this.doubleEnded = buf.readBoolean();
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.trainId);
        buffer.m_130077_(this.backTrainId);
        buffer.writeInt(this.middleSpacing);
        buffer.writeBoolean(this.doubleEnded);
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> this.lambda$handle$1((Supplier)context)));
        context.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void __handle(Supplier<NetworkEvent.Context> supplier) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null) {
            Train train = (Train)CreateClient.RAILWAYS.trains.get(this.trainId);
            Train backTrain = (Train)CreateClient.RAILWAYS.trains.get(this.backTrainId);
            if (train != null && backTrain != null) {
                train.carriages.addAll(backTrain.carriages);
                backTrain.carriages.clear();
                train.carriageSpacing.add(this.middleSpacing);
                train.carriageSpacing.addAll(backTrain.carriageSpacing);
                backTrain.carriageSpacing.clear();
                double[] newStress = new double[((AccessorTrain)train).snr_getStress().length + ((AccessorTrain)backTrain).snr_getStress().length + 1];
                System.arraycopy(((AccessorTrain)train).snr_getStress(), 0, newStress, 0, ((AccessorTrain)train).snr_getStress().length);
                newStress[((AccessorTrain)train).snr_getStress().length] = 0.0;
                System.arraycopy(((AccessorTrain)backTrain).snr_getStress(), 0, newStress, ((AccessorTrain)train).snr_getStress().length + 1, ((AccessorTrain)backTrain).snr_getStress().length);
                ((AccessorTrain)train).snr_setStress(newStress);
                train.doubleEnded = this.doubleEnded;
                train.carriages.forEach(c -> c.setTrain(train));
                CreateClient.RAILWAYS.trains.remove(this.backTrainId);
            }
        }
    }

    private /* synthetic */ Runnable lambda$handle$1(Supplier context) {
        return () -> this.lambda$handle$0((Supplier)context);
    }

    private /* synthetic */ void lambda$handle$0(Supplier context) {
        this.__handle(context);
    }
}

