/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.util.packet;

import com.railwayteam.railways.mixin.AccessorTrain;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.logistics.trains.entity.Train;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class ChopTrainEndPacket
extends SimplePacketBase {
    final UUID trainId;
    final int numberOfCarriages;
    final boolean doubleEnded;

    public ChopTrainEndPacket(Train train, int numberOfCarriages, boolean doubleEnded) {
        this.trainId = train.id;
        this.numberOfCarriages = numberOfCarriages;
        this.doubleEnded = doubleEnded;
    }

    public ChopTrainEndPacket(FriendlyByteBuf buf) {
        this.trainId = buf.m_130259_();
        this.numberOfCarriages = buf.readInt();
        this.doubleEnded = buf.readBoolean();
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.trainId);
        buffer.writeInt(this.numberOfCarriages);
        buffer.writeBoolean(this.doubleEnded);
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> this.lambda$handle$1((Supplier)context)));
        context.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void __handle(Supplier<NetworkEvent.Context> supplier) {
        Train train;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null && (train = (Train)CreateClient.RAILWAYS.trains.get(this.trainId)) != null) {
            for (int i = 0; i < this.numberOfCarriages; ++i) {
                train.carriages.remove(train.carriages.size() - 1);
                train.carriageSpacing.remove(train.carriageSpacing.size() - 1);
            }
            double[] originalStress = ((AccessorTrain)train).snr_getStress();
            double[] newStress = new double[originalStress.length - this.numberOfCarriages];
            System.arraycopy(originalStress, 0, newStress, 0, newStress.length);
            ((AccessorTrain)train).snr_setStress(newStress);
            train.doubleEnded = this.doubleEnded;
        }
    }

    private /* synthetic */ Runnable lambda$handle$1(Supplier context) {
        return () -> this.lambda$handle$0((Supplier)context);
    }

    private /* synthetic */ void lambda$handle$0(Supplier context) {
        this.__handle(context);
    }
}

