/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.util.packet;

import com.railwayteam.railways.compat.journeymap.DummyRailwayMarkerHandler;
import com.railwayteam.railways.compat.journeymap.TrainMarkerData;
import com.simibubi.create.content.logistics.trains.entity.Train;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class TrainMarkerDataUpdatePacket
extends SimplePacketBase {
    private static final UUID NULL_ID = new UUID(0L, 0L);
    final UUID id;
    final TrainMarkerData data;

    public TrainMarkerDataUpdatePacket(Train train) {
        this.id = train.id;
        this.data = TrainMarkerData.make(train);
    }

    private static Optional<String> optionalString(String string) {
        return string == null || string.isEmpty() ? Optional.empty() : Optional.of(string);
    }

    public TrainMarkerDataUpdatePacket(FriendlyByteBuf buf) {
        this.id = buf.m_130259_();
        this.data = new TrainMarkerData(buf.m_130277_(), buf.readInt(), buf.m_130259_(), buf.m_130277_(), (ResourceKey<Level>)buf.m_236801_(Registry.f_122819_), buf.m_130135_(), buf.readBoolean());
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.id);
        buffer.m_130070_(this.data.name());
        buffer.writeInt(this.data.carriageCount());
        buffer.m_130077_(Optional.ofNullable(this.data.owner()).orElse(NULL_ID));
        buffer.m_130070_(this.data.destination());
        buffer.m_236858_(this.data.dimension());
        buffer.m_130064_(this.data.pos());
        buffer.writeBoolean(this.data.incomplete());
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> this.lambda$handle$1((Supplier)context)));
        context.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void __handle(Supplier<NetworkEvent.Context> supplier) {
        if (!this.data.incomplete()) {
            DummyRailwayMarkerHandler.getInstance().registerData(this.id, this.data);
        }
    }

    private /* synthetic */ Runnable lambda$handle$1(Supplier context) {
        return () -> this.lambda$handle$0((Supplier)context);
    }

    private /* synthetic */ void lambda$handle$0(Supplier context) {
        this.__handle(context);
    }
}

