/*
 * Decompiled with CFR 0.152.
 */
package com.jtorleonstudios.libraryferret.worldgen.structures;

import com.jtorleonstudios.libraryferret.LibraryFerret;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Function7;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.CheckerboardColumnBiomeSource;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import org.jetbrains.annotations.NotNull;

public abstract class AwesomeStructure
extends Structure {
    private final Holder<StructureTemplatePool> startPool;
    private final Optional<ResourceLocation> startJigsawName;
    private final int size;
    private final HeightProvider startHeight;
    private final Optional<Heightmap.Types> projectStartToHeightmap;
    private final int maxDistanceFromCenter;

    public AwesomeStructure(Structure.StructureSettings config, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int size, HeightProvider startHeight, Optional<Heightmap.Types> projectStartToHeightmap, int maxDistanceFromCenter) {
        super(config);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.size = size;
        this.startHeight = startHeight;
        this.projectStartToHeightmap = projectStartToHeightmap;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
    }

    public static <T extends AwesomeStructure> Codec<T> getDefaultCodec(int size, int maxDistanceFromCenter, Function<String, Boolean> bindEnabledFromConfiguration, Function7<Structure.StructureSettings, Holder<StructureTemplatePool>, Optional<ResourceLocation>, Integer, HeightProvider, Optional<Heightmap.Types>, Integer, T> structureCreator) {
        return RecordCodecBuilder.mapCodec(i -> i.group((App)AwesomeStructure.m_226567_((RecordCodecBuilder.Instance)i), (App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(AwesomeStructure::startPool), (App)ResourceLocation.f_135803_.optionalFieldOf("start_jigsaw_name").forGetter(AwesomeStructure::startJigsawName), (App)Codec.intRange((int)0, (int)(size + 1)).fieldOf("size").forGetter(AwesomeStructure::size), (App)HeightProvider.f_161970_.fieldOf("start_height").forGetter(AwesomeStructure::startHeight), (App)Heightmap.Types.f_64274_.optionalFieldOf("project_start_to_heightmap").forGetter(AwesomeStructure::projectStartToHeightmap), (App)Codec.intRange((int)1, (int)maxDistanceFromCenter).fieldOf("max_distance_from_center").forGetter(AwesomeStructure::maxDistanceFromCenter)).apply((Applicative)i, (_config, _startPool, _startJigsawName, _size, _startHeight, _projectStartToHeightmap, _maxDistanceFromCenter) -> (AwesomeStructure)((Object)((Object)((Object)structureCreator.apply((Object)new Structure.StructureSettings((Boolean)bindEnabledFromConfiguration.apply(((StructureTemplatePool)_startPool.m_203334_()).m_210587_().toString()) != false ? _config.f_226689_() : AwesomeStructure.onDisabledStructure((Holder<StructureTemplatePool>)_startPool), _config.f_226690_(), _config.f_226691_(), _config.f_226692_()), _startPool, _startJigsawName, _size, _startHeight, _projectStartToHeightmap, _maxDistanceFromCenter)))))).codec();
    }

    @NotNull
    public Optional<Structure.GenerationStub> m_214086_(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Structure.GenerationContext ctx) {
        if (!this.canGenerate(ctx)) {
            return Optional.empty();
        }
        return JigsawPlacement.m_227238_((Structure.GenerationContext)ctx, this.startPool, this.startJigsawName, (int)this.size, (BlockPos)this.getInitialStartPosition(ctx), (boolean)false, this.projectStartToHeightmap, (int)this.maxDistanceFromCenter);
    }

    protected BlockPos getInitialStartPosition(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Structure.GenerationContext ctx) {
        return ctx.f_226628_().m_151394_(0);
    }

    protected abstract boolean canGenerate(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Structure.GenerationContext var1);

    private static HolderSet<Biome> onDisabledStructure(Holder<StructureTemplatePool> _startPool) {
        LibraryFerret.LOGGER.info("structure disabled: " + ((StructureTemplatePool)_startPool.m_203334_()).m_210587_());
        return HolderSet.m_205809_((Holder[])new Holder[0]);
    }

    public static boolean isValidStructureBiome(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Structure.GenerationContext ctx, int biomeRange) {
        if (!(ctx.f_226623_() instanceof CheckerboardColumnBiomeSource)) {
            ChunkPos chunkPos = ctx.f_226628_();
            for (int curChunkX = chunkPos.f_45578_ - biomeRange; curChunkX <= chunkPos.f_45578_ + biomeRange; ++curChunkX) {
                for (int curChunkZ = chunkPos.f_45579_ - biomeRange; curChunkZ <= chunkPos.f_45579_ + biomeRange; ++curChunkZ) {
                    Holder biome = ctx.f_226623_().m_203407_(curChunkX << 2, 16, curChunkZ << 2, ctx.f_226624_().m_224579_());
                    if (ctx.f_226630_().test(biome)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean isEmptyFluidState(Structure.GenerationContext ctx, @NotNull BlockPos position, Heightmap.Types projectStartToHeightmap) {
        return ctx.f_226622_().m_214184_(position.m_123341_(), position.m_123343_(), ctx.f_226629_(), ctx.f_226624_()).m_183556_(ctx.f_226622_().m_223235_(position.m_123341_(), position.m_123343_(), projectStartToHeightmap, ctx.f_226629_(), ctx.f_226624_())).m_60819_().m_76178_();
    }

    public final Holder<StructureTemplatePool> startPool() {
        return this.startPool;
    }

    public final Optional<ResourceLocation> startJigsawName() {
        return this.startJigsawName;
    }

    public final int size() {
        return this.size;
    }

    public final HeightProvider startHeight() {
        return this.startHeight;
    }

    public final Optional<Heightmap.Types> projectStartToHeightmap() {
        return this.projectStartToHeightmap;
    }

    public final int maxDistanceFromCenter() {
        return this.maxDistanceFromCenter;
    }
}

