/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg;

import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import potionstudios.byg.BYG;
import potionstudios.byg.BYGForgeEventsHandler;
import potionstudios.byg.client.BYGClient;
import potionstudios.byg.client.BYGForgeClient;
import potionstudios.byg.client.textures.renders.BYGRenderTypes;
import potionstudios.byg.common.BYGFuels;
import potionstudios.byg.common.BYGStrippables;
import potionstudios.byg.common.item.BYGCreativeTab;
import potionstudios.byg.common.item.BYGItems;
import potionstudios.byg.common.world.biome.end.BYGEndBiomeSource;
import potionstudios.byg.common.world.biome.nether.BYGNetherBiomeSource;
import potionstudios.byg.common.world.biome.overworld.OverworldRegion;
import potionstudios.byg.common.world.surfacerules.SurfaceRulesConfig;
import potionstudios.byg.config.SettingsConfig;
import potionstudios.byg.config.json.OverworldBiomeConfig;
import potionstudios.byg.core.BYGRegistry;
import potionstudios.byg.mixin.access.AxeItemAccess;
import potionstudios.byg.network.ForgeNetworkHandler;
import potionstudios.byg.util.jankson.JanksonUtil;
import potionstudios.byg.world.biome.BYGForgeEndBiomeSource;
import potionstudios.byg.world.biome.BYGForgeNetherBiomeSource;
import potionstudios.byg.world.biome.BYGTerraBlenderRegion;
import terrablender.api.Region;
import terrablender.api.Regions;
import terrablender.api.SurfaceRuleManager;

@Mod(value="byg")
public class BYGForge {
    public BYGForge() {
        BYG.INITIALIZED = true;
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        BYGCreativeTab.init(new CreativeModeTab("byg.byg"){

            public ItemStack m_6976_() {
                return new ItemStack((ItemLike)BYGItems.BYG_LOGO.get());
            }

            public boolean hasSearchBar() {
                return true;
            }

            public boolean m_40791_() {
                return true;
            }

            public ResourceLocation getBackgroundImage() {
                return new ResourceLocation("minecraft", "textures/gui/container/creative_inventory/tab_item_search.png");
            }
        });
        BYGRegistry.loadClasses();
        modBus.addListener(this::commonLoad);
        modBus.addListener(this::loadFinish);
        modBus.addListener(this::clientLoad);
    }

    private void commonLoad(FMLCommonSetupEvent event) {
        BYG.commonLoad();
        event.enqueueWork(BYG::threadSafeCommonLoad);
        event.enqueueWork(ForgeNetworkHandler::init);
        event.enqueueWork(this::registerTerraBlender);
        Registry.m_122965_((Registry)Registry.f_122889_, (ResourceLocation)BYGEndBiomeSource.LOCATION, BYGForgeEndBiomeSource.CODEC);
        Registry.m_122965_((Registry)Registry.f_122889_, (ResourceLocation)BYGNetherBiomeSource.LOCATION, BYGForgeNetherBiomeSource.CODEC);
        BYGFuels.loadFuels((arg_0, arg_1) -> BYGForgeEventsHandler.BURN_TIMES.put(arg_0, arg_1));
        IdentityHashMap<Block, Block> strippables = new IdentityHashMap<Block, Block>(AxeItemAccess.byg_getStrippables());
        BYGStrippables.strippableLogsBYG(strippables::put);
        AxeItemAccess.byg_setStripables(strippables);
    }

    private void registerTerraBlender() {
        try {
            OverworldBiomeConfig config = OverworldBiomeConfig.getConfig();
            if (config.generateOverworld() && SettingsConfig.getConfig().useBYGWorldGen()) {
                Map<ResourceKey<LevelStem>, SurfaceRules.RuleSource> surfaceRulesConfig = SurfaceRulesConfig.getConfig();
                if (!surfaceRulesConfig.containsKey(LevelStem.f_63971_) || surfaceRulesConfig.get(LevelStem.f_63971_) == null) {
                    throw new IllegalStateException(String.format("Surface rules for \"%s\" are required to load. Fix the config file found at: \"%s\"", LevelStem.f_63971_.m_135782_().toString(), SurfaceRulesConfig.CONFIG_PATHS.get().get(LevelStem.f_63971_)));
                }
                SurfaceRuleManager.addSurfaceRules((SurfaceRuleManager.RuleCategory)SurfaceRuleManager.RuleCategory.OVERWORLD, (String)"byg", (SurfaceRules.RuleSource)surfaceRulesConfig.get(LevelStem.f_63971_));
                config.values().forEach(biomeProviderData -> Regions.register((Region)new BYGTerraBlenderRegion((OverworldRegion)biomeProviderData.value())));
            } else {
                BYG.LOGGER.info("BYG overworld biomes disabled.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    private void loadFinish(FMLLoadCompleteEvent event) {
        event.enqueueWork(BYG::threadSafeLoadFinish);
        if (JanksonUtil.thrown != null) {
            throw JanksonUtil.thrown;
        }
    }

    private void clientLoad(FMLClientSetupEvent event) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            BYGClient.load();
            BYGRenderTypes.renderTypes(blockRenderTypeMap -> blockRenderTypeMap.forEach(ItemBlockRenderTypes::setRenderLayer));
            BYGForgeClient.client();
            event.enqueueWork(BYGClient::threadSafeLoad);
        });
    }
}

