/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg;

import com.mojang.brigadier.CommandDispatcher;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import potionstudios.byg.BYG;
import potionstudios.byg.common.entity.npc.BYGVillagerTrades;
import potionstudios.byg.common.entity.npc.TradesConfig;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class BYGForgeEventsHandler {
    static final Object2IntMap<Item> BURN_TIMES = new Object2IntOpenHashMap();

    @SubscribeEvent
    public static void appendBYGVillagerTrades(VillagerTradesEvent event) {
        Map<VillagerProfession, Int2ObjectMap<VillagerTrades.ItemListing[]>> tradesByProfession;
        TradesConfig tradesConfig = TradesConfig.getConfig();
        if (tradesConfig.enabled() && (tradesByProfession = tradesConfig.tradesByProfession()).containsKey(event.getType())) {
            Int2ObjectMap<VillagerTrades.ItemListing[]> int2ObjectMap = tradesByProfession.get(event.getType());
            BYGVillagerTrades.appendTradesList(int2ObjectMap, (Int2ObjectMap<List<VillagerTrades.ItemListing>>)event.getTrades());
        }
    }

    @SubscribeEvent
    public static void appendBYGWanderingTraderTrades(WandererTradesEvent event) {
        TradesConfig tradesConfig = TradesConfig.getConfig();
        Int2ObjectMap<VillagerTrades.ItemListing[]> wanderingTraderTrades = tradesConfig.wanderingTraderTrades();
        if (tradesConfig.enabled()) {
            if (wanderingTraderTrades.containsKey(1)) {
                event.getGenericTrades().addAll(Arrays.asList((VillagerTrades.ItemListing[])wanderingTraderTrades.get(1)));
            }
            if (wanderingTraderTrades.containsKey(2)) {
                event.getRareTrades().addAll(Arrays.asList((VillagerTrades.ItemListing[])wanderingTraderTrades.get(2)));
            }
        } else {
            BYG.LOGGER.warn("Ignoring villager/wandering trader trades added by BYG.");
        }
    }

    @SubscribeEvent
    public static void onBurnTime(FurnaceFuelBurnTimeEvent event) {
        Item item = event.getItemStack().m_41720_();
        if (BURN_TIMES.containsKey((Object)item)) {
            event.setBurnTime(BURN_TIMES.getInt((Object)item));
        }
    }

    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        BYG.attachCommands((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getCommandSelection());
    }
}

