/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.client.config.filebrowser;

import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import potionstudios.byg.client.config.filebrowser.FileEntry;
import potionstudios.byg.client.config.filebrowser.KeyCommentToolTipEntry;

public class FileBrowserScreen
extends Screen {
    public static final Function<Path, List<Path>> CONFIG_FILES = configDir -> {
        try {
            return Files.walk(configDir, new FileVisitOption[0]).filter(path -> !path.toFile().isDirectory()).sorted(Comparator.comparing(Path::toString)).collect(Collectors.toList());
        }
        catch (IOException e) {
            e.printStackTrace();
            return new ArrayList();
        }
    };
    public static Predicate<Path> RELOADS_ON_SAVE = path -> false;
    public static Consumer<Path> ON_RELOAD = path -> {};
    private final Screen parent;
    private final Path configDir;
    private ConfigMap<?> configFiles;
    private String searchCache = "";
    private EditBox searchBox;
    private final Set<KeyCommentToolTipEntry<?>> hidden = new ObjectOpenHashSet();

    public FileBrowserScreen(Screen parent, Path configDir, Component component) {
        super(component);
        this.parent = parent;
        this.configDir = configDir;
    }

    public void m_86600_() {
        this.configFiles.m_6702_().forEach(KeyCommentToolTipEntry::tick);
        this.searchBox.m_94120_();
    }

    protected void m_7856_() {
        this.configFiles = new ConfigMap(this, this.f_96543_, this.f_96544_, 40, this.f_96544_ - 37, 25);
        int searchWidth = 250;
        this.searchBox = new EditBox(Minecraft.m_91087_().f_91062_, this.f_96543_ / 2 - searchWidth / 2, 18, searchWidth, 20, (Component)Component.m_237113_((String)""));
        this.searchBox.m_94151_(this::searchResponder);
        int maxCommentWidth = this.configFiles.m_5759_();
        for (Path path : CONFIG_FILES.apply(this.configDir)) {
            String relativizedPath = this.configDir.getParent().relativize(path).toString();
            FileEntry fileEntry = new FileEntry(RELOADS_ON_SAVE.test(path), this, relativizedPath, path, ON_RELOAD);
            maxCommentWidth = Math.max(maxCommentWidth, fileEntry.getRowLength());
            this.configFiles.addEntry(fileEntry);
        }
        this.configFiles.rowWidth = maxCommentWidth;
        int buttonWidth = 150;
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ - this.f_96543_ / 2 - buttonWidth / 2, this.f_96544_ - 30, buttonWidth, 20, CommonComponents.f_130655_, p_95761_ -> this.f_96541_.m_91152_(this.parent)));
        this.m_142416_((GuiEventListener)this.searchBox);
        this.m_7787_((GuiEventListener)this.configFiles);
        super.m_7856_();
    }

    private void searchResponder(String s) {
        if (!this.searchCache.equals(s)) {
            List children = this.configFiles.m_6702_();
            ArrayList keyCommentToolTipEntries = new ArrayList(children);
            for (KeyCommentToolTipEntry child : keyCommentToolTipEntries) {
                if (child.key.toLowerCase(Locale.ROOT).contains(s.toLowerCase(Locale.ROOT))) continue;
                children.remove((Object)child);
                child.renderToolTip = false;
                this.hidden.add(child);
            }
            for (KeyCommentToolTipEntry entry : new ObjectOpenHashSet(this.hidden)) {
                if (!entry.key.toLowerCase(Locale.ROOT).contains(s.toLowerCase(Locale.ROOT))) continue;
                children.add(entry);
                this.hidden.remove((Object)entry);
            }
            this.searchCache = s;
            this.configFiles.m_93410_(0.0);
        }
    }

    public void m_6305_(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        this.m_7333_(pPoseStack);
        this.configFiles.m_6305_(pPoseStack, pMouseX, pMouseY, pPartialTick);
        FileBrowserScreen.m_93215_((PoseStack)pPoseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)5, (int)0xFFFFFF);
        super.m_6305_(pPoseStack, pMouseX, pMouseY, pPartialTick);
        for (KeyCommentToolTipEntry child : this.configFiles.m_6702_()) {
            if (!child.renderToolTip) continue;
            this.m_169388_(pPoseStack, child.toolTip, Optional.empty(), pMouseX, pMouseY);
        }
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parent);
    }

    public static class ConfigMap<T>
    extends ContainerObjectSelectionList<KeyCommentToolTipEntry<T>> {
        private final Screen screen;
        private int rowWidth;

        public ConfigMap(Screen screen, int width, int height, int y0, int y1, int itemHeight) {
            super(Minecraft.m_91087_(), width, height, y0, y1, itemHeight);
            this.screen = screen;
            this.rowWidth = super.m_5759_();
            this.m_93488_(false);
        }

        protected boolean m_5694_() {
            return this.screen.m_7222_() == this;
        }

        public int addEntry(KeyCommentToolTipEntry $$0) {
            return super.m_7085_((AbstractSelectionList.Entry)$$0);
        }

        public int m_5759_() {
            return this.rowWidth;
        }

        protected int m_5756_() {
            return this.f_93388_ - 10;
        }
    }
}

