/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.client.config.filebrowser;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FastColor;
import potionstudios.byg.client.config.configeditor.ConfigEditScreen;
import potionstudios.byg.client.config.filebrowser.KeyCommentToolTipEntry;
import potionstudios.byg.client.config.serializers.ConfigEntriesSerializer;
import potionstudios.byg.mixin.access.client.ScreenAccess;
import potionstudios.byg.util.BYGUtil;

public class FileEntry<T>
extends KeyCommentToolTipEntry<T> {
    private static final MutableComponent RELOADS_ON_SAVE = Component.m_237113_((String)"Reloads on save");
    private static final MutableComponent DOES_NOT_RELOAD_ON_SAVE = Component.m_237113_((String)"Does not Reload on save");
    private static final MutableComponent RELOAD = Component.m_237113_((String)"Reload");
    private final Button openFileButton;
    private final Button editButton;
    private final Button reloadButton;
    private final boolean isReloadable;
    private boolean overrideDefaultToolTip;
    private int lastReload = -1;

    public FileEntry(boolean isReloadable, Screen parent, final String relativizedPath, Path absolutePath, Consumer<Path> onReload) {
        super(parent, relativizedPath, relativizedPath);
        this.isReloadable = isReloadable;
        this.openFileButton = new Button(0, 0, 50, 20, (Component)Component.m_237115_((String)"Open"), button -> ((ScreenAccess)parent).byg_invokeOpenLink(absolutePath.toUri())){

            protected MutableComponent m_5646_() {
                return Component.m_237110_((String)"narrator.controls.reset", (Object[])new Object[]{relativizedPath});
            }
        };
        ConfigEntriesSerializer<?> serializer = ConfigEntriesSerializer.fromFile(absolutePath);
        this.editButton = new Button(0, 0, 50, 20, (Component)Component.m_237115_((String)"Edit"), button -> {
            if (serializer != null) {
                Minecraft.m_91087_().m_91152_((Screen)new ConfigEditScreen(this.parent, serializer, relativizedPath, absolutePath, isReloadable));
            }
        }){

            protected MutableComponent m_5646_() {
                return Component.m_237110_((String)"narrator.controls.reset", (Object[])new Object[]{relativizedPath});
            }
        };
        MutableComponent reload = Component.m_237115_((String)"Reload");
        this.reloadButton = new Button(0, 0, 50, 20, (Component)reload, button -> {
            if (isReloadable) {
                onReload.accept(absolutePath);
            }
            this.lastReload = 60;
            button.f_93623_ = false;
        }){

            protected MutableComponent m_5646_() {
                return Component.m_237110_((String)"narrator.controls.reset", (Object[])new Object[]{relativizedPath});
            }
        };
        this.reloadButton.f_93623_ = isReloadable;
        if (serializer == null) {
            this.editButton.f_93623_ = false;
        }
    }

    @Override
    public void m_6311_(PoseStack pPoseStack, int pIndex, int pTop, int pLeft, int pWidth, int pHeight, int pMouseX, int pMouseY, boolean pIsMouseOver, float pPartialTick) {
        super.m_6311_(pPoseStack, pIndex, pTop, pLeft, pWidth, pHeight, pMouseX, pMouseY, pIsMouseOver, pPartialTick);
        this.editButton.f_93620_ = (int)(this.keyScreenPosition.x + (float)this.maxKeyWidth + 20.0f);
        this.editButton.f_93621_ = pTop + pHeight / 2 - 9;
        this.editButton.m_6305_(pPoseStack, pMouseX, pMouseY, pPartialTick);
        this.openFileButton.f_93620_ = this.editButton.f_93620_ + this.editButton.m_5711_() + 10;
        this.openFileButton.f_93621_ = this.editButton.f_93621_;
        this.openFileButton.m_6305_(pPoseStack, pMouseX, pMouseY, pPartialTick);
        this.reloadButton.f_93620_ = this.openFileButton.f_93620_ + this.openFileButton.m_5711_() + 10;
        this.reloadButton.f_93621_ = this.openFileButton.f_93621_;
        this.reloadButton.m_6305_(pPoseStack, pMouseX, pMouseY, pPartialTick);
        int minX = pLeft - 15;
        int maxX = pLeft - 5;
        int minY = pTop;
        int maxY = pTop + pHeight;
        this.overrideDefaultToolTip = BYGUtil.isInside(minX, minY, maxX, maxY, pMouseX, pMouseY);
        if (this.overrideDefaultToolTip) {
            if (this.toolTip.get(0) != RELOADS_ON_SAVE) {
                this.toolTip.clear();
                this.toolTip.add(this.isReloadable ? RELOADS_ON_SAVE : DOES_NOT_RELOAD_ON_SAVE);
            }
            this.renderToolTip = true;
        } else {
            this.renderToolTip = pIsMouseOver;
        }
        GuiComponent.m_93172_((PoseStack)pPoseStack, (int)minX, (int)minY, (int)maxX, (int)maxY, (int)(this.isReloadable ? FastColor.ARGB32.m_13660_((int)255, (int)0, (int)255, (int)0) : FastColor.ARGB32.m_13660_((int)255, (int)255, (int)0, (int)0)));
    }

    @Override
    public boolean toolTipCacheReload(int pWidth, boolean pIsMouseOver) {
        if (this.overrideDefaultToolTip) {
            return false;
        }
        return super.toolTipCacheReload(pWidth, pIsMouseOver);
    }

    public List<? extends NarratableEntry> m_142437_() {
        return ImmutableList.of((Object)this.openFileButton, (Object)this.editButton, (Object)this.reloadButton);
    }

    public List<? extends GuiEventListener> m_6702_() {
        return ImmutableList.of((Object)this.openFileButton, (Object)this.editButton, (Object)this.reloadButton);
    }

    @Override
    public int getRowLength() {
        return super.getRowLength() + 20 + this.openFileButton.m_5711_() + 10 + this.openFileButton.m_5711_() + 10 + this.reloadButton.m_5711_();
    }

    public boolean m_6375_(double $$0, double $$1, int $$2) {
        return super.m_6375_($$0, $$1, $$2);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.lastReload > 0) {
            --this.lastReload;
            this.reloadButton.m_93666_((Component)Component.m_237113_((String)Integer.toString(this.lastReload / 20 + 1)));
        } else if (this.lastReload == 0) {
            this.reloadButton.m_93666_((Component)RELOAD);
            this.reloadButton.f_93623_ = true;
        }
    }
}

