/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.client.gui.biomepedia.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.PageButton;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import potionstudios.byg.BYG;
import potionstudios.byg.client.gui.biomepedia.screen.AbstractBiomepediaScreen;
import potionstudios.byg.client.gui.biomepedia.screen.BiomeAboutScreen2;
import potionstudios.byg.client.gui.biomepedia.widget.BiomeWidget;
import potionstudios.byg.client.gui.biomepedia.widget.ScrollableText;
import potionstudios.byg.common.world.LevelBiomeTracker;

public class BiomeAboutScreen
extends AbstractBiomepediaScreen {
    protected int toolTipMaxWidth;
    protected int textStartHeight;
    protected final Component description;
    @Nullable
    protected final ResourceLocation previewImageLocation;
    private ResourceKey<Biome> biomeKey;
    private final Screen parent;
    private final Component dimensionsText;
    private final Component climateText;

    protected BiomeAboutScreen(ResourceKey<Biome> biomeKey, Screen parent) {
        super((Component)Component.m_237115_((String)("biome." + biomeKey.m_135782_().m_135827_() + "." + biomeKey.m_135782_().m_135815_())));
        this.biomeKey = biomeKey;
        this.parent = parent;
        String translationKey = String.format("biomepedia.biome.%s.%s.desc", biomeKey.m_135782_().m_135827_(), biomeKey.m_135782_().m_135815_());
        boolean useTranslation = !I18n.m_118938_((String)translationKey, (Object[])new Object[0]).equals(translationKey);
        this.description = Component.m_237115_((String)(useTranslation ? translationKey : "biomepedia.desc.block.byg.none"));
        ResourceLocation resourceLocation = new ResourceLocation(biomeKey.m_135782_().m_135827_(), "/textures/biome_previews/" + biomeKey.m_135782_().m_135815_() + ".png");
        Object object = this.previewImageLocation = Minecraft.m_91087_().m_91098_().m_213713_(resourceLocation).isPresent() ? resourceLocation : null;
        if (this.previewImageLocation == null) {
            BYG.LOGGER.warn("No image preview available for: " + resourceLocation.toString());
        }
        MutableComponent dimensionsText = Component.m_237115_((String)"biomepedia.biomeabout.dimensions").m_130940_(ChatFormatting.UNDERLINE).m_130940_(ChatFormatting.BOLD);
        Map<ResourceKey<Biome>, Collection<ResourceKey<Level>>> biomeDimensions = LevelBiomeTracker.client_instance.biomeDimensions();
        if (biomeDimensions.containsKey(biomeKey)) {
            Collection<ResourceKey<Level>> dimensions = biomeDimensions.get(biomeKey);
            for (ResourceKey<Level> levelResourceKey : dimensions) {
                String dimensionTranslationKey = "dimension." + levelResourceKey.m_135782_().m_135827_() + "." + levelResourceKey.m_135782_().m_135815_();
                MutableComponent dimensionComponent = Component.m_237115_((String)dimensionTranslationKey);
                dimensionsText.m_130946_("\n").m_7220_((Component)(!I18n.m_118938_((String)translationKey, (Object[])new Object[0]).equals(dimensionTranslationKey) ? dimensionComponent : Component.m_237113_((String)levelResourceKey.m_135782_().toString())));
            }
        } else {
            dimensionsText.m_130946_("\n").m_7220_((Component)Component.m_237115_((String)"biomepedia.biomeabout.dimensions.none"));
        }
        this.dimensionsText = dimensionsText;
        MutableComponent climateText = Component.m_237115_((String)"biomepedia.biomeabout.climate").m_130940_(ChatFormatting.UNDERLINE).m_130940_(ChatFormatting.BOLD);
        Registry biomeRegistry = Minecraft.m_91087_().f_91073_.m_5962_().m_175515_(Registry.f_122885_);
        Biome biome = (Biome)biomeRegistry.m_6246_(biomeKey);
        climateText.m_130946_("\n").m_7220_((Component)Component.m_237110_((String)"biomepedia.biomeabout.climate.basetemperature", (Object[])new Object[]{Float.valueOf(biome.m_47554_())}));
        climateText.m_130946_("\n").m_7220_((Component)Component.m_237110_((String)"biomepedia.biomeabout.climate.downfall", (Object[])new Object[]{Float.valueOf(biome.m_47548_())}));
        climateText.m_130946_("\n").m_7220_((Component)Component.m_237110_((String)"biomepedia.biomeabout.climate.precipitation", (Object[])new Object[]{Component.m_237115_((String)("biomepedia.biomeabout.climate.precipitation." + biome.m_47530_().m_7912_()))}));
        this.climateText = climateText;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.toolTipMaxWidth = 122;
        this.textStartHeight = this.bottomPos + 104 - 5;
        this.m_142416_((GuiEventListener)new PageButton(this.pageButtonForwardX, this.pageButtonY, true, button -> this.f_96541_.m_91152_((Screen)new BiomeAboutScreen2(this.biomeKey, this.parent)), true));
        int dimensionTextTop = this.bottomPos + 15;
        int size = 80;
        int dimensionTextBottom = dimensionTextTop + size;
        ScrollableText dimensions = new ScrollableText(this.dimensionsText, this.toolTipMaxWidth, dimensionTextTop, dimensionTextTop, dimensionTextBottom);
        dimensions.m_93507_(this.startXRightPage);
        int distanceBetween = 10;
        int climateTextTop = dimensionTextBottom + distanceBetween;
        int climateTextBottom = climateTextTop + size;
        ScrollableText climateInfo = new ScrollableText(this.climateText, dimensions.m_5759_(), climateTextTop, climateTextTop, climateTextBottom);
        climateInfo.m_93507_(this.startXRightPage);
        ScrollableText description = new ScrollableText(this.description, this.toolTipMaxWidth, climateTextTop, climateTextTop, climateTextBottom);
        description.m_93507_(this.startXLeftPage);
        this.m_142416_((GuiEventListener)description);
        this.m_142416_((GuiEventListener)dimensions);
        this.m_142416_((GuiEventListener)climateInfo);
    }

    @Override
    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
        BiomeWidget.renderBiomePicture(poseStack, 0.09f, this.startXLeftPage + 3, this.bottomPos + 25, this.previewImageLocation);
        int leftPageCenter = this.leftPos + 72 + 4;
        int startX = leftPageCenter - Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)this.m_96636_()) / 2;
        Minecraft.m_91087_().f_91062_.m_92889_(poseStack, this.m_96636_(), (float)startX, (float)(this.bottomPos + 13), 0);
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parent);
    }
}

