/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.client.gui.biomepedia.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.level.biome.Biome;
import potionstudios.byg.BYG;
import potionstudios.byg.util.BYGUtil;

public class BiomeWidget
extends AbstractWidget {
    private final OnClick onClick;
    @Nullable
    private final ResourceLocation previewImageLocation;
    private final Component name;
    private final int borderColor;
    public static final int IMAGE_WIDTH = 1280;
    public static final int IMAGE_HEIGHT = 720;

    public BiomeWidget(ResourceKey<Biome> biome, int pX, int pY, int pWidth, int pHeight, OnClick onClick) {
        super(pX, pY, pWidth, pHeight, (Component)Component.m_237113_((String)""));
        this.onClick = onClick;
        ResourceLocation resourceLocation = new ResourceLocation(biome.m_135782_().m_135827_(), "/textures/biome_previews/" + biome.m_135782_().m_135815_() + ".png");
        Object object = this.previewImageLocation = Minecraft.m_91087_().m_91098_().m_213713_(resourceLocation).isPresent() ? resourceLocation : null;
        if (this.previewImageLocation == null) {
            BYG.LOGGER.warn("No image preview available for: " + resourceLocation.toString());
        }
        this.name = Component.m_237115_((String)("biome." + biome.m_135782_().m_135827_() + "." + biome.m_135782_().m_135815_()));
        this.borderColor = FastColor.ARGB32.m_13660_((int)255, (int)0, (int)0, (int)0);
        this.f_93624_ = false;
        this.f_93623_ = false;
    }

    public void m_142291_(NarrationElementOutput narrationElementOutput) {
    }

    public void m_5716_(double $$0, double $$1) {
        if (this.f_93623_) {
            this.onClick.click(this);
            super.m_5716_($$0, $$1);
        }
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        if (this.f_93624_) {
            if (this.previewImageLocation != null) {
                float scale = 0.09f;
                BiomeWidget.renderBiomePicture(poseStack, scale, this.f_93620_, this.f_93621_, this.previewImageLocation);
            }
            int textWidth = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)this.name) / 2;
            int textX = this.f_93620_ + this.f_93618_ / 2 - textWidth;
            int textY = this.f_93621_ + this.f_93619_ - 10;
            Minecraft.m_91087_().f_91062_.m_92889_(poseStack, this.name, (float)textX, (float)textY, FastColor.ARGB32.m_13660_((int)255, (int)0, (int)0, (int)0));
            if (BYGUtil.isInside(this.f_93620_, this.f_93621_, this.f_93620_ + this.f_93618_, this.f_93621_ + this.f_93619_, mouseX, mouseY)) {
                this.drawWidgetBorder(poseStack);
            }
        }
    }

    public static void renderBiomePicture(PoseStack poseStack, float scale, int x, int y, ResourceLocation location) {
        poseStack.m_85836_();
        poseStack.m_85841_(scale, scale, 1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)location);
        int scaledX = (int)((float)x / scale);
        int scaledY = (int)((float)y / scale);
        BiomeWidget.m_93133_((PoseStack)poseStack, (int)scaledX, (int)scaledY, (float)0.0f, (float)0.0f, (int)1280, (int)720, (int)1280, (int)720);
        poseStack.m_85849_();
    }

    private void drawWidgetBorder(PoseStack poseStack) {
        this.m_93222_(poseStack, this.f_93620_, this.f_93621_, this.f_93621_ + this.f_93619_, this.borderColor);
        this.m_93222_(poseStack, this.f_93620_ + this.f_93618_, this.f_93621_, this.f_93621_ + this.f_93619_, this.borderColor);
        this.m_93154_(poseStack, this.f_93620_, this.f_93620_ + this.f_93618_, this.f_93621_, this.borderColor);
        this.m_93154_(poseStack, this.f_93620_, this.f_93620_ + this.f_93618_, this.f_93621_ + this.f_93619_, this.borderColor);
    }

    public static interface OnClick {
        public void click(BiomeWidget var1);
    }
}

