/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.entity.manowar;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;

public class ManOWar
extends WaterAnimal {
    private static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.m_135353_(ManOWar.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public float xBodyRot;
    public float xBodyRotO;
    public float zBodyRot;
    public float zBodyRotO;
    public float tentacleMovement;
    public float oldTentacleMovement;
    public float tentacleAngle;
    public float oldTentacleAngle;
    private float speed;
    private float tentacleSpeed;
    private float rotateSpeed;
    private float tx;
    private float ty;
    private float tz;

    public ManOWar(EntityType<? extends ManOWar> entityType, Level level) {
        super(entityType, level);
        this.tentacleSpeed = 1.0f / (this.f_19796_.m_188501_() + 1.0f) * 0.2f;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, (double)1.2f).m_22268_(Attributes.f_22281_, 3.0);
    }

    public void m_6123_(Player player) {
        if (player instanceof ServerPlayer && player.m_6469_(DamageSource.m_19370_((LivingEntity)this), 1.0f)) {
            player.m_147207_(new MobEffectInstance(MobEffects.f_19614_, 60, 1), (Entity)this);
        }
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.EVENTS;
    }

    public void m_7023_(Vec3 vec3) {
        this.m_6478_(MoverType.SELF, this.m_20184_());
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 1.0, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new ManOWarRandomMovementGoal(this));
        this.f_21345_.m_25352_(45, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
    }

    public void m_7822_(byte b) {
        if (b == 19) {
            this.tentacleMovement = 0.0f;
        } else {
            super.m_7822_(b);
        }
    }

    public void setMovementVector(float f, float g, float h) {
        this.tx = f;
        this.ty = g;
        this.tz = h;
    }

    public boolean hasMovementVector() {
        return this.tx != 0.0f || this.ty != 0.0f || this.tz != 0.0f;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        this.setColor(ManOWar.getRandColor(this.f_19796_));
        return super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(COLOR, (Object)0);
        super.m_8097_();
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("Flag", this.getRawFlag());
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.setRawFlag(compoundTag.m_128451_("Flag"));
    }

    public void m_8107_() {
        if (!this.m_20069_() && this.f_19861_ && this.f_19863_) {
            this.m_20256_(this.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.05f), (double)0.4f, (double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.05f)));
            this.f_19861_ = false;
            this.f_19812_ = true;
            this.m_5496_(SoundEvents.f_12329_, this.m_6121_(), this.m_6100_());
        }
        super.m_8107_();
        this.xBodyRotO = this.xBodyRot;
        this.zBodyRotO = this.zBodyRot;
        this.oldTentacleMovement = this.tentacleMovement;
        this.oldTentacleAngle = this.tentacleAngle;
        this.tentacleMovement += this.tentacleSpeed;
        if ((double)this.tentacleMovement > Math.PI * 2) {
            if (this.f_19853_.f_46443_) {
                this.tentacleMovement = (float)Math.PI * 2;
            } else {
                this.tentacleMovement = (float)((double)this.tentacleMovement - Math.PI * 2);
                if (this.f_19796_.m_188503_(10) == 0) {
                    this.tentacleSpeed = 1.0f / (this.f_19796_.m_188501_() + 1.0f) * 0.2f;
                }
                this.f_19853_.m_7605_((Entity)this, (byte)19);
            }
        }
        if (this.m_20072_()) {
            if (this.tentacleMovement < (float)Math.PI) {
                float f = this.tentacleMovement / (float)Math.PI;
                this.tentacleAngle = Mth.m_14031_((float)(f * f * (float)Math.PI)) * (float)Math.PI * 0.25f;
                if ((double)f > 0.75) {
                    this.speed = 1.0f;
                    this.rotateSpeed = 1.0f;
                } else {
                    this.rotateSpeed *= 0.8f;
                }
            } else {
                this.tentacleAngle = 0.0f;
                this.speed *= 0.9f;
                this.rotateSpeed *= 0.99f;
            }
            if (!this.f_19853_.f_46443_) {
                this.m_20334_(this.tx * this.speed, this.ty * this.speed, this.tz * this.speed);
            }
            Vec3 vec3 = this.m_20184_();
            double d = vec3.m_165924_();
            this.f_20883_ += (-((float)Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_)) * 57.295776f - this.f_20883_) * 0.1f;
            this.m_146922_(this.f_20883_);
            this.zBodyRot = (float)((double)this.zBodyRot + Math.PI * (double)this.rotateSpeed * 1.5);
            this.xBodyRot += (-((float)Mth.m_14136_((double)d, (double)vec3.f_82480_)) * 57.295776f - this.xBodyRot) * 0.1f;
        } else {
            this.tentacleAngle = Mth.m_14154_((float)Mth.m_14031_((float)this.tentacleMovement)) * (float)Math.PI * 0.25f;
            if (!this.f_19853_.f_46443_) {
                double e = this.m_20184_().f_82480_;
                if (this.m_21023_(MobEffects.f_19620_)) {
                    e = 0.05 * (double)(this.m_21124_(MobEffects.f_19620_).m_19564_() + 1);
                } else if (!this.m_20068_()) {
                    e -= 0.08;
                }
                this.m_20334_(0.0, e * (double)0.98f, 0.0);
            }
            this.xBodyRot = (float)((double)this.xBodyRot + (double)(-90.0f - this.xBodyRot) * 0.02);
        }
    }

    public void setColor(@Nonnull Colors color) {
        this.setFlags(color);
    }

    public void setFlags(@Nonnull Colors color) {
        this.setRawFlag((color.ordinal() & 0x7F) << 16);
    }

    public int getRawFlag() {
        return (Integer)this.f_19804_.m_135370_(COLOR);
    }

    public void setRawFlag(int flag) {
        this.f_19804_.m_135381_(COLOR, (Object)flag);
    }

    public Colors getColor() {
        return Colors.byIndex(this.getRawFlag() >> 16 & 0x7F);
    }

    public static Colors getRandColor(RandomSource rand) {
        int i = rand.m_188503_(5);
        if (i <= 0) {
            return Colors.MAGENTA;
        }
        if (i <= 2) {
            return Colors.BLUE;
        }
        if (i <= 3) {
            return Colors.PURPLE;
        }
        return Colors.RAINBOW;
    }

    public static <T> T makeIndex(T[] array, int index) {
        return array[index >= array.length ? 0 : index];
    }

    private class ManOWarRandomMovementGoal
    extends Goal {
        private final ManOWar mano;

        public ManOWarRandomMovementGoal(ManOWar mano2) {
            this.mano = mano2;
        }

        public boolean m_8036_() {
            return true;
        }

        public void m_8037_() {
            int i = this.mano.m_21216_();
            if (i > 100) {
                this.mano.setMovementVector(0.0f, 0.0f, 0.0f);
            } else if (this.mano.m_217043_().m_188503_(50) == 0 || !this.mano.f_19798_ || !this.mano.hasMovementVector()) {
                float f = this.mano.m_217043_().m_188501_() * ((float)Math.PI * 2);
                float g = Mth.m_14089_((float)f) * 0.2f;
                float h = -0.1f + this.mano.m_217043_().m_188501_() * 0.2f;
                float j = Mth.m_14031_((float)f) * 0.2f;
                this.mano.setMovementVector(g, h, j);
            }
        }
    }

    public static enum Colors {
        BLUE,
        PURPLE,
        MAGENTA,
        RAINBOW;


        public static Colors byIndex(int index) {
            return ManOWar.makeIndex(Colors.values(), index);
        }
    }
}

