/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.biome;

import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.HashMap;
import java.util.HashSet;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import potionstudios.byg.BYG;
import potionstudios.byg.common.entity.npc.VillagerTradeRegistry;
import potionstudios.byg.common.world.biome.BYGBiomeTags;
import potionstudios.byg.common.world.biome.BYGNetherBiomes;
import potionstudios.byg.common.world.biome.BYGOverworldBiomes;
import potionstudios.byg.common.world.biome.end.BYGEndBiomes;
import potionstudios.byg.common.world.placement.BYGPlacementModifierType;
import potionstudios.byg.common.world.structure.BYGStructurePieceTypes;
import potionstudios.byg.common.world.structure.BYGStructureSets;
import potionstudios.byg.common.world.surfacerules.rulesource.BYGRuleSources;
import potionstudios.byg.reg.RegistrationProvider;
import potionstudios.byg.reg.RegistryObject;
import potionstudios.byg.util.blendingfunction.BlendingFunction;

public class BYGBiomes {
    public static final RegistrationProvider<Biome> PROVIDER = RegistrationProvider.get(BuiltinRegistries.f_123865_, "byg");
    public static final Multimap<TagKey<Biome>, RegistryObject<Biome>> BIOMES_BY_TAG = Multimaps.newSetMultimap(new HashMap(), HashSet::new);
    public static final ResourceKey<Biome> ALLIUM_FIELDS = BYGBiomes.createBiome("allium_fields", BYGOverworldBiomes::alliumFields, BYGBiomeTags.IS_OVERWORLD, BYGBiomeTags.IS_PLAIN);
    public static final ResourceKey<Biome> AMARANTH_FIELDS = BYGBiomes.createBiome("amaranth_fields", BYGOverworldBiomes::amaranthFields, BYGBiomeTags.IS_OVERWORLD, BYGBiomeTags.IS_PLAIN);
    public static final ResourceKey<Biome> ARAUCARIA_SAVANNA = BYGBiomes.createBiome("araucaria_savanna", () -> BYGOverworldBiomes.araucariaSavanna(false), BYGBiomeTags.IS_OVERWORLD, BYGBiomeTags.IS_SAVANNA);
    public static final ResourceKey<Biome> ASPEN_FOREST = BYGBiomes.createBiome("aspen_forest", BYGOverworldBiomes::aspenForest, BYGBiomeTags.IS_OVERWORLD, BYGBiomeTags.IS_FOREST);
    public static final ResourceKey<Biome> ATACAMA_DESERT = BYGBiomes.createBiome("atacama_desert", BYGOverworldBiomes::atacamaDesert, BYGBiomeTags.IS_OVERWORLD, BYGBiomeTags.IS_DESERT);
    public static final ResourceKey<Biome> AUTUMNAL_VALLEY = BYGBiomes.createBiome("autumnal_valley", BYGOverworldBiomes::autumnalValley, BYGBiomeTags.IS_OVERWORLD, BYGBiomeTags.IS_PLAIN);
    public static final ResourceKey<Biome> BAOBAB_SAVANNA = BYGBiomes.createBiome("baobab_savanna", BYGOverworldBiomes::baobabSavanna, BYGBiomeTags.IS_OVERWORLD, BYGBiomeTags.IS_SAVANNA);
    public static final ResourceKey<Biome> BAYOU = BYGBiomes.createBiome("bayou", BYGOverworldBiomes::bayou, BYGBiomeTags.IS_SWAMP, BYGBiomeTags.IS_OVERWORLD, BYGBiomeTags.ALLOWS_SURFACE_SLIME_SPAWNS);
    public static final ResourceKey<Biome> BLACK_FOREST = BYGBiomes.createBiome("black_forest", BYGOverworldBiomes::blackForest, BYGBiomeTags.IS_OVERWORLD, BYGBiomeTags.IS_TAIGA);
    public static final ResourceKey<Biome> BOREALIS_GROVE = BYGBiomes.createBiome("borealis_grove", BYGOverworldBiomes::borealisGrove, BYGBiomeTags.IS_OVERWORLD);
    public static final ResourceKey<Biome> CANADIAN_SHIELD = BYGBiomes.createBiome("canadian_shield", BYGOverworldBiomes::canadianShield, BYGBiomeTags.IS_OVERWORLD, BYGBiomeTags.IS_MOUNTAIN, BYGBiomeTags.IS_TAIGA);
    public static final ResourceKey<Biome> CHERRY_BLOSSOM_FOREST = BYGBiomes.createBiome("cherry_blossom_forest", BYGOverworldBiomes::cherryBlossomForest, BYGBiomeTags.IS_OVERWORLD, BYGBiomeTags.IS_FOREST);
    public static final ResourceKey<Biome> CIKA_WOODS = BYGBiomes.createBiome("cika_woods", BYGOverworldBiomes::cikaWoods, BYGBiomeTags.IS_OVERWORLD, BYGBiomeTags.IS_FOREST);
    public static final ResourceKey<Biome> CONIFEROUS_FOREST = BYGBiomes.createBiome("coniferous_forest", () -> BYGOverworldBiomes.coniferousForest(false), BYGBiomeTags.IS_OVERWORLD, BYGBiomeTags.IS_TAIGA);
    public static final ResourceKey<Biome> CRAG_GARDENS = BYGBiomes.createBiome("crag_gardens", BYGOverworldBiomes::cragGardens, BYGBiomeTags.IS_OVERWORLD, BYGBiomeTags.IS_JUNGLE, BYGBiomeTags.IS_MOUNTAIN);
    public static final ResourceKey<Biome> CYPRESS_SWAMPLANDS = BYGBiomes.createBiome("cypress_swamplands", BYGOverworldBiomes::cypressSwamplands, BYGBiomeTags.IS_SWAMP, BYGBiomeTags.IS_OVERWORLD, BYGBiomeTags.ALLOWS_SURFACE_SLIME_SPAWNS, BYGBiomeTags.CLIMATE_WET_OVERWORLD);
    public static final ResourceKey<Biome> LUSH_STACKS = BYGBiomes.createBiome("lush_stacks", BYGOverworldBiomes::lushStacks, BYGBiomeTags.IS_DEEP_OCEAN, BYGBiomeTags.IS_OCEAN, BYGBiomeTags.IS_OVERWORLD, BYGBiomeTags.IS_OCEAN, BYGBiomeTags.IS_DEEP_OCEAN);
    public static final ResourceKey<Biome> DEAD_SEA = BYGBiomes.createBiome("dead_sea", BYGOverworldBiomes::deadSea, BYGBiomeTags.IS_DEEP_OCEAN, BYGBiomeTags.IS_OCEAN, BYGBiomeTags.IS_WASTELAND, BYGBiomeTags.IS_DEAD, BYGBiomeTags.IS_OVERWORLD);
    public static final ResourceKey<Biome> DACITE_RIDGES = BYGBiomes.createBiome("dacite_ridges", BYGOverworldBiomes::daciteRidges, BYGBiomeTags.IS_OVERWORLD, BYGBiomeTags.IS_MOUNTAIN);
    public static final ResourceKey<Biome> WINDSWEPT_DESERT = BYGBiomes.createBiome("windswept_desert", () -> BYGOverworldBiomes.windsweptDesert(false), BYGBiomeTags.IS_OVERWORLD, BYGBiomeTags.IS_DESERT);
    public static final ResourceKey<Biome> EBONY_WOODS = BYGBiomes.createBiome("ebony_woods", BYGOverworldBiomes::ebonyWoods, BYGBiomeTags.IS_OVERWORLD, BYGBiomeTags.IS_FOREST);
    public static final ResourceKey<Biome> FORGOTTEN_FOREST = BYGBiomes.createBiome("forgotten_forest", BYGOverworldBiomes::forgottenForest, BYGBiomeTags.IS_OVERWORLD, BYGBiomeTags.IS_FOREST, BYGBiomeTags.IS_MAGICAL);
    public static final ResourceKey<Biome> GROVE = BYGBiomes.createBiome("temperate_grove", () -> BYGOverworldBiomes.temperateGrove(false), BYGBiomeTags.IS_OVERWORLD, BYGBiomeTags.CLIMATE_TEMPERATE_OVERWORLD, BYGBiomeTags.IS_FOREST);
    public static final ResourceKey<Biome> GUIANA_SHIELD = BYGBiomes.createBiome("guiana_shield", BYGOverworldBiomes::guianaShield, BYGBiomeTags.IS_OVERWORLD, BYGBiomeTags.IS_JUNGLE);
    public static final ResourceKey<Biome> HOWLING_PEAKS = BYGBiomes.createBiome("howling_peaks", BYGOverworldBiomes::howlingPeaks, BYGBiomeTags.IS_OVERWORLD, BYGBiomeTags.IS_MOUNTAIN);
    public static final ResourceKey<Biome> JACARANDA_FOREST = BYGBiomes.createBiome("jacaranda_forest", BYGOverworldBiomes::jacarandaForest, BYGBiomeTags.IS_OVERWORLD, BYGBiomeTags.IS_FOREST);
    public static final ResourceKey<Biome> MAPLE_TAIGA = BYGBiomes.createBiome("maple_taiga", BYGOverworldBiomes::mapleTaiga, BYGBiomeTags.IS_OVERWORLD, BYGBiomeTags.IS_TAIGA);
    public static final ResourceKey<Biome> COCONINO_MEADOW = BYGBiomes.createBiome("coconino_meadow", () -> BYGOverworldBiomes.coconinoMeadow(false, false), BYGBiomeTags.IS_OVERWORLD, BYGBiomeTags.IS_PLAIN);
    public static final ResourceKey<Biome> MOJAVE_DESERT = BYGBiomes.createBiome("mojave_desert", BYGOverworldBiomes::mojaveDesert, BYGBiomeTags.IS_SANDY, BYGBiomeTags.IS_OVERWORLD, BYGBiomeTags.IS_DESERT);
    public static final ResourceKey<Biome> CARDINAL_TUNDRA = BYGBiomes.createBiome("cardinal_tundra", BYGOverworldBiomes::cardinalTundra, BYGBiomeTags.IS_OVERWORLD, BYGBiomeTags.IS_SNOWY);
    public static final ResourceKey<Biome> ORCHARD = BYGBiomes.createBiome("orchard", BYGOverworldBiomes::orchard, BYGBiomeTags.IS_OVERWORLD, BYGBiomeTags.IS_FOREST);
    public static final ResourceKey<Biome> PRAIRIE = BYGBiomes.createBiome("prairie", BYGOverworldBiomes::prairie, BYGBiomeTags.IS_OVERWORLD, BYGBiomeTags.IS_PLAIN);
    public static final ResourceKey<Biome> RED_OAK_FOREST = BYGBiomes.createBiome("red_oak_forest", BYGOverworldBiomes::redOakForest, BYGBiomeTags.IS_OVERWORLD, BYGBiomeTags.IS_FOREST);
    public static final ResourceKey<Biome> RED_ROCK_VALLEY = BYGBiomes.createBiome("red_rock_valley", BYGOverworldBiomes::redRockValley, BYGBiomeTags.IS_BADLANDS, BYGBiomeTags.IS_OVERWORLD, BYGBiomeTags.IS_BADLANDS, BYGBiomeTags.HAS_MINESHAFT_MESA);
    public static final ResourceKey<Biome> ROSE_FIELDS = BYGBiomes.createBiome("rose_fields", BYGOverworldBiomes::roseFields, BYGBiomeTags.IS_OVERWORLD, BYGBiomeTags.IS_PLAIN);
    public static final ResourceKey<Biome> AUTUMNAL_FOREST = BYGBiomes.createBiome("autumnal_forest", BYGOverworldBiomes::autumnalForest, BYGBiomeTags.IS_OVERWORLD, BYGBiomeTags.IS_FOREST);
    public static final ResourceKey<Biome> AUTUMNAL_TAIGA = BYGBiomes.createBiome("autumnal_taiga", () -> BYGOverworldBiomes.autumnalTaiga(false), BYGBiomeTags.IS_OVERWORLD, BYGBiomeTags.IS_TAIGA);
    public static final ResourceKey<Biome> SHATTERED_GLACIER = BYGBiomes.createBiome("shattered_glacier", BYGOverworldBiomes::shatteredGlacier, BYGBiomeTags.IS_ICY, BYGBiomeTags.IS_OVERWORLD, BYGBiomeTags.IS_ICY, BYGBiomeTags.IS_SNOWY);
    public static final ResourceKey<Biome> FIRECRACKER_SHRUBLAND = BYGBiomes.createBiome("firecracker_shrubland", BYGOverworldBiomes::firecrackerShrubland, BYGBiomeTags.IS_OVERWORLD);
    public static final ResourceKey<Biome> SIERRA_BADLANDS = BYGBiomes.createBiome("sierra_badlands", BYGOverworldBiomes::sierraBadlands, BYGBiomeTags.IS_BADLANDS, BYGBiomeTags.IS_OVERWORLD);
    public static final ResourceKey<Biome> SKYRIS_VALE = BYGBiomes.createBiome("skyris_vale", BYGOverworldBiomes::skyrisVale, BYGBiomeTags.IS_OVERWORLD);
    public static final ResourceKey<Biome> REDWOOD_THICKET = BYGBiomes.createBiome("redwood_thicket", BYGOverworldBiomes::redwoodThicket, BYGBiomeTags.IS_OVERWORLD, BYGBiomeTags.IS_FOREST);
    public static final ResourceKey<Biome> FROSTED_TAIGA = BYGBiomes.createBiome("frosted_taiga", () -> BYGOverworldBiomes.frostedTaiga(true, false), BYGBiomeTags.IS_SNOWY, BYGBiomeTags.IS_OVERWORLD);
    public static final ResourceKey<Biome> FROSTED_CONIFEROUS_FOREST = BYGBiomes.createBiome("frosted_coniferous_forest", () -> BYGOverworldBiomes.coniferousForest(true), BYGBiomeTags.IS_SNOWY, BYGBiomeTags.IS_OVERWORLD, BYGBiomeTags.IS_TAIGA);
    public static final ResourceKey<Biome> FRAGMENT_FOREST = BYGBiomes.createBiome("fragment_forest", BYGOverworldBiomes::fragmentForest, BYGBiomeTags.IS_OVERWORLD, BYGBiomeTags.IS_FOREST);
    public static final ResourceKey<Biome> TROPICAL_RAINFOREST = BYGBiomes.createBiome("tropical_rainforest", BYGOverworldBiomes::tropicalRainforest, BYGBiomeTags.IS_OVERWORLD);
    public static final ResourceKey<Biome> TWILIGHT_MEADOW = BYGBiomes.createBiome("twilight_meadow", BYGOverworldBiomes::twilightMeadow, BYGBiomeTags.IS_OVERWORLD, BYGBiomeTags.IS_MAGICAL);
    public static final ResourceKey<Biome> WEEPING_WITCH_FOREST = BYGBiomes.createBiome("weeping_witch_forest", BYGOverworldBiomes::weepingWitchForest, BYGBiomeTags.IS_SPOOKY, BYGBiomeTags.IS_OVERWORLD);
    public static final ResourceKey<Biome> WHITE_MANGROVE_MARSHES = BYGBiomes.createBiome("white_mangrove_marshes", BYGOverworldBiomes::whiteMangroveMarshes, BYGBiomeTags.IS_OVERWORLD, BYGBiomeTags.ALLOWS_SURFACE_SLIME_SPAWNS);
    public static final ResourceKey<Biome> TEMPERATE_RAINFOREST = BYGBiomes.createBiome("temperate_rainforest", BYGOverworldBiomes::temperateRainForest, BYGBiomeTags.IS_OVERWORLD, BYGBiomeTags.CLIMATE_TEMPERATE_OVERWORLD, BYGBiomeTags.IS_FOREST);
    public static final ResourceKey<Biome> ZELKOVA_FOREST = BYGBiomes.createBiome("zelkova_forest", BYGOverworldBiomes::zelkovaForest, BYGBiomeTags.IS_OVERWORLD, BYGBiomeTags.IS_FOREST);
    public static final ResourceKey<Biome> RAINBOW_BEACH = BYGBiomes.createBiome("rainbow_beach", BYGOverworldBiomes::rainbowBeach, BYGBiomeTags.IS_BEACH, BYGBiomeTags.IS_OVERWORLD);
    public static final ResourceKey<Biome> BASALT_BARRERA = BYGBiomes.createBiome("basalt_barrera", BYGOverworldBiomes::basaltBarrera, BYGBiomeTags.IS_BEACH, BYGBiomeTags.IS_OVERWORLD);
    public static final ResourceKey<Biome> DACITE_SHORE = BYGBiomes.createBiome("dacite_shore", BYGOverworldBiomes::daciteShore, BYGBiomeTags.IS_BEACH, BYGBiomeTags.IS_OVERWORLD);
    public static final ResourceKey<Biome> BRIMSTONE_CAVERNS = BYGBiomes.createBiome("brimstone_caverns", BYGNetherBiomes::brimstoneCaverns, BYGBiomeTags.IS_NETHER);
    public static final ResourceKey<Biome> CRIMSON_GARDENS = BYGBiomes.createBiome("crimson_gardens", BYGNetherBiomes::crimsonGardens, BYGBiomeTags.IS_NETHER);
    public static final ResourceKey<Biome> EMBUR_BOG = BYGBiomes.createBiome("embur_bog", BYGNetherBiomes::emburBog, BYGBiomeTags.IS_NETHER);
    public static final ResourceKey<Biome> GLOWSTONE_GARDENS = BYGBiomes.createBiome("glowstone_gardens", BYGNetherBiomes::glowstoneGardens, BYGBiomeTags.IS_NETHER);
    public static final ResourceKey<Biome> MAGMA_WASTES = BYGBiomes.createBiome("magma_wastes", BYGNetherBiomes::magmaWastes, BYGBiomeTags.IS_NETHER);
    public static final ResourceKey<Biome> SUBZERO_HYPOGEAL = BYGBiomes.createBiome("subzero_hypogeal", BYGNetherBiomes::subzeroHypogeal, BYGBiomeTags.IS_NETHER, BYGBiomeTags.CLIMATE_COLD_NETHER);
    public static final ResourceKey<Biome> SYTHIAN_TORRIDS = BYGBiomes.createBiome("sythian_torrids", BYGNetherBiomes::sythianTorrids, BYGBiomeTags.IS_NETHER);
    public static final ResourceKey<Biome> WARPED_DESERT = BYGBiomes.createBiome("warped_desert", BYGNetherBiomes::warpedDesert, BYGBiomeTags.IS_NETHER);
    public static final ResourceKey<Biome> WAILING_GARTH = BYGBiomes.createBiome("wailing_garth", BYGNetherBiomes::wailingGarth, BYGBiomeTags.IS_NETHER);
    public static final ResourceKey<Biome> ARISIAN_UNDERGROWTH = BYGBiomes.createBiome("arisian_undergrowth", BYGNetherBiomes::arisianUndergrowth, BYGBiomeTags.IS_NETHER);
    public static final ResourceKey<Biome> WEEPING_MIRE = BYGBiomes.createBiome("weeping_mire", BYGNetherBiomes::weepingMire, BYGBiomeTags.IS_NETHER);
    public static final ResourceKey<Biome> QUARTZ_DESERT = BYGBiomes.createBiome("quartz_desert", BYGNetherBiomes::quartzDesert, BYGBiomeTags.IS_NETHER);
    public static final ResourceKey<Biome> IVIS_FIELDS = BYGBiomes.createBiome("ivis_fields", BYGEndBiomes::ivisFields, BYGBiomeTags.IS_END);
    public static final ResourceKey<Biome> NIGHTSHADE_FOREST = BYGBiomes.createBiome("nightshade_forest", BYGEndBiomes::nightshadeForest, BYGBiomeTags.IS_END);
    public static final ResourceKey<Biome> ETHEREAL_ISLANDS = BYGBiomes.createBiome("ethereal_islands", BYGEndBiomes::etherealIslands, BYGBiomeTags.IS_END);
    public static final ResourceKey<Biome> VISCAL_ISLES = BYGBiomes.createBiome("viscal_isles", BYGEndBiomes::viscalIsles, BYGBiomeTags.IS_END);
    public static final ResourceKey<Biome> BULBIS_GARDENS = BYGBiomes.createBiome("bulbis_gardens", BYGEndBiomes::bulbisGardens, BYGBiomeTags.IS_END);
    public static final ResourceKey<Biome> SHULKREN_FOREST = BYGBiomes.createBiome("shulkren_forest", BYGEndBiomes::shulkrenForest, BYGBiomeTags.IS_END);
    public static final ResourceKey<Biome> CRYPTIC_WASTES = BYGBiomes.createBiome("cryptic_wastes", BYGEndBiomes::crypticWastes, BYGBiomeTags.IS_END);
    public static final ResourceKey<Biome> IMPARIUS_GROVE = BYGBiomes.createBiome("imparius_grove", BYGEndBiomes::impariusGrove, BYGBiomeTags.IS_END);

    @SafeVarargs
    public static <B extends Biome> ResourceKey<Biome> createBiome(String id, Supplier<? extends B> biome, TagKey<Biome> ... tags) {
        ResourceLocation bygID = BYG.createLocation(id);
        if (BuiltinRegistries.f_123865_.m_6566_().contains(bygID)) {
            throw new IllegalStateException("Biome ID: \"" + bygID + "\" already exists in the Biome registry!");
        }
        RegistryObject<? extends B> reg = PROVIDER.register(id, biome);
        for (TagKey<Biome> tag : tags) {
            if (!tag.f_203868_().m_135827_().equals("byg")) {
                throw new IllegalArgumentException("Tag key must be from the BYG namespace!");
            }
            BIOMES_BY_TAG.put(tag, reg);
        }
        return ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)bygID);
    }

    public static void loadClass() {
        BlendingFunction.register();
        BYGStructurePieceTypes.bootStrap();
        BYGStructureSets.bootStrap();
        BYGPlacementModifierType.bootStrap();
        BYGRuleSources.bootStrap();
        VillagerTradeRegistry.register();
    }
}

