/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.biome.end;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.levelgen.DensityFunction;
import org.jetbrains.annotations.NotNull;
import potionstudios.byg.BYG;
import potionstudios.byg.common.world.biome.LayersBiomeData;
import potionstudios.byg.common.world.biome.LazyLoadSeed;
import potionstudios.byg.common.world.biome.end.EndBiomesConfig;
import potionstudios.byg.util.BYGUtil;

public abstract class BYGEndBiomeSource
extends BiomeSource
implements LazyLoadSeed {
    public static final ResourceLocation LOCATION = BYG.createLocation("end");
    private final Registry<Biome> biomeRegistry;
    private BiomeResolver islandBiomeResolver;
    private BiomeResolver voidBiomeResolver;
    private BiomeResolver skyBiomeResolver;
    private final int skyLayersStartY;

    protected BYGEndBiomeSource(Registry<Biome> biomeRegistry) {
        super(BYGEndBiomeSource.getPossibleBiomes(biomeRegistry));
        this.biomeRegistry = biomeRegistry;
        EndBiomesConfig config = EndBiomesConfig.getConfig();
        this.skyLayersStartY = QuartPos.m_175400_((int)config.skyLayerStartY());
    }

    @Override
    public void lazyLoad(long seed) {
        EndBiomesConfig config = EndBiomesConfig.getConfig();
        Set possibleBiomes = this.m_207840_().stream().map(Holder::m_203543_).map(Optional::orElseThrow).collect(Collectors.toSet());
        BiPredicate<Collection<ResourceKey<Biome>>, ResourceKey<Biome>> filter = (existing, added) -> !existing.contains(added) && possibleBiomes.contains(added);
        this.islandBiomeResolver = this.getIslandBiomeResolver(this.biomeRegistry, seed, config.islandLayers().filter(filter));
        this.voidBiomeResolver = this.getVoidBiomeResolver(this.biomeRegistry, seed, config.voidLayers().filter(filter));
        this.skyBiomeResolver = this.getSkyBiomeResolver(this.biomeRegistry, seed, config.skyLayers().filter(filter));
    }

    public abstract BiomeResolver getIslandBiomeResolver(Registry<Biome> var1, long var2, LayersBiomeData var4);

    public abstract BiomeResolver getVoidBiomeResolver(Registry<Biome> var1, long var2, LayersBiomeData var4);

    public abstract BiomeResolver getSkyBiomeResolver(Registry<Biome> var1, long var2, LayersBiomeData var4);

    public Holder<Biome> m_203407_(int x, int y, int z, Climate.Sampler sampler) {
        int quartX = QuartPos.m_175402_((int)x);
        int quartY = QuartPos.m_175402_((int)y);
        int quartZ = QuartPos.m_175402_((int)z);
        int chunkX = x >> 2;
        int chunkZ = z >> 2;
        if ((long)chunkX * (long)chunkX + (long)chunkZ * (long)chunkZ <= 4096L) {
            return this.biomeRegistry.m_206081_(Biomes.f_48210_);
        }
        if (y > this.skyLayersStartY) {
            return this.skyBiomeResolver.m_203407_(x, y, z, sampler);
        }
        double heightValue = sampler.f_207848_().m_207386_((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(quartX, quartY, quartZ));
        if (heightValue > 40.0) {
            return this.islandBiomeResolver.m_203407_(x, y, z, sampler);
        }
        if (heightValue >= 0.0) {
            return this.islandBiomeResolver.m_203407_(x, y, z, sampler);
        }
        return heightValue < -20.0 ? this.voidBiomeResolver.m_203407_(x, y, z, sampler) : this.islandBiomeResolver.m_203407_(x, y, z, sampler);
    }

    protected Registry<Biome> getBiomeRegistry() {
        return this.biomeRegistry;
    }

    @NotNull
    private static List<Holder<Biome>> getPossibleBiomes(Registry<Biome> biomeRegistry) {
        EndBiomesConfig config = EndBiomesConfig.getConfig(false, false, biomeRegistry);
        TreeSet<String> missingBiomes = new TreeSet<String>();
        BiPredicate<Collection<ResourceKey<Biome>>, ResourceKey<Biome>> filter = (existing, added) -> {
            boolean biomeRegistryHas = biomeRegistry.m_142003_(added);
            if (!biomeRegistryHas) {
                missingBiomes.add(added.m_135782_().toString());
            }
            return !existing.contains(added) && biomeRegistryHas;
        };
        LayersBiomeData usedIslandLayer = config.islandLayers().filter(filter);
        LayersBiomeData usedVoidLayer = config.voidLayers().filter(filter);
        LayersBiomeData usedSkyLayer = config.skyLayers().filter(filter);
        String ignored = BYGUtil.dumpCollection(missingBiomes);
        if (!ignored.isEmpty()) {
            BYG.LOGGER.warn(String.format("Config \"%s\" warned:\nThe following biome entries were ignored due to not being in this world's biome registry:\n%s", EndBiomesConfig.CONFIG_PATH.get(), ignored.toString()));
        }
        List<Holder<Biome>> biomesFromBiomeData = BYGUtil.createBiomesFromBiomeData(biomeRegistry, usedIslandLayer, usedVoidLayer, usedSkyLayer);
        biomesFromBiomeData.add((Holder<Biome>)biomeRegistry.m_206081_(Biomes.f_48210_));
        return biomesFromBiomeData;
    }
}

