/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.biome.nether;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import org.jetbrains.annotations.NotNull;
import potionstudios.byg.BYG;
import potionstudios.byg.common.world.biome.LayersBiomeData;
import potionstudios.byg.common.world.biome.LazyLoadSeed;
import potionstudios.byg.common.world.biome.nether.NetherBiomesConfig;
import potionstudios.byg.common.world.math.noise.fastnoise.lite.FastNoiseLite;
import potionstudios.byg.util.BYGUtil;

public abstract class BYGNetherBiomeSource
extends BiomeSource
implements LazyLoadSeed {
    public static final ResourceLocation LOCATION = BYG.createLocation("nether");
    private FastNoiseLite lowerLayerRoughnessNoise;
    private FastNoiseLite upperLayerRoughnessNoise;
    private final Registry<Biome> biomeRegistry;
    private BiomeResolver upperBiomeResolver;
    private BiomeResolver middleBiomeResolver;
    private BiomeResolver bottomResolver;
    private final int bottomTopY;

    protected BYGNetherBiomeSource(Registry<Biome> biomeRegistry) {
        super(BYGNetherBiomeSource.getPossibleBiomes(biomeRegistry));
        this.biomeRegistry = biomeRegistry;
        NetherBiomesConfig config = NetherBiomesConfig.getConfig();
        Set possibleBiomes = this.m_207840_().stream().map(Holder::m_203543_).map(Optional::orElseThrow).collect(Collectors.toSet());
        BiPredicate<Collection, ResourceKey> filter = (existing, added) -> !existing.contains(added) && possibleBiomes.contains(added);
        int usedLayerSize = config.layerSize();
        this.bottomTopY = QuartPos.m_175400_((int)usedLayerSize);
    }

    @Override
    public void lazyLoad(long seed) {
        NetherBiomesConfig config = NetherBiomesConfig.getConfig();
        Set possibleBiomes = this.m_207840_().stream().map(Holder::m_203543_).map(Optional::orElseThrow).collect(Collectors.toSet());
        BiPredicate<Collection<ResourceKey<Biome>>, ResourceKey<Biome>> filter = (existing, added) -> !existing.contains(added) && possibleBiomes.contains(added);
        this.lowerLayerRoughnessNoise = new FastNoiseLite((int)seed);
        this.lowerLayerRoughnessNoise.SetNoiseType(FastNoiseLite.NoiseType.OpenSimplex2);
        this.lowerLayerRoughnessNoise.SetFrequency(0.005f);
        this.upperLayerRoughnessNoise = new FastNoiseLite((int)seed + 43594389);
        this.upperLayerRoughnessNoise.SetNoiseType(FastNoiseLite.NoiseType.OpenSimplex2);
        this.upperLayerRoughnessNoise.SetFrequency(0.005f);
        this.upperBiomeResolver = this.getUpperBiomeResolver(this.biomeRegistry, seed, config.upperLayer().filter(filter));
        this.middleBiomeResolver = this.getMiddleBiomeResolver(this.biomeRegistry, seed, config.middleLayer().filter(filter));
        this.bottomResolver = this.getLowerBiomeResolver(this.biomeRegistry, seed, config.bottomLayer().filter(filter));
    }

    public abstract BiomeResolver getUpperBiomeResolver(Registry<Biome> var1, long var2, LayersBiomeData var4);

    public abstract BiomeResolver getMiddleBiomeResolver(Registry<Biome> var1, long var2, LayersBiomeData var4);

    public abstract BiomeResolver getLowerBiomeResolver(Registry<Biome> var1, long var2, LayersBiomeData var4);

    public Holder<Biome> m_203407_(int x, int y, int z, Climate.Sampler sampler) {
        if ((float)y < (float)this.bottomTopY + this.lowerLayerRoughnessNoise.GetNoise(x, z) * 5.0f) {
            return this.bottomResolver.m_203407_(x, y, z, sampler);
        }
        if ((float)y > (float)(this.bottomTopY + this.bottomTopY) + this.upperLayerRoughnessNoise.GetNoise(x, z) * 5.0f) {
            return this.upperBiomeResolver.m_203407_(x, y, z, sampler);
        }
        return this.middleBiomeResolver.m_203407_(x, y, z, sampler);
    }

    protected Registry<Biome> getBiomeRegistry() {
        return this.biomeRegistry;
    }

    @NotNull
    private static List<Holder<Biome>> getPossibleBiomes(Registry<Biome> biomeRegistry) {
        NetherBiomesConfig config = NetherBiomesConfig.getConfig(false, false, biomeRegistry);
        TreeSet<String> missingBiomes = new TreeSet<String>();
        BiPredicate<Collection<ResourceKey<Biome>>, ResourceKey<Biome>> filter = (existing, added) -> {
            boolean biomeRegistryHas = biomeRegistry.m_142003_(added);
            if (!biomeRegistryHas) {
                missingBiomes.add(added.m_135782_().toString());
            }
            return !existing.contains(added) && biomeRegistryHas;
        };
        LayersBiomeData upperLayer = config.upperLayer().filter(filter);
        LayersBiomeData middleLayer = config.middleLayer().filter(filter);
        LayersBiomeData bottomLayer = config.bottomLayer().filter(filter);
        String ignored = BYGUtil.dumpCollection(missingBiomes);
        if (!ignored.isEmpty()) {
            BYG.LOGGER.warn(String.format("Config \"%s\" warned:\nThe following biome entries were ignored due to not being in this world's biome registry:\n%s", NetherBiomesConfig.CONFIG_PATH.get(), ignored.toString()));
        }
        return BYGUtil.createBiomesFromBiomeData(biomeRegistry, upperLayer, middleLayer, bottomLayer);
    }
}

