/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.feature.gen.nether;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import potionstudios.byg.common.world.feature.config.HangingColumnWithBaseConfig;

public class HangingColumnWithBase
extends Feature<HangingColumnWithBaseConfig> {
    private static final Direction[] DIRECTIONS = Direction.values();

    public HangingColumnWithBase(Codec<HangingColumnWithBaseConfig> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<HangingColumnWithBaseConfig> featurePlaceContext) {
        return this.place(featurePlaceContext.m_159774_(), featurePlaceContext.m_159775_(), featurePlaceContext.m_225041_(), featurePlaceContext.m_159777_(), (HangingColumnWithBaseConfig)featurePlaceContext.m_159778_());
    }

    public boolean place(WorldGenLevel world, ChunkGenerator generator, RandomSource rand, BlockPos pos, HangingColumnWithBaseConfig config) {
        if (!world.m_46859_(pos)) {
            return false;
        }
        BlockState blockstate = world.m_8055_(pos.m_7494_());
        if (!config.getWhitelist().contains(blockstate.m_60734_())) {
            return false;
        }
        this.generateBase((LevelAccessor)world, rand, pos, config);
        this.generateVinesInArea((LevelAccessor)world, rand, pos, config);
        return true;
    }

    private void generateBase(LevelAccessor world, RandomSource rand, BlockPos pos, HangingColumnWithBaseConfig config) {
        world.m_7731_(pos, config.getBaseBlockProvider().m_213972_(rand, pos), 2);
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos mutable2 = new BlockPos.MutableBlockPos();
        for (int i = 0; i < 200; ++i) {
            mutable.m_122154_((Vec3i)pos, rand.m_188503_(6) - rand.m_188503_(6), rand.m_188503_(2) - rand.m_188503_(5), rand.m_188503_(6) - rand.m_188503_(6));
            if (!world.m_46859_((BlockPos)mutable)) continue;
            int j = 0;
            for (Direction direction : DIRECTIONS) {
                BlockState blockstate = world.m_8055_((BlockPos)mutable2.m_122159_((Vec3i)mutable, direction));
                if (config.getWhitelist().contains(blockstate.m_60734_())) {
                    ++j;
                }
                if (j > 1) break;
            }
            if (j != true) continue;
            world.m_7731_((BlockPos)mutable, config.getBaseBlockProvider().m_213972_(rand, (BlockPos)mutable), 2);
        }
    }

    private void generateVinesInArea(LevelAccessor world, RandomSource rand, BlockPos pos, HangingColumnWithBaseConfig config) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int i = 0; i < 100; ++i) {
            mutable.m_122154_((Vec3i)pos, rand.m_188503_(8) - rand.m_188503_(8), rand.m_188503_(2) - rand.m_188503_(7), rand.m_188503_(8) - rand.m_188503_(8));
            if (!world.m_46859_((BlockPos)mutable)) continue;
            BlockState blockstate = world.m_8055_(mutable.m_7494_());
            if (!config.getWhitelist().contains(blockstate.m_60734_())) continue;
            int length = Mth.m_216271_((RandomSource)rand, (int)config.getMinLength(), (int)config.getMaxLength());
            if (rand.m_188503_(6) == 0) {
                length *= 2;
            }
            if (rand.m_188503_(5) == 0) {
                length = 1;
            }
            HangingColumnWithBase.generateLength(world, mutable, length, rand, config);
        }
    }

    public static void generateLength(LevelAccessor world, BlockPos.MutableBlockPos mutable, int length, RandomSource rand, HangingColumnWithBaseConfig config) {
        for (int i = 0; i <= length; ++i) {
            if (world.m_46859_((BlockPos)mutable)) {
                if (i == length || !world.m_46859_(mutable.m_7495_())) {
                    world.m_7731_((BlockPos)mutable, config.getEndBlockProvider().m_213972_(rand, (BlockPos)mutable), 2);
                    break;
                }
                world.m_7731_((BlockPos)mutable, config.getBlockProvider().m_213972_(rand, (BlockPos)mutable), 2);
            }
            mutable.m_122173_(Direction.DOWN);
        }
    }
}

