/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.feature.gen.overworld;

import com.mojang.serialization.Codec;
import java.util.HashSet;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import potionstudios.byg.common.block.BYGBlocks;
import potionstudios.byg.common.world.feature.BYGFeatures;
import potionstudios.byg.common.world.feature.config.NoisySphereConfig;
import potionstudios.byg.common.world.feature.config.SimpleBlockProviderConfig;
import potionstudios.byg.common.world.math.noise.fastnoise.FastNoise;
import potionstudios.byg.util.blendingfunction.BlendingFunctions;

public class ArchFeature
extends Feature<SimpleBlockProviderConfig> {
    protected long seed;
    protected static FastNoise fastNoise;

    public ArchFeature(Codec<SimpleBlockProviderConfig> configCodec) {
        super(configCodec);
    }

    public boolean m_142674_(FeaturePlaceContext<SimpleBlockProviderConfig> featurePlaceContext) {
        return this.place(featurePlaceContext.m_159774_(), featurePlaceContext.m_159775_(), featurePlaceContext.m_225041_(), featurePlaceContext.m_159777_(), (SimpleBlockProviderConfig)featurePlaceContext.m_159778_());
    }

    public boolean place(WorldGenLevel world, ChunkGenerator chunkGenerator, RandomSource random, BlockPos center, SimpleBlockProviderConfig config) {
        int points;
        this.setSeed(world.m_7328_());
        double angle = random.m_188500_() * Math.PI;
        ChunkPos chunkPos = new ChunkPos(center);
        center = chunkPos.m_151394_(center.m_123342_());
        int distance = 40 + random.m_188503_(6);
        int archHeight = 25 + random.m_188503_(10);
        center = center.m_7918_(0, archHeight, 0);
        double xOffset = Math.sin(angle) * (double)distance;
        double zOffset = Math.cos(angle) * (double)distance;
        WeightedStateProvider blockProvider = new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)BYGBlocks.RED_ROCK.defaultBlockState(), 4).m_146271_((Object)Blocks.f_50352_.m_49966_(), 1));
        NoisySphereConfig build = new NoisySphereConfig.Builder().withRadiusSettings(new NoisySphereConfig.RadiusSettings((IntProvider)UniformInt.m_146622_((int)10, (int)15), (IntProvider)UniformInt.m_146622_((int)10, (int)15), 0, (IntProvider)UniformInt.m_146622_((int)10, (int)15))).withBlockProvider((BlockStateProvider)blockProvider).withNoiseFrequency(0.02f).withTopBlockProvider((BlockStateProvider)blockProvider).build();
        BlockPos start = center.m_7637_(-xOffset, 0.0, -zOffset);
        start = new BlockPos(start.m_123341_(), world.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, start.m_123341_(), start.m_123343_()) - 5, start.m_123343_());
        BlockPos end = center.m_7637_(xOffset, 0.0, zOffset);
        end = new BlockPos(end.m_123341_(), world.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, end.m_123341_(), end.m_123343_()) - 5, end.m_123343_());
        HashSet<BlockPos> spherePositions = new HashSet<BlockPos>();
        for (int pointCount = points = 1000; pointCount >= 1; --pointCount) {
            double factor = (double)pointCount / (double)points;
            spherePositions.add(new BlockPos(Mth.m_14139_((double)factor, (double)start.m_123341_(), (double)center.m_123341_()), ArchFeature.easeOutCubic(factor, start.m_123342_(), center.m_123342_()), Mth.m_14139_((double)factor, (double)start.m_123343_(), (double)center.m_123343_())));
            spherePositions.add(new BlockPos(Mth.m_14139_((double)factor, (double)end.m_123341_(), (double)center.m_123341_()), ArchFeature.easeOutCubic(factor, end.m_123342_(), center.m_123342_()), Mth.m_14139_((double)factor, (double)end.m_123343_(), (double)center.m_123343_())));
        }
        for (BlockPos spherePosition : spherePositions) {
            int size = 1;
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
            BYGFeatures.BOULDER.get().m_142674_((FeaturePlaceContext<NoisySphereConfig>)new FeaturePlaceContext(Optional.empty(), world, chunkGenerator, random, spherePosition, (FeatureConfiguration)build));
            for (int x = -size; x <= size; ++x) {
                for (int y = -size; y <= size; ++y) {
                    for (int z = -size; z <= size; ++z) {
                        mutableBlockPos.m_122190_((Vec3i)spherePosition).m_122184_(x, y, z);
                    }
                }
            }
        }
        return true;
    }

    public void setSeed(long seed) {
        if (this.seed != seed || fastNoise == null) {
            fastNoise = new FastNoise((int)seed);
            fastNoise.SetNoiseType(FastNoise.NoiseType.Simplex);
            this.seed = seed;
        }
    }

    public static double easeOutCubic(double factor, double min, double max) {
        double range = max - min;
        return min + range * BlendingFunctions.easeOutCubic(factor);
    }
}

