/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.feature.gen.overworld.trees.structure;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.jetbrains.annotations.NotNull;
import potionstudios.byg.common.world.feature.gen.overworld.trees.structure.TreeFromStructureNBTConfig;
import potionstudios.byg.common.world.feature.gen.overworld.trees.util.BYGAbstractTreeFeature;
import potionstudios.byg.mixin.access.LeavesBlockAccess;
import potionstudios.byg.mixin.access.StructureTemplateAccess;

public class TreeFromStructureNBTFeature
extends Feature<TreeFromStructureNBTConfig> {
    public static final Direction[] DIRECTIONS = (Direction[])Arrays.stream(Direction.values()).filter(direction -> direction != Direction.UP).toArray(Direction[]::new);
    public static final Direction[] VINE_GEN_DIRECTIONS = (Direction[])Arrays.stream(Direction.values()).filter(direction -> direction != Direction.DOWN).toArray(Direction[]::new);
    private static final boolean DEBUG = false;

    public TreeFromStructureNBTFeature(Codec<TreeFromStructureNBTConfig> $$0) {
        super($$0);
    }

    public boolean m_142674_(FeaturePlaceContext<TreeFromStructureNBTConfig> featurePlaceContext) {
        BlockPos pos2;
        TreeFromStructureNBTConfig config = (TreeFromStructureNBTConfig)featurePlaceContext.m_159778_();
        BlockStateProvider logProvider = config.logProvider();
        BlockStateProvider leavesProvider = config.leavesProvider();
        WorldGenLevel level = featurePlaceContext.m_159774_();
        StructureTemplateManager templateManager = level.m_6018_().m_215082_();
        ResourceLocation baseLocation = config.baseLocation();
        Optional baseTemplateOptional = templateManager.m_230407_(baseLocation);
        ResourceLocation canopyLocation = config.canopyLocation();
        Optional canopyTemplateOptional = templateManager.m_230407_(canopyLocation);
        if (baseTemplateOptional.isEmpty()) {
            throw TreeFromStructureNBTFeature.noTreePartPresent(baseLocation);
        }
        if (canopyTemplateOptional.isEmpty()) {
            throw TreeFromStructureNBTFeature.noTreePartPresent(canopyLocation);
        }
        StructureTemplate baseTemplate = (StructureTemplate)baseTemplateOptional.get();
        StructureTemplate canopyTemplate = (StructureTemplate)canopyTemplateOptional.get();
        List<StructureTemplate.Palette> basePalettes = ((StructureTemplateAccess)baseTemplate).byg_getPalettes();
        List<StructureTemplate.Palette> canopyPalettes = ((StructureTemplateAccess)canopyTemplate).byg_getPalettes();
        BlockPos origin = featurePlaceContext.m_159777_();
        RandomSource random = featurePlaceContext.m_225041_();
        StructurePlaceSettings placeSettings = new StructurePlaceSettings().m_74379_(Rotation.m_221990_((RandomSource)random));
        StructureTemplate.Palette randomBasePalette = placeSettings.m_74387_(basePalettes, origin);
        StructureTemplate.Palette randomCanopyPalette = placeSettings.m_74387_(canopyPalettes, origin);
        List center = randomBasePalette.m_74653_(Blocks.f_50041_);
        if (center.size() > 1) {
            throw new IllegalArgumentException("There cannot be more than one central position.");
        }
        BlockPos centerOffset = ((StructureTemplate.StructureBlockInfo)center.get((int)0)).f_74675_;
        centerOffset = new BlockPos(-centerOffset.m_123341_(), 0, -centerOffset.m_123343_());
        List leaves = randomCanopyPalette.m_74653_(config.leavesTarget());
        List canopyLogs = randomCanopyPalette.m_74653_(config.logTarget());
        List logs = randomBasePalette.m_74653_(config.logTarget());
        List logBuilders = randomBasePalette.m_74653_(Blocks.f_50108_);
        if (logBuilders.isEmpty()) {
            throw new UnsupportedOperationException(String.format("\"%s\" is missing log builders.", baseLocation));
        }
        HashSet leavePositions = new HashSet();
        HashSet<BlockPos> trunkPositions = new HashSet<BlockPos>();
        List trunkAnchor = randomBasePalette.m_74653_(Blocks.f_50098_);
        int trunkLength = config.height().m_214085_(random);
        int maxTrunkBuildingDepth = config.maxLogDepth();
        for (StructureTemplate.StructureBlockInfo logBuilder : logBuilders) {
            pos2 = TreeFromStructureNBTFeature.getModifiedPos(placeSettings, logBuilder, centerOffset, origin);
            if (TreeFromStructureNBTFeature.isOnGround(config.maxLogDepth(), level, pos2)) continue;
            return false;
        }
        block1: for (StructureTemplate.StructureBlockInfo logBuilder : logBuilders) {
            pos2 = TreeFromStructureNBTFeature.getModifiedPos(placeSettings, logBuilder, centerOffset, origin);
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos2);
            for (int i = 0; i < maxTrunkBuildingDepth; ++i) {
                BlockState blockState = level.m_8055_((BlockPos)mutableBlockPos);
                if (blockState.m_60815_()) {
                    Block block = blockState.m_60734_();
                    if (!BYGAbstractTreeFeature.SPREADABLE_TO_NON_SPREADABLE.containsKey(block)) continue block1;
                    level.m_7731_((BlockPos)mutableBlockPos, BYGAbstractTreeFeature.SPREADABLE_TO_NON_SPREADABLE.get(block).m_49966_(), 2);
                    continue block1;
                }
                level.m_7731_((BlockPos)mutableBlockPos, logProvider.m_213972_(featurePlaceContext.m_225041_(), (BlockPos)mutableBlockPos), 2);
                mutableBlockPos.m_122173_(Direction.DOWN);
            }
        }
        for (Object trunk : logs) {
            pos2 = TreeFromStructureNBTFeature.getModifiedPos(placeSettings, (StructureTemplate.StructureBlockInfo)trunk, centerOffset, origin);
            level.m_7731_(pos2, this.getTransformedState(logProvider.m_213972_(random, pos2), ((StructureTemplate.StructureBlockInfo)trunk).f_74676_, placeSettings.m_74404_()), 2);
            trunkPositions.add(pos2);
        }
        int trunkY = 0;
        for (StructureTemplate.StructureBlockInfo trunk : trunkAnchor) {
            trunkY = trunk.f_74675_.m_123342_();
            BlockPos pos3 = TreeFromStructureNBTFeature.getModifiedPos(placeSettings, trunk, centerOffset, origin);
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos3);
            for (int i = 0; i <= trunkLength; ++i) {
                level.m_7731_((BlockPos)mutable, logProvider.m_213972_(random, (BlockPos)mutable), 2);
                mutable.m_122173_(Direction.UP);
                trunkPositions.add(mutable.m_7949_());
            }
        }
        List canopyAnchor = randomCanopyPalette.m_74653_(Blocks.f_50041_);
        if (center.size() > 1) {
            throw new IllegalArgumentException("There cannot be more than one central position.");
        }
        if (center.isEmpty()) {
            throw new IllegalArgumentException("Canopy is missing anchor block (yellow wool).");
        }
        StructureTemplate.StructureBlockInfo structureBlockInfo = (StructureTemplate.StructureBlockInfo)canopyAnchor.get(0);
        BlockPos canopyCenterOffset = structureBlockInfo.f_74675_;
        canopyCenterOffset = new BlockPos(-canopyCenterOffset.m_123341_(), trunkY - canopyCenterOffset.m_123342_() + trunkLength, -canopyCenterOffset.m_123343_());
        for (StructureTemplate.StructureBlockInfo canopyLog : canopyLogs) {
            BlockPos pos4 = TreeFromStructureNBTFeature.getModifiedPos(placeSettings, canopyLog, canopyCenterOffset, origin);
            level.m_7731_(pos4, this.getTransformedState(logProvider.m_213972_(random, pos4), canopyLog.f_74676_, placeSettings.m_74404_()), 2);
        }
        ArrayList<Runnable> leavesPostApply = new ArrayList<Runnable>(leaves.size());
        for (StructureTemplate.StructureBlockInfo leaf : leaves) {
            BlockPos pos5 = TreeFromStructureNBTFeature.getModifiedPos(placeSettings, leaf, canopyCenterOffset, origin);
            BlockState state2 = leavesProvider.m_213972_(random, pos5);
            if (level.m_8055_(pos5).m_60815_()) continue;
            level.m_7731_(pos5, state2, 2);
            Runnable postProcess = () -> {
                BlockState blockState = LeavesBlockAccess.byg_invokeUpdateDistance(state2, (LevelAccessor)level, pos5);
                if ((Integer)blockState.m_61143_((Property)LeavesBlock.f_54418_) < 7) {
                    leavePositions.add(pos5);
                    level.m_7731_(pos5, blockState, 2);
                    level.m_186460_(pos5, blockState.m_60734_(), 0);
                } else {
                    level.m_7471_(pos5, false);
                }
            };
            leavesPostApply.add(postProcess);
        }
        leavesPostApply.forEach(Runnable::run);
        for (TreeDecorator treeDecorator : config.treeDecorators()) {
            treeDecorator.m_214187_(new TreeDecorator.Context((LevelSimulatedReader)level, (pos, state) -> level.m_7731_(pos, state, 2), random, trunkPositions, leavePositions, new HashSet()));
        }
        return true;
    }

    @NotNull
    private BlockState getTransformedState(BlockState state, BlockState canopyLogState, Rotation rotation) {
        Direction.Axis axis;
        for (Property property : state.m_61147_()) {
            if (!canopyLogState.m_61138_(property)) continue;
            Comparable value = canopyLogState.m_61143_(property);
            state = (BlockState)state.m_61124_(property, value);
        }
        if (state.m_61138_((Property)RotatedPillarBlock.f_55923_) && (axis = (Direction.Axis)state.m_61143_((Property)RotatedPillarBlock.f_55923_)).m_122479_() && (rotation == Rotation.CLOCKWISE_90 || rotation == Rotation.COUNTERCLOCKWISE_90)) {
            if (axis == Direction.Axis.X) {
                state = (BlockState)state.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Z);
            } else if (axis == Direction.Axis.Z) {
                state = (BlockState)state.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.X);
            }
        }
        return state;
    }

    private static boolean isOnGround(int maxLogDepth, WorldGenLevel level, BlockPos pos) {
        int oceanFloorHeight = level.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, pos.m_123341_(), pos.m_123343_());
        if (pos.m_123342_() > oceanFloorHeight) {
            return pos.m_123342_() - oceanFloorHeight < maxLogDepth;
        }
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos);
        for (int logDepth = 0; logDepth < maxLogDepth; ++logDepth) {
            mutableBlockPos.m_122173_(Direction.DOWN);
            BlockState blockState = level.m_8055_((BlockPos)mutableBlockPos);
            if (blockState.m_60767_().m_76336_()) continue;
            return true;
        }
        return false;
    }

    private static BlockPos getModifiedPos(StructurePlaceSettings settings, StructureTemplate.StructureBlockInfo placing, BlockPos partCenter, BlockPos featureOrigin) {
        return StructureTemplate.m_74563_((StructurePlaceSettings)settings, (BlockPos)placing.f_74675_).m_121955_((Vec3i)featureOrigin).m_121955_((Vec3i)StructureTemplate.m_74563_((StructurePlaceSettings)settings, (BlockPos)partCenter));
    }

    public static IllegalArgumentException noTreePartPresent(ResourceLocation location) {
        throw new IllegalArgumentException(String.format("\"%s\" is not a valid tree part.", location));
    }
}

