/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.feature.placement;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.OptionalInt;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.NoiseThresholdCountPlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.SurfaceWaterDepthFilter;
import potionstudios.byg.reg.RegistrationProvider;

public class BYGPlacedFeaturesUtil {
    public static final NoiseThresholdCountPlacement CLEARING_NOISE = NoiseThresholdCountPlacement.m_191756_((double)0.545, (int)1, (int)0);
    public static final RegistrationProvider<PlacedFeature> PLACED_FEATURES = RegistrationProvider.get(BuiltinRegistries.f_194653_, "byg");

    public static List<PlacementModifier> treePlacementBaseOceanFloor(PlacementModifier ... $$0) {
        return BYGPlacedFeaturesUtil.treePlacementBaseOceanFloor(OptionalInt.empty(), $$0);
    }

    public static List<PlacementModifier> treePlacementBaseOceanFloor(OptionalInt maxDepth, PlacementModifier ... $$0) {
        ImmutableList.Builder placementModifierBuilder = ImmutableList.builder().add((Object[])$$0).add((Object)InSquarePlacement.m_191715_()).add((Object)PlacementUtils.f_195353_).add((Object)BiomeFilter.m_191561_());
        if (maxDepth.isPresent()) {
            placementModifierBuilder.add((Object)SurfaceWaterDepthFilter.m_191950_((int)maxDepth.getAsInt()));
        }
        return placementModifierBuilder.build();
    }

    public static List<PlacementModifier> clearingTreePlacement(PlacementModifier placementModifier) {
        ArrayList<PlacementModifier> placementModifiers = new ArrayList<PlacementModifier>(VegetationPlacements.m_195479_((PlacementModifier)placementModifier));
        placementModifiers.add((PlacementModifier)CLEARING_NOISE);
        return placementModifiers;
    }

    public static List<PlacementModifier> clearingTreePlacement(PlacementModifier placementModifier, Block block) {
        ArrayList<PlacementModifier> placementModifiers = new ArrayList<PlacementModifier>(VegetationPlacements.m_195481_((PlacementModifier)placementModifier, (Block)block));
        placementModifiers.add((PlacementModifier)CLEARING_NOISE);
        return placementModifiers;
    }

    public static List<PlacementModifier> oceanFloorSquaredWithCount(int $$0, PlacementModifier ... modifiers) {
        return BYGPlacedFeaturesUtil.oceanFloorSquaredWithCountAndMaxDepth($$0, OptionalInt.empty(), modifiers);
    }

    public static List<PlacementModifier> oceanFloorSquaredWithCountAndMaxDepth(int $$0, OptionalInt maxDepth, PlacementModifier ... modifiers) {
        ArrayList<BiomeFilter> placementModifiers = new ArrayList<BiomeFilter>(List.of(CountPlacement.m_191628_((int)$$0), InSquarePlacement.m_191715_(), PlacementUtils.f_195355_, BiomeFilter.m_191561_()));
        if (maxDepth.isPresent()) {
            placementModifiers.add((BiomeFilter)SurfaceWaterDepthFilter.m_191950_((int)maxDepth.getAsInt()));
        }
        placementModifiers.addAll(Arrays.asList(modifiers));
        return placementModifiers;
    }

    @SafeVarargs
    public static <FC extends FeatureConfiguration> Holder<PlacedFeature> createPlacedFeature(String id, Holder<ConfiguredFeature<FC, ?>> feature, Supplier<PlacementModifier> ... placementModifiers) {
        return BYGPlacedFeaturesUtil.createPlacedFeature(id, feature, () -> Arrays.stream(placementModifiers).map(Supplier::get).toList());
    }

    public static <FC extends FeatureConfiguration> Holder<PlacedFeature> createPlacedFeature(String id, Holder<ConfiguredFeature<FC, ?>> feature, Supplier<List<PlacementModifier>> placementModifiers) {
        return PLACED_FEATURES.register(id, () -> new PlacedFeature(Holder.m_205706_((Holder)feature), (List)placementModifiers.get())).asHolder();
    }

    public static <FC extends FeatureConfiguration> Holder<PlacedFeature> createPlacedFeatureDirect(Holder<ConfiguredFeature<FC, ?>> feature, PlacementModifier ... placementModifiers) {
        return BYGPlacedFeaturesUtil.createPlacedFeatureDirect(feature, List.of(placementModifiers));
    }

    public static <FC extends FeatureConfiguration> Holder<PlacedFeature> createPlacedFeatureDirect(Holder<ConfiguredFeature<FC, ?>> feature, List<PlacementModifier> placementModifiers) {
        return Holder.m_205709_((Object)new PlacedFeature(Holder.m_205706_(feature), List.copyOf(placementModifiers)));
    }

    public static String globalFeaturePath(String path) {
        return "global/placed_feature/" + path;
    }
}

