/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.structure;

import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.valueproviders.ConstantFloat;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformFloat;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.heightproviders.ConstantHeight;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;
import potionstudios.byg.common.block.BYGBlocks;
import potionstudios.byg.common.world.biome.BYGBiomeTags;
import potionstudios.byg.common.world.feature.config.NoisySphereConfig;
import potionstudios.byg.common.world.feature.features.BYGStructurePlacedFeatures;
import potionstudios.byg.common.world.structure.arch.ArchConfiguration;
import potionstudios.byg.common.world.structure.arch.ArchStructure;
import potionstudios.byg.common.world.structure.village.pool.RedRockVillagePools;
import potionstudios.byg.common.world.structure.village.pool.RuinsVillagePools;
import potionstudios.byg.common.world.structure.village.pool.SkyrisVillagePools;
import potionstudios.byg.common.world.structure.village.pool.TropicalVillagePools;
import potionstudios.byg.common.world.structure.volcano.VolcanoStructure;
import potionstudios.byg.mixin.access.StructuresAccess;
import potionstudios.byg.reg.RegistrationProvider;
import potionstudios.byg.util.blendingfunction.BlendingFunction;

public class BYGStructures {
    public static final RegistrationProvider<Structure> PROVIDER = RegistrationProvider.get(BuiltinRegistries.f_235988_, "byg");
    public static final Holder<Structure> VILLAGE_RED_ROCK = BYGStructures.register("village_red_rock", () -> new JigsawStructure(BYGStructures.structure(BYGBiomeTags.HAS_VILLAGE_RED_ROCK, TerrainAdjustment.BEARD_THIN), RedRockVillagePools.RED_ROCK_VILLAGE_JIGSAW, 6, (HeightProvider)ConstantHeight.m_161956_((VerticalAnchor)VerticalAnchor.m_158922_((int)0)), true, Heightmap.Types.WORLD_SURFACE_WG));
    public static final Holder<Structure> VILLAGE_SKYRIS = BYGStructures.register("village_skyris", () -> new JigsawStructure(BYGStructures.structure(BYGBiomeTags.HAS_VILLAGE_SKYRIS, TerrainAdjustment.BEARD_THIN), SkyrisVillagePools.SKYRIS_VILLAGE_POOL, 6, (HeightProvider)ConstantHeight.m_161956_((VerticalAnchor)VerticalAnchor.m_158922_((int)0)), true, Heightmap.Types.WORLD_SURFACE_WG));
    public static final Holder<Structure> VILLAGE_RUINS = BYGStructures.register("village_ruins", () -> new JigsawStructure(BYGStructures.structure(BYGBiomeTags.HAS_VILLAGE_RUINS, TerrainAdjustment.BEARD_THIN), RuinsVillagePools.RUINS_VILLAGE_POOL, 6, (HeightProvider)ConstantHeight.m_161956_((VerticalAnchor)VerticalAnchor.m_158922_((int)0)), true, Heightmap.Types.WORLD_SURFACE_WG));
    public static final Holder<Structure> VILLAGE_TROPICAL = BYGStructures.register("village_tropical", () -> new JigsawStructure(BYGStructures.structure(BYGBiomeTags.HAS_VILLAGE_TROPICAL, TerrainAdjustment.BEARD_THIN), TropicalVillagePools.TROPICAL_VILLAGE_POOL, 6, (HeightProvider)ConstantHeight.m_161956_((VerticalAnchor)VerticalAnchor.m_158922_((int)0)), true, Heightmap.Types.WORLD_SURFACE_WG));
    public static final Holder<Structure> RED_ROCK_ARCH = BYGStructures.register("red_rock_arch", () -> new ArchStructure(BYGStructures.structure(BYGBiomeTags.HAS_RED_ROCK_ARCH, GenerationStep.Decoration.RAW_GENERATION, TerrainAdjustment.NONE), ((ArchConfiguration.Builder)Util.m_137469_((Object)new ArchConfiguration.Builder(), builder -> {
        WeightedStateProvider blockProvider = new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)BYGBlocks.RED_ROCK.defaultBlockState(), 4).m_146271_((Object)Blocks.f_50352_.m_49966_(), 1));
        builder.withSphereConfig(new NoisySphereConfig.Builder().withRadiusSettings(new NoisySphereConfig.RadiusSettings((IntProvider)UniformInt.m_146622_((int)10, (int)15), (IntProvider)UniformInt.m_146622_((int)10, (int)15), 0, (IntProvider)UniformInt.m_146622_((int)10, (int)15))).withBlockProvider((BlockStateProvider)blockProvider).withNoiseFrequency(0.1f).withTopBlockProvider((BlockStateProvider)blockProvider).build());
        builder.withMatchingBlendingFunctionChance((FloatProvider)ConstantFloat.m_146458_((float)0.2f));
        builder.withPercentageDestroyed((FloatProvider)ConstantFloat.m_146458_((float)0.0f));
        builder.withBlendingFunctionType((SimpleWeightedRandomList<BlendingFunction>)SimpleWeightedRandomList.m_146263_().m_146271_((Object)BlendingFunction.EaseOutCubic.INSTANCE, 16).m_146271_((Object)BlendingFunction.EaseInOutCirc.INSTANCE, 8).m_146271_((Object)BlendingFunction.EaseOutBounce.INSTANCE, 1).m_146270_());
    })).build()));
    public static final Holder<Structure> OVERGROWN_STONE_ARCH = BYGStructures.register("overgrown_stone_arch", () -> new ArchStructure(BYGStructures.structure(BYGBiomeTags.HAS_OVERGROWN_STONE_ARCH, GenerationStep.Decoration.RAW_GENERATION, TerrainAdjustment.NONE), ((ArchConfiguration.Builder)Util.m_137469_((Object)new ArchConfiguration.Builder(), builder -> {
        WeightedStateProvider blockProvider = new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)Blocks.f_50069_.m_49966_(), 6).m_146271_((Object)Blocks.f_50079_.m_49966_(), 3).m_146271_((Object)BYGBlocks.MOSSY_STONE.defaultBlockState(), 3).m_146271_((Object)Blocks.f_50334_.m_49966_(), 1));
        builder.withSphereConfig(new NoisySphereConfig.Builder().withRadiusSettings(new NoisySphereConfig.RadiusSettings((IntProvider)UniformInt.m_146622_((int)10, (int)15), (IntProvider)UniformInt.m_146622_((int)10, (int)15), 0, (IntProvider)UniformInt.m_146622_((int)10, (int)15))).withBlockProvider((BlockStateProvider)blockProvider).withNoiseFrequency(0.1f).withTopBlockProvider((BlockStateProvider)blockProvider).withSpawningFeatures(List.of(BYGStructurePlacedFeatures.ARCH_MOSS_PATCH, BYGStructurePlacedFeatures.ARCH_MOSS_PATCH_CEILING)).build());
        builder.withMatchingBlendingFunctionChance((FloatProvider)ConstantFloat.m_146458_((float)0.2f));
        builder.withPercentageDestroyed((FloatProvider)ConstantFloat.m_146458_((float)0.0f));
        builder.withLength((IntProvider)UniformInt.m_146622_((int)50, (int)100));
        builder.withHeight((IntProvider)UniformInt.m_146622_((int)50, (int)100));
        builder.withBlendingFunctionType((SimpleWeightedRandomList<BlendingFunction>)SimpleWeightedRandomList.m_146263_().m_146271_((Object)BlendingFunction.EaseOutQuint.INSTANCE, 5).m_146271_((Object)BlendingFunction.EaseOutElastic.INSTANCE, 2).m_146271_((Object)BlendingFunction.EaseOutBounce.INSTANCE, 5).m_146271_((Object)BlendingFunction.EaseOutCubic.INSTANCE, 5).m_146270_());
    })).build()));
    public static final Holder<Structure> STONE_ARCH = BYGStructures.register("stone_arch", () -> new ArchStructure(BYGStructures.structure(BYGBiomeTags.HAS_STONE_ARCH, GenerationStep.Decoration.RAW_GENERATION, TerrainAdjustment.NONE), ((ArchConfiguration.Builder)Util.m_137469_((Object)new ArchConfiguration.Builder(), builder -> {
        WeightedStateProvider blockProvider = new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)Blocks.f_50069_.m_49966_(), 4).m_146271_((Object)Blocks.f_50334_.m_49966_(), 1));
        builder.withSphereConfig(new NoisySphereConfig.Builder().withRadiusSettings(new NoisySphereConfig.RadiusSettings((IntProvider)UniformInt.m_146622_((int)10, (int)15), (IntProvider)UniformInt.m_146622_((int)10, (int)15), 0, (IntProvider)UniformInt.m_146622_((int)10, (int)15))).withBlockProvider((BlockStateProvider)blockProvider).withNoiseFrequency(0.1f).withTopBlockProvider((BlockStateProvider)blockProvider).withSpawningFeatures(List.of()).build());
        builder.withMatchingBlendingFunctionChance((FloatProvider)ConstantFloat.m_146458_((float)0.2f));
        builder.withPercentageDestroyed((FloatProvider)ConstantFloat.m_146458_((float)0.0f));
        builder.withLength((IntProvider)UniformInt.m_146622_((int)50, (int)100));
        builder.withHeight((IntProvider)UniformInt.m_146622_((int)50, (int)100));
        builder.withBlendingFunctionType((SimpleWeightedRandomList<BlendingFunction>)SimpleWeightedRandomList.m_146263_().m_146271_((Object)BlendingFunction.EaseOutQuint.INSTANCE, 5).m_146271_((Object)BlendingFunction.EaseOutElastic.INSTANCE, 2).m_146271_((Object)BlendingFunction.EaseOutBounce.INSTANCE, 5).m_146271_((Object)BlendingFunction.EaseOutCubic.INSTANCE, 5).m_146270_());
    })).build()));
    public static final Holder<Structure> DESTROYED_RED_ROCK_ARCH = BYGStructures.register("destroyed_red_rock_arch", () -> new ArchStructure(BYGStructures.structure(BYGBiomeTags.HAS_RED_ROCK_ARCH, GenerationStep.Decoration.RAW_GENERATION, TerrainAdjustment.NONE), ((ArchConfiguration.Builder)Util.m_137469_((Object)new ArchConfiguration.Builder(), builder -> {
        WeightedStateProvider blockProvider = new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)BYGBlocks.RED_ROCK.defaultBlockState(), 4).m_146271_((Object)Blocks.f_50352_.m_49966_(), 1));
        builder.withSphereConfig(new NoisySphereConfig.Builder().withRadiusSettings(new NoisySphereConfig.RadiusSettings((IntProvider)UniformInt.m_146622_((int)10, (int)15), (IntProvider)UniformInt.m_146622_((int)10, (int)15), 0, (IntProvider)UniformInt.m_146622_((int)10, (int)15))).withBlockProvider((BlockStateProvider)blockProvider).withNoiseFrequency(0.1f).withTopBlockProvider((BlockStateProvider)blockProvider).build());
        builder.withMatchingBlendingFunctionChance((FloatProvider)ConstantFloat.m_146458_((float)0.2f));
        builder.withPercentageDestroyed((FloatProvider)UniformFloat.m_146605_((float)0.45f, (float)1.0f));
        builder.withBlendingFunctionType((SimpleWeightedRandomList<BlendingFunction>)SimpleWeightedRandomList.m_146263_().m_146271_((Object)BlendingFunction.EaseOutCubic.INSTANCE, 16).m_146271_((Object)BlendingFunction.EaseInOutCirc.INSTANCE, 8).m_146271_((Object)BlendingFunction.EaseOutBounce.INSTANCE, 1).m_146270_());
    })).build()));
    public static final Holder<Structure> VOLCANO = BYGStructures.register("volcano", () -> new VolcanoStructure(BYGStructures.structure((TagKey<Biome>)BiomeTags.f_207603_, GenerationStep.Decoration.RAW_GENERATION, TerrainAdjustment.NONE)));

    private static Holder<Structure> register(String id, Supplier<Structure> structureSupplier) {
        return PROVIDER.register(id, structureSupplier).asHolder();
    }

    private static Structure.StructureSettings structure(TagKey<Biome> tag, TerrainAdjustment adj) {
        return StructuresAccess.structure(tag, Map.of(), GenerationStep.Decoration.SURFACE_STRUCTURES, adj);
    }

    private static Structure.StructureSettings structure(TagKey<Biome> tag, GenerationStep.Decoration decoration, TerrainAdjustment adj) {
        return StructuresAccess.structure(tag, Map.of(), decoration, adj);
    }

    public static void loadClass() {
    }
}

