/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.structure.arch;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.QuartPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import potionstudios.byg.common.world.structure.BYGStructureTypes;
import potionstudios.byg.common.world.structure.arch.ArchConfiguration;
import potionstudios.byg.common.world.structure.arch.ArchPiece;
import potionstudios.byg.util.blendingfunction.BlendingFunction;

public class ArchStructure
extends Structure {
    public static final Codec<ArchStructure> CODEC = RecordCodecBuilder.mapCodec(archStructureInstance -> archStructureInstance.group((App)ArchStructure.m_226567_((RecordCodecBuilder.Instance)archStructureInstance), (App)ArchConfiguration.CODEC.fieldOf("settings").forGetter(p_227656_ -> p_227656_.archConfiguration)).apply((Applicative)archStructureInstance, ArchStructure::new)).codec();
    public static final int PIECE_BB_EXPANSION = 5;
    private final ArchConfiguration archConfiguration;

    public ArchStructure(Structure.StructureSettings structureSettings, ArchConfiguration archConfiguration) {
        super(structureSettings);
        this.archConfiguration = archConfiguration;
    }

    private static void generatePieces(StructurePiecesBuilder piecesBuilder, Structure.GenerationContext context, ArchConfiguration config) {
        Long2ObjectOpenHashMap newSortedPositions;
        WorldgenRandom random = context.f_226626_();
        RandomState randomState = context.f_226624_();
        double fullRange = Math.PI * 2;
        double ninetyDegrees = fullRange / 4.0;
        double angle = random.m_188500_() * fullRange;
        ChunkPos chunkPos = context.f_226628_();
        int blockX = chunkPos.m_151382_(random.m_188503_(16));
        int blockZ = chunkPos.m_151391_(random.m_188503_(16));
        ChunkGenerator generator = context.f_226622_();
        int length = config.length().m_214085_((RandomSource)random) / 2;
        int archHeight = config.height().m_214085_((RandomSource)random);
        BlockPos center = new BlockPos(blockX, generator.m_214096_(blockX, blockZ, Heightmap.Types.OCEAN_FLOOR_WG, context.f_226629_(), randomState) + archHeight, blockZ);
        double xOffset = Math.sin(angle) * (double)length;
        double zOffset = Math.cos(angle) * (double)length;
        Long2ObjectOpenHashMap chunkSortedPositions = new Long2ObjectOpenHashMap();
        float percentageDestroyed = 1.0f - config.percentageDestroyed().m_214084_((RandomSource)random);
        float percentageDestroyed2 = 1.0f - config.percentageDestroyed().m_214084_((RandomSource)random);
        BlockPos start = center.m_7637_(-xOffset, 0.0, -zOffset);
        start = new BlockPos(start.m_123341_(), generator.m_214096_(start.m_123341_(), start.m_123343_(), Heightmap.Types.OCEAN_FLOOR_WG, context.f_226629_(), randomState) - 5, start.m_123343_());
        BlockPos end = center.m_7637_(xOffset, 0.0, zOffset);
        end = new BlockPos(end.m_123341_(), generator.m_214096_(end.m_123341_(), end.m_123343_(), Heightmap.Types.OCEAN_FLOOR_WG, context.f_226629_(), randomState) - 5, end.m_123343_());
        int points = 1000;
        if (!(config.biomeEnforcement() == ArchConfiguration.EMPTY || ArchStructure.matchesBiome(start, generator, config.biomeEnforcement(), randomState) && ArchStructure.matchesBiome(end, generator, config.biomeEnforcement(), randomState))) {
            return;
        }
        BlendingFunction blendingFunction = (BlendingFunction)config.blendingFunction().m_216820_((RandomSource)random).orElseThrow();
        BlendingFunction blendingFunction2 = random.m_188501_() < config.matchingBlendingFunctionChance().m_214084_((RandomSource)random) ? blendingFunction : (BlendingFunction)config.blendingFunction().m_216820_((RandomSource)random).orElseThrow();
        BlockPos startToCenterLastPos = null;
        BlockPos endToCenterLastPos = null;
        for (int pointCount = points; pointCount >= 1; --pointCount) {
            double factor = (double)pointCount / (double)points;
            int squareDistance = 2;
            BlockPos startToCenterLerpPos = new BlockPos(Mth.m_14139_((double)factor, (double)start.m_123341_(), (double)center.m_123341_()), blendingFunction.apply(factor, start.m_123342_(), center.m_123342_()), Mth.m_14139_((double)factor, (double)start.m_123343_(), (double)center.m_123343_()));
            if (startToCenterLastPos == null || startToCenterLastPos.m_123331_((Vec3i)startToCenterLerpPos) > (double)squareDistance) {
                if (factor > (double)percentageDestroyed) {
                    startToCenterLerpPos = new BlockPos(startToCenterLerpPos.m_123341_(), Integer.MIN_VALUE, startToCenterLerpPos.m_123343_());
                } else {
                    startToCenterLastPos = startToCenterLerpPos;
                }
                long chunkKey = ChunkPos.m_45589_((int)SectionPos.m_123171_((int)startToCenterLerpPos.m_123341_()), (int)SectionPos.m_123171_((int)startToCenterLerpPos.m_123343_()));
                ((Set)chunkSortedPositions.computeIfAbsent(chunkKey, key -> new HashSet())).add(startToCenterLerpPos);
            }
            BlockPos centerToEndLerpPos = new BlockPos(Mth.m_14139_((double)factor, (double)end.m_123341_(), (double)center.m_123341_()), blendingFunction2.apply(factor, end.m_123342_(), center.m_123342_()), Mth.m_14139_((double)factor, (double)end.m_123343_(), (double)center.m_123343_()));
            if (endToCenterLastPos != null && !(endToCenterLastPos.m_123331_((Vec3i)centerToEndLerpPos) > (double)squareDistance)) continue;
            if (factor > (double)percentageDestroyed2) {
                centerToEndLerpPos = new BlockPos(centerToEndLerpPos.m_123341_(), Integer.MIN_VALUE, centerToEndLerpPos.m_123343_());
            } else {
                endToCenterLastPos = centerToEndLerpPos;
            }
            long centerToEndChunkKey = ChunkPos.m_45589_((int)SectionPos.m_123171_((int)centerToEndLerpPos.m_123341_()), (int)SectionPos.m_123171_((int)centerToEndLerpPos.m_123343_()));
            ((Set)chunkSortedPositions.computeIfAbsent(centerToEndChunkKey, key -> new HashSet())).add(centerToEndLerpPos);
        }
        int width = config.width().m_214085_((RandomSource)random);
        double totalThicknessPoints = (double)width / 3.0;
        if (totalThicknessPoints > 1.0) {
            newSortedPositions = new Long2ObjectOpenHashMap(chunkSortedPositions.size() * (int)totalThicknessPoints);
            ObjectCollection capture = chunkSortedPositions.values();
            double wideXOffset = Math.sin(angle + ninetyDegrees);
            double wideZOffset = Math.cos(angle + ninetyDegrees);
            double widthXOffset = wideXOffset * (double)width;
            double widthZOffset = wideZOffset * (double)width;
            for (Set value : capture) {
                for (BlockPos pos : value) {
                    BlockPos start2 = pos.m_7637_(-widthXOffset, 0.0, -widthZOffset);
                    BlockPos end2 = pos.m_7637_(widthXOffset, 0.0, widthZOffset);
                    for (int thickness = (int)totalThicknessPoints; thickness >= 1; --thickness) {
                        double factor = (double)thickness / totalThicknessPoints;
                        BlockPos startToCenterLerpPos = new BlockPos(Mth.m_14139_((double)factor, (double)start2.m_123341_(), (double)pos.m_123341_()), (double)pos.m_123342_(), Mth.m_14139_((double)factor, (double)start2.m_123343_(), (double)pos.m_123343_()));
                        startToCenterLerpPos = new BlockPos(startToCenterLerpPos.m_123341_(), pos.m_123342_(), startToCenterLerpPos.m_123343_());
                        long chunkKey = ChunkPos.m_45589_((int)SectionPos.m_123171_((int)startToCenterLerpPos.m_123341_()), (int)SectionPos.m_123171_((int)startToCenterLerpPos.m_123343_()));
                        ((Set)newSortedPositions.computeIfAbsent(chunkKey, key -> new HashSet())).add(startToCenterLerpPos);
                        BlockPos centerToEndLerpPos = new BlockPos(Mth.m_14139_((double)factor, (double)end2.m_123341_(), (double)pos.m_123341_()), (double)pos.m_123342_(), Mth.m_14139_((double)factor, (double)end2.m_123343_(), (double)pos.m_123343_()));
                        centerToEndLerpPos = new BlockPos(centerToEndLerpPos.m_123341_(), pos.m_123342_(), centerToEndLerpPos.m_123343_());
                        long centerToEndChunkKey = ChunkPos.m_45589_((int)SectionPos.m_123171_((int)centerToEndLerpPos.m_123341_()), (int)SectionPos.m_123171_((int)centerToEndLerpPos.m_123343_()));
                        ((Set)newSortedPositions.computeIfAbsent(centerToEndChunkKey, key -> new HashSet())).add(centerToEndLerpPos);
                    }
                }
            }
        } else {
            newSortedPositions = chunkSortedPositions;
        }
        newSortedPositions.forEach((offsetChunkPos, set) -> {
            ChunkPos movingChunkPos = new ChunkPos(offsetChunkPos.longValue());
            piecesBuilder.m_142679_((StructurePiece)new ArchPiece((Set<BlockPos>)set, config.sphereConfig(), 0, ArchStructure.getWritableArea(movingChunkPos, context.f_226629_())));
        });
    }

    public static BoundingBox getWritableArea(ChunkPos chunkPos, LevelHeightAccessor accessor) {
        int i = chunkPos.m_45604_();
        int j = chunkPos.m_45605_();
        int k = accessor.m_141937_() + 1;
        int l = accessor.m_151558_() - 1;
        return new BoundingBox(i, k, j, i + 15, l, j + 15);
    }

    private static boolean matchesBiome(BlockPos pos, ChunkGenerator generator, TagKey<Biome> biomeTagKey, RandomState randomState) {
        return generator.m_62218_().m_203407_(QuartPos.m_175400_((int)pos.m_123341_()), QuartPos.m_175400_((int)pos.m_123342_()), QuartPos.m_175400_((int)pos.m_123343_()), randomState.m_224579_()).m_203656_(biomeTagKey);
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext generationContext) {
        return ArchStructure.m_226585_((Structure.GenerationContext)generationContext, (Heightmap.Types)Heightmap.Types.WORLD_SURFACE_WG, piecesBuilder -> ArchStructure.generatePieces(piecesBuilder, generationContext, this.archConfiguration));
    }

    public StructureType<?> m_213658_() {
        return BYGStructureTypes.ARCH.get();
    }
}

