/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.Util;
import potionstudios.byg.BYG;
import potionstudios.byg.shadow.blue.endless.jankson.api.SyntaxError;
import potionstudios.byg.util.ModPlatform;
import potionstudios.byg.util.jankson.JanksonJsonOps;
import potionstudios.byg.util.jankson.JanksonUtil;

public record SettingsConfig(boolean appendBiomePlacedFeatures, boolean appendLootTables, boolean customVillagers, boolean customStructures, boolean useBYGWorldGen) {
    public static final Supplier<Path> CONFIG_PATH = () -> ModPlatform.INSTANCE.configPath().resolve("settings.json5");
    private static SettingsConfig INSTANCE = null;
    private static final SettingsConfig DEFAULT = new SettingsConfig(true, true, true, true, true);
    public static final Codec<SettingsConfig> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.BOOL.fieldOf("add_biome_placed_features").orElse((Object)true).forGetter(config -> config.appendBiomePlacedFeatures), (App)Codec.BOOL.fieldOf("add_loot_tables").orElse((Object)true).forGetter(config -> config.appendLootTables), (App)Codec.BOOL.fieldOf("add_custom_villagers").orElse((Object)true).forGetter(config -> config.customVillagers), (App)Codec.BOOL.fieldOf("add_custom_structures").orElse((Object)true).forGetter(config -> config.customStructures), (App)Codec.BOOL.fieldOf("world_generation").orElse((Object)true).forGetter(config -> config.useBYGWorldGen)).apply((Applicative)builder, SettingsConfig::new));

    public static SettingsConfig getConfig() {
        return SettingsConfig.getConfig(false, false);
    }

    public static SettingsConfig getConfig(boolean serialize, boolean recreate) {
        if (INSTANCE == null || serialize || recreate) {
            INSTANCE = SettingsConfig.readConfig(recreate);
        }
        return INSTANCE;
    }

    public static void setConfigInstance(SettingsConfig config) {
        INSTANCE = config;
    }

    private static SettingsConfig readConfig(boolean recreate) {
        Path path = CONFIG_PATH.get();
        if (!path.toFile().exists() || recreate) {
            SettingsConfig.createConfig(path);
        }
        BYG.LOGGER.info(String.format("\"%s\" was read.", path.toString()));
        try {
            return JanksonUtil.readConfig(path, CODEC, JanksonJsonOps.INSTANCE);
        }
        catch (IOException | SyntaxError e) {
            throw new RuntimeException(e);
        }
    }

    private static void createConfig(Path path) {
        HashMap comments = (HashMap)Util.m_137469_(new HashMap(), map -> {
            map.put("add_biome_placed_features", "Add BYG's placed features to all biomes?\n\nBy disabling this, you remove BYG placed features not designated to specific biomes.\n\nTo configure the features that spawn using this, use the \"/worldgenexport\" command and edit the files found at:\n\"byg/worldgen/placed_feature/global/<decoration_stage>\"\n\"byg/worldgen/placed_feature/global/placed_feature/<feature>\"\n\"byg/worldgen/configured_feature/global/<decoration_stage>\"\nin the output folder.");
            map.put("add_loot_tables", "Add BYG items automatically to applicable loot tables?\n\nFor example BYG may add piglin trades to the piglin trade loot table.\n\nTo configure these loot tables or add your own, create a datapack with loot tables matching the following path:\n\"data/modid/append_loot_tables/file_path_to_loot_table_you_want_to_append\"\n\nExamples:\nBYG's added Piglin trades: \"data/byg/append_loot_tables/minecraft/gameplay/piglin_bartering.json\",\nBYG's added loot to abandoned mineshafts: \"data/byg/append_loot_tables/minecraft/chests/abandoned_mineshaft.json\"\nBYG's added loot to Repurposed Structure's Jungle Village Jungle House: \"data/byg/append_loot_tables/repurposed_structures/chests/villages/jungle_house.json\"\n");
            map.put("add_custom_villagers", "Add custom BYG Villagers/Structures to villages?");
            map.put("add_custom_structures", "Add custom BYG Structures?");
            map.put("world_generation", "Use BYG world generation?");
        });
        JanksonUtil.createConfig(path, CODEC, "/*\nThis file uses the \".json5\" file extension which allows for comments like this in a json file!\nYour text editor may show this file with invalid/no syntax, if so, we recommend you download:\n\nVSCode: https://code.visualstudio.com/\nJSON5 plugin(for VSCode): https://marketplace.visualstudio.com/items?itemName=mrmlnc.vscode-json5\n\nto make editing this file much easier.\n*/", comments, JanksonJsonOps.INSTANCE, DEFAULT);
    }
}

