/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.mixin.common.world.level.storage.loot;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.storage.loot.LootTables;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import potionstudios.byg.BYG;
import potionstudios.byg.config.SettingsConfig;
import potionstudios.byg.mixin.access.JsonReloadListenerAccess;

@Mixin(value={LootTables.class})
public abstract class MixinLootTableManager
extends SimpleJsonResourceReloadListener {
    public MixinLootTableManager(Gson gson, String string) {
        super(gson, string);
    }

    @Inject(method={"apply(Ljava/util/Map;Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/util/profiling/ProfilerFiller;)V"}, at={@At(value="HEAD")})
    private void appendTables(Map<ResourceLocation, JsonElement> values, ResourceManager resourceManager, ProfilerFiller profilerFiller, CallbackInfo ci) {
        if (!SettingsConfig.getConfig().appendLootTables()) {
            return;
        }
        String appendTablesDir = "append_loot_tables";
        Map resourceMap = resourceManager.m_214159_(appendTablesDir, key -> key.toString().endsWith(".json"));
        for (ResourceLocation resourceLocation : resourceMap.keySet()) {
            ResourceLocation key2 = new ResourceLocation(resourceLocation.m_135815_().replace(appendTablesDir + "/", "").replaceFirst("/", ":").replace(".json", ""));
            if (!values.containsKey(key2)) continue;
            values.get(key2).getAsJsonObject().getAsJsonArray("pools").addAll(this.extractPools(resourceManager, resourceLocation));
        }
    }

    private JsonArray extractPools(ResourceManager resourceManager, ResourceLocation location) {
        try {
            Optional optionalResource = resourceManager.m_213713_(location);
            if (optionalResource.isPresent()) {
                Resource appendedTable = (Resource)optionalResource.get();
                InputStream inputstream = appendedTable.m_215507_();
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputstream, StandardCharsets.UTF_8));
                JsonElement appendedElement = (JsonElement)GsonHelper.m_13776_((Gson)((JsonReloadListenerAccess)((Object)this)).byg_getGson(), (Reader)reader, JsonElement.class);
                return appendedElement.getAsJsonObject().getAsJsonArray("pools");
            }
        }
        catch (IOException e) {
            BYG.LOGGER.error("Could not read appended table:" + location);
            e.printStackTrace();
        }
        return new JsonArray();
    }
}

