/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.mixin.server;

import com.mojang.datafixers.DataFixer;
import java.net.Proxy;
import java.util.Map;
import java.util.function.BooleanSupplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.Services;
import net.minecraft.server.WorldStem;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.server.level.progress.ChunkProgressListenerFactory;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.WorldData;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import potionstudios.byg.common.world.feature.GlobalBiomeFeature;
import potionstudios.byg.common.world.surfacerules.BYGSurfaceRules;
import potionstudios.byg.common.world.util.BiomeSourceRepairUtils;
import potionstudios.byg.common.world.util.JigsawUtil;
import potionstudios.byg.config.ConfigVersionTracker;
import potionstudios.byg.config.SettingsConfig;
import potionstudios.byg.config.json.OverworldBiomeConfig;
import potionstudios.byg.server.command.UpdateConfigsCommand;
import potionstudios.byg.util.AddSurfaceRulesUtil;
import potionstudios.byg.util.BYGUtil;
import potionstudios.byg.util.ModPlatform;
import potionstudios.byg.util.ServerKillCountDown;

@Mixin(value={MinecraftServer.class})
public abstract class MixinMinecraftServer
implements ServerKillCountDown {
    @Shadow
    @Final
    private RegistryAccess.Frozen f_129746_;
    private long byg$killTime = -1L;
    private boolean byg$killClient = false;

    @Shadow
    public abstract WorldData m_129910_();

    @Shadow
    public abstract PlayerList m_6846_();

    @Inject(at={@At(value="RETURN")}, method={"<init>"})
    private void appendGlobalFeatures(Thread $$0, LevelStorageSource.LevelStorageAccess $$1, PackRepository $$2, WorldStem $$3, Proxy $$4, DataFixer $$5, Services $$6, ChunkProgressListenerFactory $$7, CallbackInfo ci) {
        Registry biomeRegistry = this.f_129746_.m_175515_(Registry.f_122885_);
        if (SettingsConfig.getConfig().appendBiomePlacedFeatures()) {
            Registry placedFeatureRegistry = this.f_129746_.m_175515_(Registry.f_194567_);
            for (Map.Entry biomeEntry : biomeRegistry.m_6579_()) {
                GlobalBiomeFeature.appendGlobalFeatures(((Biome)biomeEntry.getValue()).m_47536_(), (Registry<PlacedFeature>)placedFeatureRegistry);
            }
        }
        if (SettingsConfig.getConfig().useBYGWorldGen()) {
            BiomeSourceRepairUtils.repairBiomeSources((Registry<Biome>)biomeRegistry, this.m_129910_().m_5961_());
        }
        if (SettingsConfig.getConfig().customVillagers()) {
            Registry templatePoolRegistry = (Registry)this.f_129746_.m_6632_(Registry.f_122884_).orElseThrow();
            Registry processorListRegistry = (Registry)this.f_129746_.m_6632_(Registry.f_122883_).orElseThrow();
            JigsawUtil.addBYGBuildingsToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry);
        }
    }

    @Inject(method={"createLevels"}, at={@At(value="RETURN")})
    private void hackyAddSurfaceRules(ChunkProgressListener $$0, CallbackInfo ci) {
        if (SettingsConfig.getConfig().useBYGWorldGen()) {
            if (!ModPlatform.INSTANCE.isModLoaded("terrablender") && OverworldBiomeConfig.getConfig().generateOverworld()) {
                AddSurfaceRulesUtil.appendSurfaceRule(this.m_129910_(), (ResourceKey<LevelStem>)LevelStem.f_63971_, BYGSurfaceRules.OVERWORLD_SURFACE_RULES);
            }
            AddSurfaceRulesUtil.appendSurfaceRule(this.m_129910_(), (ResourceKey<LevelStem>)LevelStem.f_63972_, BYGSurfaceRules.NETHER_SURFACE_RULES);
            AddSurfaceRulesUtil.appendSurfaceRule(this.m_129910_(), (ResourceKey<LevelStem>)LevelStem.f_63973_, BYGSurfaceRules.END_SURFACE_RULES);
        }
        BYGUtil.useTagReplacements = true;
    }

    @Inject(method={"tickServer"}, at={@At(value="RETURN")})
    private void displayDisconnectWarning(BooleanSupplier $$0, CallbackInfo ci) {
        if (this.byg$killTime > 0L) {
            if (this.byg$killTime % 100L == 0L) {
                for (ServerPlayer player : this.m_6846_().m_11314_()) {
                    long killTimeInSeconds = this.byg$killTime / 20L;
                    player.m_5661_((Component)Component.m_237110_((String)"byg.serverkill.countdown", (Object[])new Object[]{killTimeInSeconds}).m_130940_(this.byg$killTime < 300L ? ChatFormatting.RED : ChatFormatting.YELLOW), false);
                }
            }
            --this.byg$killTime;
            if (this.byg$killTime == 0L) {
                UpdateConfigsCommand.backupAndKillGameInstance((MinecraftServer)this, new ConfigVersionTracker(5), this.byg$killClient);
            }
        }
    }

    @Override
    public void setKillCountdown(long killCountdownInTicks, boolean isClient) {
        this.byg$killTime = killCountdownInTicks;
        this.byg$killClient = isClient;
    }
}

