/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.annotation.Nonnull;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.orecruncher.dsurround.config.Config;
import org.orecruncher.dsurround.config.ConfigMenuBuilder;
import org.orecruncher.lib.compat.ModEnvironment;
import org.orecruncher.lib.config.ConfigGui;
import org.orecruncher.lib.fml.ClientLoginChecks;
import org.orecruncher.lib.fml.ConfigUtils;
import org.orecruncher.lib.fml.ForgeUtils;
import org.orecruncher.lib.fml.UpdateChecker;
import org.orecruncher.lib.logging.ModLog;

@Mod(value="dsurround")
public final class DynamicSurroundings {
    public static final String MOD_ID = "dsurround";
    public static final ModLog LOGGER = new ModLog(DynamicSurroundings.class);
    public static final Path CONFIG_PATH = ConfigUtils.getConfigPath("dsurround");
    public static final File DATA_PATH = Paths.get(CONFIG_PATH.toString(), "configs").toFile();
    public static final File DUMP_PATH = Paths.get(CONFIG_PATH.toString(), "dumps").toFile();

    public DynamicSurroundings() {
        ModLoadingContext.get().registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> "ANY", (remote, isServer) -> true));
        if (FMLEnvironment.dist == Dist.CLIENT) {
            FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
            FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setupComplete);
            MinecraftForge.EVENT_BUS.register((Object)this);
            Config.setup();
            DynamicSurroundings.createPath(DATA_PATH);
            DynamicSurroundings.createPath(DUMP_PATH);
            DynamicSurroundings.doConfigMenuSetup();
        }
    }

    public static void doConfigMenuSetup() {
        if (ModEnvironment.ClothAPI.isLoaded()) {
            ConfigGui.registerConfigGui(new ConfigMenuBuilder());
        } else {
            ConfigGui.registerConfigGui(new ConfigGui.InstallClothGuiFactory());
        }
    }

    private static void createPath(@Nonnull File path) {
        if (!path.exists()) {
            try {
                path.mkdirs();
            }
            catch (Throwable t) {
                LOGGER.error(t, "Unable to create data path %s", path.toString());
            }
        }
    }

    private void clientSetup(@Nonnull FMLClientSetupEvent event) {
        if (((Boolean)Config.CLIENT.logging.onlineVersionCheck.get()).booleanValue()) {
            ClientLoginChecks.register(new UpdateChecker(MOD_ID));
        }
    }

    private void setupComplete(@Nonnull FMLLoadCompleteEvent event) {
        if (LOGGER.isDebugging()) {
            LOGGER.info("Loaded Mods", new Object[0]);
            LOGGER.info("===========", new Object[0]);
            ForgeUtils.getModIdList().forEach(l -> LOGGER.info("Mod '%s' detected", l));
            LOGGER.info("Resource Packs", new Object[0]);
            LOGGER.info("==============", new Object[0]);
            ForgeUtils.getEnabledResourcePacks().forEach(l -> LOGGER.info("%s (%s)", l.m_10429_().getString(), l.m_10442_().getString()));
        }
    }
}

