/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.commands;

import com.mojang.brigadier.CommandDispatcher;
import javax.annotation.Nonnull;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import org.orecruncher.dsurround.commands.dump.DumpCommand;

@Mod.EventBusSubscriber(modid="dsurround", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CommandHelpers {
    private CommandHelpers() {
    }

    @SubscribeEvent
    public static void registerCommands(@Nonnull RegisterCommandsEvent event) {
        if (event.getCommandSelection() == Commands.CommandSelection.INTEGRATED) {
            DumpCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        }
    }

    public static void scheduleOnClientThread(Runnable runnable) {
        BlockableEventLoop scheduler = (BlockableEventLoop)LogicalSidedProvider.WORKQUEUE.get(LogicalSide.CLIENT);
        scheduler.m_18689_(runnable);
    }

    public static void sendSuccess(@Nonnull CommandSourceStack source, @Nonnull String command, @Nonnull String operation, @Nonnull String target) {
        String key = String.format("command.dsurround.%s.success", command);
        source.m_81354_((Component)Component.m_237110_((String)key, (Object[])new Object[]{operation, target}), true);
    }

    public static void sendFailure(@Nonnull CommandSourceStack source, @Nonnull String command) {
        String key = String.format("command.dsurround.%s.failure", command);
        source.m_81354_((Component)Component.m_237115_((String)key), true);
    }
}

