/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.environs.effects;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.environs.effects.BlockEffectType;
import org.orecruncher.environs.effects.JetEffect;
import org.orecruncher.environs.effects.emitters.DustJet;
import org.orecruncher.lib.WorldUtils;

@OnlyIn(value=Dist.CLIENT)
public class DustJetEffect
extends JetEffect {
    public DustJetEffect(int chance) {
        super(chance);
    }

    @Override
    @Nonnull
    public BlockEffectType getEffectType() {
        return BlockEffectType.DUST;
    }

    @Override
    public boolean canTrigger(@Nonnull BlockGetter provider, @Nonnull BlockState state, @Nonnull BlockPos pos, @Nonnull Random random) {
        return WorldUtils.isAirBlock(provider, pos.m_7495_()) && super.canTrigger(provider, state, pos, random);
    }

    @Override
    public void doEffect(@Nonnull BlockGetter provider, @Nonnull BlockState state, @Nonnull BlockPos pos, @Nonnull Random random) {
        DustJet effect = new DustJet(2, provider, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() - 0.2, (double)pos.m_123343_() + 0.5, state);
        this.addEffect(effect);
    }
}

