/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.environs.effects;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.environs.effects.BlockEffectType;
import org.orecruncher.environs.effects.JetEffect;
import org.orecruncher.environs.effects.emitters.FireJet;
import org.orecruncher.lib.WorldUtils;

@OnlyIn(value=Dist.CLIENT)
public class FireJetEffect
extends JetEffect {
    public FireJetEffect(int chance) {
        super(chance);
    }

    @Override
    @Nonnull
    public BlockEffectType getEffectType() {
        return BlockEffectType.FIRE;
    }

    @Override
    public boolean canTrigger(@Nonnull BlockGetter provider, @Nonnull BlockState state, @Nonnull BlockPos pos, @Nonnull Random random) {
        return WorldUtils.isAirBlock(provider, pos.m_7494_()) && super.canTrigger(provider, state, pos, random);
    }

    @Override
    public void doEffect(@Nonnull BlockGetter provider, @Nonnull BlockState state, @Nonnull BlockPos pos, @Nonnull Random random) {
        boolean isSolid;
        float spawnHeight;
        int blockCount;
        if (!state.m_60819_().m_76178_()) {
            blockCount = FireJetEffect.countVerticalBlocks(provider, pos, LAVA_PREDICATE, -1);
            spawnHeight = (float)pos.m_123342_() + state.m_60819_().m_76182_() + 0.1f;
            isSolid = false;
        } else {
            VoxelShape shape = state.m_60808_(provider, pos);
            if (shape.m_83281_()) {
                return;
            }
            double blockHeight = shape.m_83215_().f_82292_;
            spawnHeight = (float)((double)pos.m_123342_() + blockHeight);
            isSolid = true;
            blockCount = state.m_60815_() ? 2 : 1;
        }
        if (blockCount > 0) {
            FireJet effect = new FireJet(blockCount, provider, (double)pos.m_123341_() + 0.5, spawnHeight, (double)pos.m_123343_() + 0.5, isSolid);
            this.addEffect(effect);
        }
    }
}

