/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.environs.effects;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.environs.effects.BlockEffectType;
import org.orecruncher.environs.effects.JetEffect;
import org.orecruncher.environs.effects.emitters.WaterSplashJet;
import org.orecruncher.lib.WorldUtils;

@OnlyIn(value=Dist.CLIENT)
public class WaterfallSplashEffect
extends JetEffect {
    private static final Vec3i[] cardinal_offsets = new Vec3i[]{new Vec3i(-1, 0, 0), new Vec3i(1, 0, 0), new Vec3i(0, 0, -1), new Vec3i(0, 0, 1)};

    public WaterfallSplashEffect(int chance) {
        super(chance);
    }

    @Override
    @Nonnull
    public BlockEffectType getEffectType() {
        return BlockEffectType.SPLASH;
    }

    private static boolean isUnboundedLiquid(BlockGetter provider, BlockPos pos) {
        for (Vec3i cardinal_offset : cardinal_offsets) {
            BlockPos tp = pos.m_121955_(cardinal_offset);
            BlockState state = provider.m_8055_(tp);
            if (state.m_60767_() == Material.f_76296_) {
                return true;
            }
            FluidState fluidState = state.m_60819_();
            int height = fluidState.m_76186_();
            if (height <= 0 || height >= 8) continue;
            return true;
        }
        return false;
    }

    private static boolean isBoundedLiquid(BlockGetter provider, BlockPos pos) {
        for (Vec3i cardinal_offset : cardinal_offsets) {
            BlockPos tp = pos.m_121955_(cardinal_offset);
            BlockState state = provider.m_8055_(tp);
            if (state.m_60767_() == Material.f_76296_) {
                return false;
            }
            FluidState fluidState = state.m_60819_();
            if (fluidState.m_76178_()) continue;
            if (((Boolean)fluidState.m_61143_((Property)FlowingFluid.f_75947_)).booleanValue()) {
                return false;
            }
            int height = fluidState.m_76186_();
            if (height <= 0 || height >= 8) continue;
            return false;
        }
        return true;
    }

    private int liquidBlockCount(BlockGetter provider, BlockPos pos) {
        return WaterfallSplashEffect.countVerticalBlocks(provider, pos, FLUID_PREDICATE, 1);
    }

    public static boolean isValidSpawnBlock(@Nonnull BlockGetter provider, @Nonnull BlockPos pos) {
        return WaterfallSplashEffect.isValidSpawnBlock(provider, provider.m_8055_(pos), pos);
    }

    private static boolean isValidSpawnBlock(BlockGetter provider, BlockState state, BlockPos pos) {
        if (state.m_60819_().m_76178_()) {
            return false;
        }
        if (provider.m_6425_(pos.m_7494_()).m_76178_()) {
            return false;
        }
        if (WaterfallSplashEffect.isUnboundedLiquid(provider, pos)) {
            BlockPos down = pos.m_7495_();
            if (WorldUtils.isBlockSolid(provider, down)) {
                return true;
            }
            return WaterfallSplashEffect.isBoundedLiquid(provider, down);
        }
        return false;
    }

    @Override
    public boolean canTrigger(@Nonnull BlockGetter provider, @Nonnull BlockState state, @Nonnull BlockPos pos, @Nonnull Random random) {
        return super.canTrigger(provider, state, pos, random) && WaterfallSplashEffect.isValidSpawnBlock(provider, state, pos);
    }

    @Override
    public void doEffect(@Nonnull BlockGetter provider, @Nonnull BlockState state, @Nonnull BlockPos pos, @Nonnull Random random) {
        int strength = this.liquidBlockCount(provider, pos);
        if (strength > 1) {
            float height = state.m_60819_().m_76155_(provider, pos) + 0.1f;
            WaterSplashJet effect = new WaterSplashJet(strength, provider, pos, (double)height);
            this.addEffect(effect);
        }
    }
}

