/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.environs.effects.emitters;

import net.minecraft.client.particle.FlameParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.environs.effects.emitters.Jet;
import org.orecruncher.lib.GameUtils;
import org.orecruncher.sndctrl.api.acoustics.Library;

@OnlyIn(value=Dist.CLIENT)
public class FireJet
extends Jet {
    private static final ResourceLocation FIRE_ACOUSTIC = new ResourceLocation("block.fire.ambient");
    protected final boolean isLava;
    protected final ParticleOptions particleType;
    protected final boolean isSolid;
    protected boolean soundFired;

    public FireJet(int strength, BlockGetter world, double x, double y, double z, boolean isSolid) {
        super(strength, world, x, y, z);
        this.isLava = !isSolid && RANDOM.nextInt(3) == 0;
        this.particleType = this.isLava ? ParticleTypes.f_123756_ : ParticleTypes.f_123744_;
        this.isSolid = isSolid;
    }

    @Override
    protected void soundUpdate() {
        if (!this.soundFired) {
            this.soundFired = true;
            if (this.jetStrength > 1) {
                Library.resolve(FIRE_ACOUSTIC).playAt(this.getPos());
            }
        }
    }

    @Override
    protected void spawnJetParticle() {
        Particle particle;
        double speedY = this.isLava ? 0.0 : (double)this.jetStrength / 10.0;
        float scale = this.jetStrength;
        double x = this.posX;
        double z = this.posZ;
        if (this.isSolid) {
            x += (RANDOM.nextDouble() - RANDOM.nextDouble()) * 0.5;
            z += (RANDOM.nextDouble() - RANDOM.nextDouble()) * 0.5;
            if (this.jetStrength == 1) {
                speedY *= 0.5;
                scale *= 0.5f;
            }
        }
        if ((particle = GameUtils.getMC().f_91061_.m_107370_(this.particleType, x, this.posY, z, 0.0, speedY, 0.0)) instanceof FlameParticle) {
            particle.m_6569_(scale);
        }
    }
}

