/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.environs.fog;

import javax.annotation.Nonnull;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ViewportEvent;
import org.orecruncher.environs.config.Config;
import org.orecruncher.environs.fog.FogResult;
import org.orecruncher.environs.fog.VanillaFogRangeCalculator;
import org.orecruncher.environs.handlers.CommonState;
import org.orecruncher.lib.GameUtils;
import org.orecruncher.lib.WorldUtils;

@OnlyIn(value=Dist.CLIENT)
public class BedrockFogRangeCalculator
extends VanillaFogRangeCalculator {
    protected final FogResult cached = new FogResult();
    protected double skyLight;

    public BedrockFogRangeCalculator() {
        super("BedrockFogRangeCalculator");
    }

    @Override
    public boolean enabled() {
        return (Boolean)Config.CLIENT.fog.enableBedrockFog.get();
    }

    @Override
    @Nonnull
    public FogResult calculate(@Nonnull ViewportEvent.RenderFog event) {
        this.cached.set(event);
        if (!CommonState.getDimensionInfo().isFlatWorld() && WorldUtils.hasVoidParticles((Level)GameUtils.getWorld())) {
            Player player = GameUtils.getPlayer();
            double factor = (Mth.m_14139_((double)event.getPartialTick(), (double)player.f_19791_, (double)player.m_20186_()) + 4.0) / 32.0;
            double d0 = this.skyLight / 16.0 + factor;
            float end = event.getFarPlaneDistance();
            if (d0 < -63.0) {
                float f2;
                if (d0 < -64.0) {
                    d0 = 0.0;
                }
                if ((f2 = 100.0f * (float)(d0 *= d0)) < -59.0f) {
                    f2 = 5.0f;
                }
                if (end > f2) {
                    end = f2;
                }
            }
            this.cached.setScaled(end, 0.75f);
        }
        return this.cached;
    }

    @Override
    public void tick() {
        this.skyLight = GameUtils.getPlayer().m_213856_();
    }
}

